/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.NoSuchModuleException;
import java.util.HashMap;

public class ModulePool {
    private HashMap<String, Module> modules;

    private ModulePool() {
        this.setModules(new HashMap<String, Module>());
    }

    public HashMap<String, Module> getModules() {
        return this.modules;
    }

    private void setModules(HashMap<String, Module> aHashMap) {
        this.modules = aHashMap;
    }

    public static ModulePool getInstance() {
        return new ModulePool();
    }

    public boolean isRegistered(String moduleName) {
        return this.modules.containsKey(moduleName);
    }

    public boolean registerModule(Module m) {
        if (this.getModules().containsKey(m.getComponentName())) {
            return false;
        }
        this.getModules().put(m.getComponentName(), m);
        return true;
    }

    public void unregisterModule(Module m) {
        this.getModules().remove(m.getComponentName());
    }

    public Module getModuleViaName(String moduleName) throws NoSuchModuleException {
        Module module = this.getModules().get(moduleName);
        if (null == module) {
            throw new NoSuchModuleException("No module " + moduleName + " found in registry");
        }
        return module;
    }
}

