/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.update;

import it.jrc.osint.update.SoftwareUpdatePreferences;
import it.jrc.osint.update.UpdatePlugin;
import it.jrc.osint.util.DebugUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class P2Util {
    public static void checkForUpdates() {
        SoftwareUpdatePreferences prefs = UpdatePlugin.getPlugin().getPreferences();
        if (!prefs.checkOnStartup()) {
            return;
        }
        if (DebugUtil.inDebugMode()) {
            return;
        }
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    P2Util.doCheckForUpdates(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            UpdatePlugin.log(e);
        }
        catch (InterruptedException e) {
            UpdatePlugin.log(e);
        }
        catch (Exception e) {
            UpdatePlugin.log(e);
        }
    }

    private static void doCheckForUpdates(IProgressMonitor monitor) {
        BundleContext bundleContext = UpdatePlugin.getPlugin().getBundle().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (reference == null) {
            UpdatePlugin.log((IStatus)new Status(4, "it.jrc.osint.update", "No provisioning agent found.  This application is not set up for updates."));
            return;
        }
        IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(reference);
        try {
            IStatus updateStatus = P2Util.checkForUpdates(agent, monitor);
            UpdatePlugin.log(updateStatus);
            if (updateStatus.getCode() == 10000) {
                return;
            }
            if (updateStatus.getSeverity() != 4) {
                PlatformUI.getWorkbench().restart();
            }
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }

    static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        IStatus status = operation.resolveModal(monitor);
        if (status.getCode() == 10000) {
            return status;
        }
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status.getSeverity() != 4) {
            ProvisioningJob job = operation.getProvisioningJob(monitor);
            if (job == null) {
                return new Status(4, "it.jrc.osint.update", "ProvisioningJob could not be created - does this application support p2 software installation?");
            }
            status = job.runModal(monitor);
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
        }
        return status;
    }
}

