/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.grabber.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.rss.RSS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;

public class RSSFileConsumer
implements Consumer<DocumentMetaItem> {
    private static final Logger log = LogManager.getLogger((String)RSSFileConsumer.class.getName());
    private RSS rss;
    private File outputFile;
    private int consumedItems = 0;

    public RSSFileConsumer(RSS rss, File outputFolder, String fileName) {
        this.rss = rss;
        this.outputFile = new File(outputFolder, fileName);
    }

    public void consume(DocumentMetaItem anItem) {
        if (this.rss == null || anItem == null) {
            return;
        }
        this.rss.addItem(anItem.getItem());
        ++this.consumedItems;
    }

    public int consumedItemCount() {
        return this.consumedItems;
    }

    public synchronized void finish() {
        block13: {
            if (this.rss == null) {
                return;
            }
            OutputStreamWriter outWriter = null;
            try {
                try {
                    outWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "utf-8");
                    this.rss.toXML((Writer)outWriter);
                    outWriter.flush();
                    this.rss = null;
                }
                catch (Throwable t) {
                    log.error("Failed to write RSS output file ", t);
                    if (outWriter == null) break block13;
                    try {
                        outWriter.close();
                    }
                    catch (IOException e) {
                        log.error("Failed to close output writer", (Throwable)e);
                    }
                }
            }
            finally {
                if (outWriter != null) {
                    try {
                        outWriter.close();
                    }
                    catch (IOException e) {
                        log.error("Failed to close output writer", (Throwable)e);
                    }
                }
            }
        }
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setContext(ProcessingContext context) {
    }

    public Set<String> getConsumedItemIds() {
        return null;
    }

    public void reset() {
        this.consumedItems = 0;
    }
}

