/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.ui.browser;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchPlugin;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.ui.browser.OSINTWebBrowserEditor;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;

public class BrowserEditorMatchingStrategy
implements IEditorMatchingStrategy {
    private static final Logger log = LogManager.getLogger((String)BrowserEditorMatchingStrategy.class.getName());

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        String editorId = editorRef.getId();
        if (editorId == null || !editorId.equals("it.jrc.osint.ui.browser.editor")) {
            return false;
        }
        if (input instanceof IFileEditorInput) {
            IFile inputFile = ((IFileEditorInput)input).getFile();
            if (inputFile == null || !"obm".equals(inputFile.getFileExtension())) {
                return false;
            }
            SearchPlugin.getPlugin();
            SearchService searchService = SearchPlugin.getSearchService();
            InputStream in = null;
            URLBookmark bookmark = null;
            try {
                in = inputFile.getContents();
                bookmark = searchService.loadBookmark(in);
            }
            catch (Throwable t) {
                log.error("Failed to read URL Bookmark from file " + inputFile.getName(), t);
            }
            if (bookmark == null) {
                return false;
            }
            OSINTWebBrowserEditor browserEditor = (OSINTWebBrowserEditor)editorRef.getEditor(false);
            if (browserEditor == null) {
                return false;
            }
            return bookmark.getURL().equals(browserEditor.getURL());
        }
        return false;
    }
}

