/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.chromium;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.chromium.cef_app_t;
import org.eclipse.swt.internal.chromium.cef_base_ref_counted_t;
import org.eclipse.swt.internal.chromium.cef_browser_process_handler_t;
import org.eclipse.swt.internal.chromium.cef_client_t;
import org.eclipse.swt.internal.chromium.cef_context_menu_handler_t;
import org.eclipse.swt.internal.chromium.cef_cookie_visitor_t;
import org.eclipse.swt.internal.chromium.cef_display_handler_t;
import org.eclipse.swt.internal.chromium.cef_focus_handler_t;
import org.eclipse.swt.internal.chromium.cef_jsdialog_handler_t;
import org.eclipse.swt.internal.chromium.cef_life_span_handler_t;
import org.eclipse.swt.internal.chromium.cef_load_handler_t;
import org.eclipse.swt.internal.chromium.cef_request_handler_t;
import org.eclipse.swt.internal.chromium.cef_string_visitor_t;

public class CEFFactory {
    public static final int PID_BROWSER = 0;
    public static final int PID_RENDERER = 1;

    public static void create(String cefrustPath) {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        ArrayList<String> toLoad = new ArrayList<String>();
        if (isWin) {
            toLoad.add(String.valueOf(cefrustPath) + File.separator + "chrome_elf.dll");
            toLoad.add(String.valueOf(cefrustPath) + File.separator + "libcef.dll");
        } else if (isMac) {
            toLoad.add(String.valueOf(cefrustPath) + "/Chromium Embedded Framework.framework/Chromium Embedded Framework");
        } else {
            toLoad.add(String.valueOf(cefrustPath) + "/libcef.so");
        }
        for (String lib : toLoad) {
            try {
                Library.loadLibrary((String)lib, (boolean)false);
            }
            catch (UnsatisfiedLinkError e) {
                if (!isWin && !isMac && e.getMessage().contains("libgconf")) {
                    try {
                        Library.loadLibrary((String)(String.valueOf(cefrustPath) + "/libgconf-2.so.4"), (boolean)false);
                    }
                    catch (UnsatisfiedLinkError e1) {
                        throw e;
                    }
                    Library.loadLibrary((String)lib, (boolean)false);
                    return;
                }
                throw e;
            }
        }
    }

    public static cef_app_t newApp() {
        cef_app_t st = new cef_app_t();
        st.base = CEFFactory.setBase(st, cef_app_t.sizeof);
        return st;
    }

    public static cef_browser_process_handler_t newBrowserProcessHandler() {
        cef_browser_process_handler_t st = new cef_browser_process_handler_t();
        st.base = CEFFactory.setBase(st, cef_browser_process_handler_t.sizeof);
        return st;
    }

    public static cef_client_t newClient() {
        cef_client_t st = new cef_client_t();
        st.base = CEFFactory.setBase(st, cef_client_t.sizeof);
        return st;
    }

    public static cef_focus_handler_t newFocusHandler() {
        cef_focus_handler_t st = new cef_focus_handler_t();
        st.base = CEFFactory.setBase(st, cef_focus_handler_t.sizeof);
        return st;
    }

    public static cef_life_span_handler_t newLifeSpanHandler() {
        cef_life_span_handler_t st = new cef_life_span_handler_t();
        st.base = CEFFactory.setBase(st, cef_life_span_handler_t.sizeof);
        return st;
    }

    public static cef_load_handler_t newLoadHandler() {
        cef_load_handler_t st = new cef_load_handler_t();
        st.base = CEFFactory.setBase(st, cef_load_handler_t.sizeof);
        return st;
    }

    public static cef_display_handler_t newDisplayHandler() {
        cef_display_handler_t st = new cef_display_handler_t();
        st.base = CEFFactory.setBase(st, cef_display_handler_t.sizeof);
        return st;
    }

    public static cef_request_handler_t newRequestHandler() {
        cef_request_handler_t st = new cef_request_handler_t();
        st.base = CEFFactory.setBase(st, cef_request_handler_t.sizeof);
        return st;
    }

    public static cef_jsdialog_handler_t newJsDialogHandler() {
        cef_jsdialog_handler_t st = new cef_jsdialog_handler_t();
        st.base = CEFFactory.setBase(st, cef_jsdialog_handler_t.sizeof);
        return st;
    }

    public static cef_context_menu_handler_t newContextMenuHandler() {
        cef_context_menu_handler_t st = new cef_context_menu_handler_t();
        st.base = CEFFactory.setBase(st, cef_context_menu_handler_t.sizeof);
        return st;
    }

    public static cef_string_visitor_t newStringVisitor() {
        cef_string_visitor_t st = new cef_string_visitor_t();
        st.base = CEFFactory.setBase(st, cef_string_visitor_t.sizeof);
        return st;
    }

    public static cef_cookie_visitor_t newCookieVisitor() {
        cef_cookie_visitor_t st = new cef_cookie_visitor_t();
        st.base = CEFFactory.setBase(st, cef_cookie_visitor_t.sizeof);
        return st;
    }

    private static cef_base_ref_counted_t setBase(Object st, int sizeof) {
        cef_base_ref_counted_t base = new cef_base_ref_counted_t();
        base.size = sizeof;
        base.add_ref = 0L;
        base.has_one_ref = 0L;
        base.release = 0L;
        return base;
    }

    public static interface EvalReturned {
        public void invoke(int var1, int var2, long var3);
    }

    public static enum ReturnType {
        Double(0),
        Bool(1),
        Str(2),
        Null(3),
        Array(4),
        Error(5);

        private int value;

        private ReturnType(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public static ReturnType from(String v) {
            try {
                int value = Integer.parseInt(v);
                ReturnType[] returnTypeArray = ReturnType.values();
                int n = returnTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReturnType rt = returnTypeArray[n2];
                    if (rt.intValue() == value) {
                        return rt;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new IllegalArgumentException(v);
        }
    }
}

