/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.emmtools;

import it.jrc.dispatcher.Dispatcher;
import it.jrc.emmtools.LanguageMatch;
import it.jrc.emmtools.LanguageScore;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Scheduler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProcessRSS
extends Thread {
    private static Scheduler scheduler;
    private static Dispatcher dispatcher;
    private RSSParser rssParser;
    private Logger logger = null;
    private boolean bRunning;
    private MatchWords matcher;
    private LanguageMatch matchResult;

    public ProcessRSS(String paramString, Scheduler paramScheduler, Dispatcher paramDispatcher, LanguageMatch paramLanguageMatch) {
        super(paramString);
        this.logger = Logger.getLogger((String)paramString);
        this.rssParser = new RSSParser();
        scheduler = paramScheduler;
        dispatcher = paramDispatcher;
        this.matcher = MatchWords.getInstance((String)"LanguageDetector");
        this.matchResult = paramLanguageMatch;
        this.bRunning = true;
    }

    @Override
    public void run() {
        while (this.bRunning) {
            CachedJob localCachedJob = (CachedJob)scheduler.next();
            boolean bl = this.bRunning = localCachedJob != null;
            if (!this.bRunning) continue;
            try {
                Object localObject1;
                RSS localRSS = this.rssParser.parse(localCachedJob.getReader());
                this.logger.info((Object)("processing job " + localCachedJob.getId() + " language=" + localRSS.getLanguage()));
                HashMap<String, Vector<RSSItem>> localHashMap = new HashMap<String, Vector<RSSItem>>();
                Vector localVector1 = localRSS.getItems();
                Iterator localIterator = localVector1.iterator();
                while (localIterator.hasNext()) {
                    String str2;
                    localObject1 = (RSSItem)localIterator.next();
                    this.matchResult.init();
                    this.matcher.match(localObject1.getTitle() + localObject1.getText(), (MatchResult)this.matchResult);
                    LanguageScore[] localObject2 = this.matchResult.getScores();
                    String str1 = localObject1.getLanguage();
                    if (localObject2[0].score == 0.0) {
                        this.logger.info((Object)("could not detect language for " + localObject1.getTitle() + "(" + localObject1.getGuid() + ")"));
                        continue;
                    }
                    if (!(localObject2[0].score > 90.0) || localObject2[0].language.equals(str1) || ((str2 = localObject2[0].language).equals("mo") || str2.equals("ro")) && (str1.equals("mo") || str1.equals("ro")) || (str2.equals("hr") || str2.equals("sr") || str2.equals("bs")) && (str1.equals("hr") || str1.equals("sr") || str1.equals("bs")) || (str2.equals("uk") || str2.equals("ru") || str2.equals("be")) && (str1.equals("uk") || str1.equals("ru") || str1.equals("be"))) continue;
                    this.logger.info((Object)("language " + str2 + " found instead of " + str1 + " for " + localObject1.getTitle() + "(" + localObject1.getGuid() + ")"));
                    localIterator.remove();
                    localObject1.setLanguage(str2);
                    Vector<RSSItem> localVector2 = (Vector<RSSItem>)localHashMap.get(str2);
                    if (localVector2 == null) {
                        localVector2 = new Vector<RSSItem>();
                        localHashMap.put(str2, localVector2);
                    }
                    localVector2.add((RSSItem)localObject1);
                }
                if (localRSS.getItems().size() > 0) {
                    this.logger.info((Object)("found " + localRSS.getItems().size() + " for " + localRSS.getLanguage()));
                    dispatcher.send(localRSS.getGuid(), localRSS.toString());
                }
                localObject1 = localHashMap.keySet().iterator();
                while (((Iterator)localObject1).hasNext()) {
                    String localObject3 = (String)((Iterator)localObject1).next();
                    localRSS.setLanguage(localObject3);
                    localRSS.setItems((Vector)localHashMap.get(localObject3));
                    this.logger.info((Object)("found " + localRSS.getItems().size() + " for " + localRSS.getLanguage()));
                    dispatcher.send(localRSS.getGuid(), localRSS.toString());
                }
                localCachedJob.delete();
            }
            catch (Exception localException) {
                this.logger.error((Object)("error processing RSS for " + localCachedJob.getId()), (Throwable)localException);
            }
        }
        this.logger.info((Object)(this.getName() + " is terminating"));
    }

    public void end() {
        this.bRunning = false;
        this.interrupt();
        this.matcher = null;
    }
}

