/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MarkerUtil {
    private static final Logger log = LogManager.getLogger((String)MarkerUtil.class.getName());

    public static void clean(ResourceId id, String markerType) {
        WorkspaceService ws = WorkspacePlugin.getWorkspaceService();
        IResource aResource = ws.getResource(id);
        MarkerUtil.clean(aResource, markerType);
    }

    public static void clean(IPath aResourcePath, String markerType) {
        if (aResourcePath == null) {
            return;
        }
        IResource aResource = ResourcesPlugin.getWorkspace().getRoot().findMember(aResourcePath);
        if (aResource != null) {
            MarkerUtil.clean(aResource, markerType);
        }
    }

    public static void clean(IResource aResource, String markerType) {
        if (aResource == null) {
            return;
        }
        if (!aResource.exists()) {
            return;
        }
        try {
            if (aResource instanceof IProject) {
                IProject project = (IProject)aResource;
                project.deleteMarkers(markerType, true, 2);
            }
            if (aResource instanceof IFolder) {
                IFolder folder = (IFolder)aResource;
                folder.deleteMarkers(markerType, true, 2);
            }
            if (aResource instanceof IFile) {
                IFile file = (IFile)aResource;
                file.deleteMarkers(markerType, true, 0);
            }
        }
        catch (Throwable t) {
            log.error("Failed to delete marker on resource " + aResource.getProjectRelativePath());
        }
    }

    public static void mark(IPath resourcePath, String markerType) {
        IResource aResource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
        if (aResource != null) {
            MarkerUtil.mark(aResource, markerType);
        }
    }

    public static void mark(IResource aResource, String markerType) {
        if (aResource == null || !aResource.exists()) {
            return;
        }
        if (aResource instanceof IFile) {
            try {
                aResource.createMarker(markerType);
            }
            catch (Throwable t) {
                log.error("Failed to set marker for resource " + aResource.getProjectRelativePath(), t);
            }
            return;
        }
        if (aResource instanceof IContainer) {
            IContainer folder = (IContainer)aResource;
            IResource[] members = null;
            try {
                members = folder.members();
            }
            catch (CoreException e) {
                log.error("Failed to mark members of " + aResource, (Throwable)e);
            }
            if (members != null) {
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource aMember = iResourceArray[n2];
                    MarkerUtil.mark(aMember, markerType);
                    ++n2;
                }
            }
        }
    }

    public static void mark(ResourceId id, String markerType) {
        if (id == null) {
            return;
        }
        WorkspaceService ws = WorkspacePlugin.getWorkspaceService();
        IResource aResource = ws.getResource(id);
        MarkerUtil.mark(aResource, markerType);
    }

    public static Set<ResourceId> getMarkedDocuments(IResource buildParentResource, String markerType) {
        HashSet<ResourceId> docIds = new HashSet<ResourceId>();
        if (buildParentResource == null) {
            return docIds;
        }
        try {
            IMarker[] extractionMarkers = buildParentResource.findMarkers(markerType, true, 2);
            if (extractionMarkers == null || extractionMarkers.length == 0) {
                return docIds;
            }
            WorkspaceService ws = WorkspacePlugin.getWorkspaceService();
            IMarker[] iMarkerArray = extractionMarkers;
            int n = extractionMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker aMarker = iMarkerArray[n2];
                IResource markedResource = aMarker.getResource();
                if (markedResource.exists() && markedResource instanceof IFile) {
                    ResourceId docId = ws.getId(((IFile)markedResource).getFullPath());
                    docIds.add(docId);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error("Failed to retrieve markers ", (Throwable)e);
        }
        return docIds;
    }

    public static boolean isMarked(IResource aResource, String markerType) {
        if (aResource == null || !aResource.exists()) {
            return false;
        }
        try {
            IMarker[] markers = aResource.findMarkers(markerType, true, 2);
            if (markers != null && markers.length > 0) {
                return true;
            }
        }
        catch (Throwable t) {
            log.error("Failed to retrieve marker status for resource " + aResource.getFullPath(), t);
        }
        return false;
    }

    public static Map<String, Object> getMarkerAttributes(IResource aResource, String markerType) {
        if (aResource == null || !aResource.exists()) {
            return Collections.emptyMap();
        }
        try {
            IMarker[] markers = aResource.findMarkers(markerType, false, 0);
            if (markers != null && markers.length > 0) {
                return markers[0].getAttributes();
            }
        }
        catch (Throwable t) {
            log.error("Failed to retrieve marker attributes for resource " + aResource.getFullPath(), t);
        }
        return Collections.emptyMap();
    }
}

