/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ResourceEvent {
    private static final Logger log = LogManager.getLogger((String)ResourceEvent.class.getName());
    private EventType type;
    private IResource resource;
    private ResourceId fileId;
    private IPath movedFromPath;
    private IPath movedToPath;

    public ResourceEvent(IResource resource, EventType type) {
        this.resource = resource;
        this.type = type;
    }

    public IPath getMovedFromPath() {
        if (this.movedFromPath == null) {
            return this.getResourcePath();
        }
        return this.movedFromPath;
    }

    public IPath getMovedToPath() {
        return this.movedToPath;
    }

    public IResource getResource() {
        return this.resource;
    }

    public ResourceId getFileId() {
        return this.fileId;
    }

    public IPath getResourcePath() {
        return this.resource.getFullPath();
    }

    public EventType getType() {
        return this.type;
    }

    public void setMovedFromPath(IPath movedFromPath) {
        this.movedFromPath = movedFromPath;
    }

    public void setMovedToPath(IPath movedToPath) {
        this.movedToPath = movedToPath;
    }

    public String toString() {
        return String.valueOf(this.getType().name()) + ":" + this.getResourcePath();
    }

    public void setFileId(ResourceId id) {
        if (id == null) {
            log.warn("Event " + this.toString() + " received null resource id");
        }
        this.fileId = id;
    }

    public static enum EventType {
        CREATED,
        DELETED,
        MOVED,
        CONTENT_CHANGED;

    }
}

