/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.BaseProject;
import it.jrc.osint.workspace.ProjectCreationParticipant;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import it.jrc.osint.workspace.WorkspaceUtil;
import it.jrc.osint.workspace.internal.ProjectLayout;
import it.jrc.osint.workspace.internal.WorkspaceServiceEventImpl;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

abstract class BaseProjectImpl
implements BaseProject {
    private static final Logger log = LogManager.getLogger((String)BaseProjectImpl.class.getName());
    private ResourceId id;
    private String cachedName;
    protected WorkspaceServiceImpl workspaceService;

    protected BaseProjectImpl(ResourceId projectId, WorkspaceServiceImpl workspaceService, String name) {
        this.id = projectId;
        this.workspaceService = workspaceService;
        this.cachedName = name;
    }

    @Override
    public abstract boolean isCaseProject();

    @Override
    public abstract boolean isConfigProject();

    @Override
    public ResourceId getId() {
        return this.id;
    }

    @Override
    public boolean contains(ResourceId resourceId) {
        IPath resourcePath = this.workspaceService.getPath(resourceId);
        if (resourcePath == null) {
            return false;
        }
        IPath projectPath = this.getProject().getFullPath();
        return projectPath.isPrefixOf(resourcePath);
    }

    @Override
    public String getName() {
        IProject project = this.getProject();
        if (project == null) {
            return this.cachedName;
        }
        this.cachedName = project.getName();
        return this.cachedName;
    }

    @Override
    public IProject getProject() {
        IPath projectPath = this.workspaceService.getPath(this.id);
        if (projectPath == null) {
            log.warn("Failed to obtain IProject for project id " + this.id);
            return null;
        }
        String projectName = projectPath.lastSegment();
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    @Override
    public IPath getFullPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public IFolder getSystemFolder(String folderConstant) {
        return this.getProject().getFolder(this.getProjectLayout().getFolderPath(folderConstant));
    }

    @Override
    public IFolder addUniqueFolder(IContainer parentContainer, String folderName, IProgressMonitor monitor) {
        if (!parentContainer.isAccessible()) {
            log.debug("Parent container is not accessible");
            return null;
        }
        String resultFolderName = WorkspaceUtil.getNextFolderName(parentContainer, folderName, 0);
        Path resultFolderPath = new Path(resultFolderName);
        final IFolder resultFolder = parentContainer.getFolder((IPath)resultFolderPath);
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        if (!resultFolder.exists()) {
                            resultFolder.create(true, true, monitor);
                        }
                    }
                    catch (Throwable t) {
                        throw new CoreException((IStatus)new Status(4, "it.jrc.osint.workspace", "Failed to add folder to project", t));
                    }
                }
            }, (ISchedulingRule)parentContainer, 1, monitor);
            return resultFolder;
        }
        catch (CoreException e) {
            log.error("Failed to add folder " + folderName + " into workspace ", (Throwable)e);
            return null;
        }
    }

    @Override
    public IPath deleteFile(ResourceId id) {
        if (id == null) {
            return null;
        }
        if (!this.contains(id)) {
            return null;
        }
        IPath resourcePath = this.workspaceService.getPath(id);
        final IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
        if (!(resource instanceof IFile)) {
            return null;
        }
        IContainer parentContainer = resource.getParent();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        resource.delete(true, monitor);
                    }
                    catch (Throwable t) {
                        throw new CoreException((IStatus)new Status(4, "it.jrc.osint.workspace", "Failed to remove resource from project", t));
                    }
                }
            }, (ISchedulingRule)parentContainer, 1, null);
        }
        catch (Throwable t) {
            log.error("Failed to remove resource from project", t);
        }
        return resourcePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IFile addFile(IFile file, final InputStream in, boolean overwrite, IProgressMonitor monitor) {
        String fileName = file.getName();
        IContainer parentContainer = file.getParent();
        if (overwrite) {
            if (WorkspaceUtil.resourceExists((IResource)file)) {
                IResource existingResource = WorkspaceUtil.findFirstCaseVariant((IResource)file);
                if (!(existingResource instanceof IFile)) {
                    log.error("Resource to be overwritten must be of type IFile. Existing resource: " + existingResource.getName());
                    return null;
                }
                file = (IFile)existingResource;
            }
        } else if (WorkspaceUtil.resourceExists(parentContainer, (IPath)new Path(fileName))) {
            fileName = WorkspaceUtil.getNextFileName(parentContainer, fileName, 0);
            file = parentContainer.getFile((IPath)new Path(fileName));
        }
        final IFile resultFile = file;
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        if (resultFile.exists()) {
                            resultFile.setContents(in, 1, monitor);
                        } else {
                            resultFile.create(in, true, monitor);
                        }
                    }
                    catch (Throwable t) {
                        throw new CoreException((IStatus)new Status(4, "it.jrc.osint.workspace", "Failed to add file: " + resultFile.getName() + "to workspace", t));
                    }
                }
            }, (ISchedulingRule)parentContainer, 1, monitor);
            return resultFile;
        }
        catch (CoreException e) {
            log.error("Failed to add file " + fileName + " into workspace ", (Throwable)e);
            return null;
        }
    }

    @Override
    public IFile getFile(ResourceId id) {
        IPath docPath = this.workspaceService.getPath(id);
        if (docPath == null) {
            return null;
        }
        IFile aFile = ResourcesPlugin.getWorkspace().getRoot().getFile(docPath);
        return aFile;
    }

    @Override
    public Set<ResourceId> getFilesByContentType(IContainer parent, String contentTypeId) {
        ContentTypeTraverseVisitor visitor = new ContentTypeTraverseVisitor(contentTypeId);
        HashSet<ResourceId> resultSet = new HashSet<ResourceId>();
        try {
            parent.accept((IResourceVisitor)visitor);
            List<IFile> files = visitor.getFiles();
            for (IFile file : files) {
                ResourceId fileId = this.workspaceService.getId(file.getFullPath());
                resultSet.add(fileId);
            }
            return resultSet;
        }
        catch (CoreException e) {
            log.error("Failed to files for contentTypeId " + contentTypeId, (Throwable)e);
            return Collections.emptySet();
        }
    }

    protected abstract ProjectLayout getProjectLayout();

    void createDefaultFolders_rm() {
        this.getProjectLayout().createDefaultLayout_rm(this.getProject());
    }

    void createDefaultContent_rm() {
        List<ProjectCreationParticipant> creationParticipants = WorkspacePlugin.getPlugin().getProjectCreationParticipants();
        for (ProjectCreationParticipant participant : creationParticipants) {
            try {
                participant.created(this);
            }
            catch (Throwable t) {
                log.error("ProjectCreationParticipant failed", t);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void update(List<ResourceEvent> events, boolean parentProjectDeleted, List<WorkspaceServiceEvent> outEvents) {
        ArrayList<WorkspaceServiceEvent> wsEvents = new ArrayList<WorkspaceServiceEvent>();
        for (ResourceEvent event : events) {
            WorkspaceServiceEventImpl newEvent;
            ResourceId fileId;
            IResource resource = event.getResource();
            if (resource == null || !(resource instanceof IFile) || !resource.getProject().getName().equals(this.getName())) continue;
            if (event.getType() == ResourceEvent.EventType.CREATED) {
                fileId = this.fileAdded_rm((IFile)event.getResource());
                newEvent = new WorkspaceServiceEventImpl("osint/workspace/resourceAdded", this.getId(), this.getName());
                newEvent.setResourceId(fileId);
                newEvent.setProjectDeleted(parentProjectDeleted);
                this.addWorkspaceServiceEvent(wsEvents, newEvent);
            }
            if (event.getType() == ResourceEvent.EventType.DELETED) {
                fileId = this.fileDeleted_rm((IFile)event.getResource());
                newEvent = new WorkspaceServiceEventImpl("osint/workspace/resourceDeleted", this.getId(), this.getName());
                newEvent.setResourceId(fileId);
                newEvent.setProjectDeleted(parentProjectDeleted);
                this.addWorkspaceServiceEvent(wsEvents, newEvent);
            }
            if (event.getType() == ResourceEvent.EventType.CONTENT_CHANGED) {
                fileId = this.fileUpdated_rm((IFile)event.getResource());
                newEvent = new WorkspaceServiceEventImpl("osint/workspace/resourceChanged", this.getId(), this.getName());
                newEvent.setResourceId(fileId);
                newEvent.setProjectDeleted(parentProjectDeleted);
                this.addWorkspaceServiceEvent(wsEvents, newEvent);
            }
            if (event.getType() != ResourceEvent.EventType.MOVED) continue;
            fileId = this.fileMoved_rm((IFile)event.getResource(), event.getMovedFromPath());
            HashMap<ResourceId, IPath> movedFromMap = new HashMap<ResourceId, IPath>();
            movedFromMap.put(fileId, event.getMovedFromPath());
            WorkspaceServiceEventImpl newEvent2 = new WorkspaceServiceEventImpl("osint/workspace/resourceMoved", this.getId(), this.getName());
            newEvent2.setResourceId(fileId);
            newEvent2.setMovedFromPathMap(movedFromMap);
            newEvent2.setProjectDeleted(parentProjectDeleted);
            this.addWorkspaceServiceEvent(wsEvents, newEvent2);
        }
        outEvents.addAll(wsEvents);
    }

    private void addWorkspaceServiceEvent(List<WorkspaceServiceEvent> events, WorkspaceServiceEvent newEvent) {
        if (newEvent == null) {
            return;
        }
        for (WorkspaceServiceEvent event : events) {
            WorkspaceServiceEventImpl eventImpl = (WorkspaceServiceEventImpl)event;
            if (!eventImpl.merge(newEvent)) continue;
            return;
        }
        events.add(newEvent);
    }

    protected abstract ResourceId fileAdded_rm(IFile var1);

    protected abstract ResourceId fileDeleted_rm(IFile var1);

    protected abstract ResourceId fileMoved_rm(IFile var1, IPath var2);

    protected abstract ResourceId fileUpdated_rm(IFile var1);

    private static class ContentTypeTraverseVisitor
    implements IResourceVisitor {
        private List<IFile> files = new LinkedList<IFile>();
        private String contentTypeId;

        public ContentTypeTraverseVisitor(String contentTypeId) {
            this.contentTypeId = contentTypeId;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IContentType ct;
                IFile aFile = (IFile)resource;
                IContentDescription cd = aFile.getContentDescription();
                if (cd != null && (ct = cd.getContentType()) != null && this.contentTypeId.equals(ct.getId())) {
                    this.files.add(aFile);
                }
                return false;
            }
            return true;
        }

        public List<IFile> getFiles() {
            return this.files;
        }
    }
}

