/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.MarkerUtil;
import it.jrc.osint.workspace.ResourceBuilder;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.internal.AbstractBuilder;
import it.jrc.osint.workspace.internal.BaseProjectImpl;
import it.jrc.osint.workspace.internal.CaseProjectImpl;
import it.jrc.osint.workspace.internal.DebugResourceMonitorListener;
import it.jrc.osint.workspace.internal.WorkspaceServiceEventImpl;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CaseProjectBuilder
extends AbstractBuilder {
    private static final Logger log = LogManager.getLogger((String)CaseProjectBuilder.class.getName());
    public static final String ID = "it.jrc.osint.workspace.caseProjectBuilder";
    private List<ResourceBuilder> resourceBuilders;

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.resourceBuilders = WorkspacePlugin.getPlugin().getResourceBuilders();
    }

    @Override
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        List<ResourceEvent> events;
        IResourceDelta rDelta;
        BuilderParametersImpl builderParams = new BuilderParametersImpl();
        if (!builderParams.parseBuilderArgs(args)) {
            log.error("Parsing of build parameters failed, build aborted");
            return null;
        }
        int resourceBuilderKind = 0;
        Set<ResourceId> buildIds = new HashSet<ResourceId>();
        if (kind == 6) {
            resourceBuilderKind = 6;
            this.fireBuildEvent(this.getCaseProject().getDocumentIds(), this.getCaseProject());
        } else if (kind == 10) {
            resourceBuilderKind = 10;
            rDelta = this.getDelta(this.getProject());
            events = this.getResourceMonitorEvents(rDelta);
            buildIds = this.gatherDocumentIdsForBuild(events, this.getCaseProject());
            builderParams.setResourceEvents(events);
        } else if (kind == 9) {
            resourceBuilderKind = 10;
            rDelta = this.getDelta(this.getProject());
            events = this.getResourceMonitorEvents(rDelta);
            buildIds = this.gatherDocumentIdsForBuild(events, this.getCaseProject());
            builderParams.setResourceEvents(events);
        }
        int[] workItemCounts = this.prepareBuild(resourceBuilderKind, builderParams);
        this.performBuild(resourceBuilderKind, builderParams, workItemCounts, buildIds, monitor);
        if (log.isDebugEnabled()) {
            rDelta = this.getDelta(this.getProject());
            DebugResourceMonitorListener debugListener = new DebugResourceMonitorListener();
            debugListener.dumpResourceDelta(rDelta);
        }
        return null;
    }

    private void performBuild(int kind, ResourceBuilder.BuildParameters params, int[] workItemCounts, Set<ResourceId> buildIds, IProgressMonitor monitor) {
        if (!this.hasWorkItems(workItemCounts) && kind != 6) {
            return;
        }
        int sum = 0;
        Object object = workItemCounts;
        int n = workItemCounts.length;
        int n2 = 0;
        while (n2 < n) {
            int workItem = object[n2];
            sum += workItem;
            ++n2;
        }
        monitor.beginTask("Building Extraction Data", sum);
        HashSet<ResourceId> changedResources = new HashSet<ResourceId>();
        try {
            try {
                int i = 0;
                object = this.resourceBuilders.iterator();
                while (object.hasNext()) {
                    ResourceBuilder rb = (ResourceBuilder)object.next();
                    if (monitor.isCanceled()) continue;
                    try {
                        int builderItemCount = workItemCounts[i++];
                        Set<ResourceId> changedIds = rb.build(kind, params, this.getCaseProject(), (IProgressMonitor)new SubProgressMonitor(monitor, builderItemCount, 4));
                        changedResources.addAll(changedIds);
                    }
                    catch (Throwable t) {
                        log.error("Failed to perform incrementalBuild on resourceBuilder instance " + rb.getClass().getName(), t);
                    }
                }
                if (!changedResources.isEmpty()) {
                    this.updateErrorMarker(changedResources);
                    this.getCaseProject().fireMetaDataChangedEvent(changedResources);
                }
                if (!monitor.isCanceled()) {
                    this.fireBuildEvent(buildIds, this.getCaseProject());
                }
            }
            catch (Throwable t) {
                log.error("Failed to execute builders for incremental build", t);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fireBuildEvent(Set<ResourceId> docIds, CaseProject prj) {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        WorkspaceServiceEventImpl newEvent = new WorkspaceServiceEventImpl("osint/workspace/projectBuildRequested", prj.getId(), prj.getName());
        newEvent.setResourceIds(docIds);
        ws.fireWorkspaceEvent(newEvent);
    }

    private Set<ResourceId> gatherDocumentIdsForBuild(List<ResourceEvent> events, CaseProject prj) {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        HashSet<ResourceId> buildFiles = new HashSet<ResourceId>();
        for (ResourceEvent event : events) {
            if (!(event.getResource() instanceof IFile)) continue;
            if (event.getType() == ResourceEvent.EventType.CREATED) {
                buildFiles.add(ws.getId(event.getResource().getFullPath()));
            }
            event.getType();
            if (event.getType() == ResourceEvent.EventType.CONTENT_CHANGED) {
                buildFiles.add(ws.getId(event.getResource().getFullPath()));
            }
            if (event.getType() != ResourceEvent.EventType.MOVED) continue;
            buildFiles.add(ws.getId(event.getResource().getFullPath()));
        }
        return this.filterDocumentIds(buildFiles, prj);
    }

    private Set<ResourceId> filterDocumentIds(Set<ResourceId> resourceIds, CaseProject prj) {
        if (resourceIds == null || resourceIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ResourceId> documentIds = new HashSet<ResourceId>();
        for (ResourceId id : resourceIds) {
            if (!prj.containsDocument(id)) continue;
            documentIds.add(id);
        }
        return documentIds;
    }

    private int[] prepareBuild(int kind, ResourceBuilder.BuildParameters params) {
        int[] workItemCount = new int[this.resourceBuilders.size()];
        int i = 0;
        for (ResourceBuilder rb : this.resourceBuilders) {
            try {
                workItemCount[i++] = rb.prepareBuild(kind, params, this.getCaseProject());
            }
            catch (Throwable t) {
                log.error("Failed to call method prepareBuild on ResourceBuilder instance " + rb, t);
            }
        }
        return workItemCount;
    }

    private boolean isProjectStatusValid() {
        CaseProjectImpl cp = this.getCaseProject();
        if (cp == null) {
            return false;
        }
        IProject prj = cp.getProject();
        return prj != null && prj.isAccessible();
    }

    private boolean hasWorkItems(int[] workItemCounts) {
        if (workItemCounts == null) {
            return false;
        }
        int[] nArray = workItemCounts;
        int n = workItemCounts.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray[n2];
            if (count > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void updateErrorMarker(Set<ResourceId> ids) {
        for (ResourceId id : ids) {
            DocumentMetaItem metaItem = this.getCaseProject().getMetaItem(id);
            if (metaItem == null) continue;
            ErrorStatusMetaData emd = new ErrorStatusMetaData(metaItem);
            if (emd.hasErrorStatus()) {
                MarkerUtil.mark(id, "it.jrc.osint.workspace.errorStatusMarker");
                continue;
            }
            MarkerUtil.clean(id, "it.jrc.osint.workspace.errorStatusMarker");
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (!this.isProjectStatusValid()) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.fireCleanBuildRequestedEvent();
        this.performClean(this.resourceBuilders, this.getCaseProject(), monitor);
    }

    private IStatus performClean(List<ResourceBuilder> resourceBuilders, CaseProject caseProject, IProgressMonitor monitor) {
        Set<ResourceId> ids = this.getCaseProject().getDocumentIds();
        int workItemCountBuilder = ids.size();
        int workItemCountTotal = workItemCountBuilder * resourceBuilders.size();
        monitor.beginTask("Cleaning workspace", workItemCountTotal);
        try {
            for (ResourceBuilder rb : resourceBuilders) {
                if (!monitor.isCanceled()) {
                    try {
                        rb.clean(caseProject, (IProgressMonitor)new SubProgressMonitor(monitor, workItemCountBuilder, 4));
                    }
                    catch (Throwable t) {
                        log.error("Failed to perform cleanBuild on resourceBuilder instance " + rb.getClass().getName(), t);
                    }
                    continue;
                }
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.fireCleanBuildFinishedEvent();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Throwable t) {
            log.error("Failed to execute builders for clean build", t);
            Status status = new Status(4, "it.jrc.osint.workspace", "Failed clean extraction data", t);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private void fireCleanBuildRequestedEvent() {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        WorkspaceServiceEventImpl newEvent = new WorkspaceServiceEventImpl("osint/workspace/projectCleanBuildRequested", this.getCaseProject().getId(), this.getCaseProject().getName());
        newEvent.setResourceIds(this.getCaseProject().getDocumentIds());
        ws.fireWorkspaceEvent(newEvent);
    }

    private void fireCleanBuildFinishedEvent() {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        WorkspaceServiceEventImpl newEvent = new WorkspaceServiceEventImpl("osint/workspace/projectCleanBuildFinished", this.getCaseProject().getId(), this.getCaseProject().getName());
        newEvent.setResourceIds(this.getCaseProject().getDocumentIds());
        ws.fireWorkspaceEvent(newEvent);
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return null;
    }

    protected CaseProjectImpl getCaseProject() {
        return (CaseProjectImpl)WorkspacePlugin.getWorkspaceService().getCaseProjectByName(this.getProject().getName());
    }

    @Override
    protected BaseProjectImpl getBaseProject() {
        return this.getCaseProject();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    private class BuilderParametersImpl
    implements ResourceBuilder.BuildParameters {
        private Map<String, String> args;
        private List<ResourceEvent> resourceEvents = Collections.emptyList();
        private boolean userTriggered;
        private boolean automaticBuilEnabled;
        private IFolder parentResource;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean parseBuilderArgs(Map<String, String> args) {
            this.args = args;
            try {
                boolean automaticExtractionEnabled = WorkspacePlugin.getWorkspaceService().isAutomaticExtractionEnabled();
                if (automaticExtractionEnabled) {
                    this.automaticBuilEnabled = true;
                }
                if (args != null) {
                    String buildParentResourcePath;
                    String userAction = args.get("userAction");
                    if (userAction != null) {
                        this.userTriggered = Boolean.parseBoolean(userAction);
                    }
                    if ((buildParentResourcePath = args.get("partialBuildPath")) != null) {
                        IProject project = CaseProjectBuilder.this.getProject();
                        if (project == null) {
                            log.error("Failed to obtain project for CaseProjectBuilder");
                            return false;
                        }
                        this.parentResource = CaseProjectBuilder.this.getProject().getFolder(buildParentResourcePath);
                    }
                    if (this.parentResource == null) {
                        CaseProjectImpl cp = CaseProjectBuilder.this.getCaseProject();
                        if (cp == null) {
                            log.warn("Failed to find case project for CaseProjectBuilder");
                            return false;
                        }
                        this.parentResource = CaseProjectBuilder.this.getCaseProject().getSystemFolder("Documents");
                    }
                }
                return true;
            }
            catch (Throwable t) {
                log.error("Failed to parse builder arguments properly", t);
                return false;
            }
        }

        @Override
        public Map<String, String> getArgs() {
            return this.args;
        }

        @Override
        public boolean isUserTriggered() {
            return this.userTriggered;
        }

        @Override
        public boolean isAutomaticBuildEnabled() {
            return this.automaticBuilEnabled;
        }

        @Override
        public IFolder getParentResource() {
            return this.parentResource;
        }

        @Override
        public List<ResourceEvent> getResourceEvents() {
            return this.resourceEvents;
        }

        private void setResourceEvents(List<ResourceEvent> events) {
            this.resourceEvents = events;
        }
    }
}

