/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.util.io.PersistentMap;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.internal.FileIndexEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileIndex {
    private static final Logger log = LogManager.getLogger((String)FileIndex.class.getName());
    private static final String CONTENT_TYPE = "it.jrc.osint.contenttype.FileIndex";
    private static final String INDEX_ENTRIES = "index-entries";
    private static String[] EXCLUDE_PATTERNS = new String[]{".*\\.osint.*", ".*\\.osint_workspace.*", ".*\\.project", ".*\\.settings.*", ".*\\.metadata.*"};
    private IWorkspaceRoot workspaceRoot;
    private Map<IPath, FileIndexEntry> pathEntryMap = new ConcurrentHashMap<IPath, FileIndexEntry>();
    private Map<ResourceId, FileIndexEntry> idEntryMap = new ConcurrentHashMap<ResourceId, FileIndexEntry>();
    private Map<IPath, FileIndexEntry> pathDeletedEntryMap = new HashMap<IPath, FileIndexEntry>();

    public FileIndex(IWorkspaceRoot workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
    }

    public boolean isIncludedInIndex(IPath path) {
        String resourcePath = path.toString();
        String[] stringArray = EXCLUDE_PATTERNS;
        int n = EXCLUDE_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            String excludePattern = stringArray[n2];
            if (resourcePath.matches(excludePattern)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private FileIndexEntry getEntry(IPath path) {
        if (path == null) {
            return null;
        }
        return this.pathEntryMap.get(path);
    }

    public synchronized FileIndexEntry createEntry(IPath filePath) {
        FileIndexEntry entry = null;
        if (filePath == null) {
            return null;
        }
        if (!this.isIncludedInIndex(filePath)) {
            return null;
        }
        if (this.contains(filePath)) {
            return this.getEntry(filePath);
        }
        if (this.pathDeletedEntryMap.containsKey(filePath)) {
            entry = this.pathDeletedEntryMap.get(filePath);
            this.pathDeletedEntryMap.remove(filePath);
        } else {
            ResourceId fileId = new ResourceId();
            entry = new FileIndexEntry(fileId, filePath);
        }
        IResource resource = this.workspaceRoot.findMember(filePath);
        if (resource != null) {
            entry.setType(resource.getType());
        }
        this.add(entry);
        return entry;
    }

    private synchronized void containerMoved(IPath containerPath, IPath newContainerPath) {
        ArrayList<FileIndexEntry> entries = new ArrayList<FileIndexEntry>();
        for (IPath path : this.pathEntryMap.keySet()) {
            if (!containerPath.isPrefixOf(path)) continue;
            entries.add(this.getEntry(path));
        }
        for (FileIndexEntry entry : entries) {
            IPath entryPath = entry.getPath();
            int segCount = containerPath.matchingFirstSegments(entryPath);
            IPath containerRelPath = entryPath.removeFirstSegments(segCount);
            IPath movedPath = newContainerPath.append(containerRelPath);
            entry.setPath(movedPath);
            this.resourceMoved(entryPath, movedPath);
        }
    }

    private synchronized void containerDeleted(IPath containerPath) {
        FileIndexEntry entry = this.getEntry(containerPath);
        if (entry != null) {
            this.pathDeletedEntryMap.put(containerPath, entry);
            this.pathEntryMap.remove(containerPath);
            this.idEntryMap.remove(entry.getId());
        }
    }

    private void resourceMoved(IPath fromPath, IPath toPath) {
        FileIndexEntry entry = this.pathEntryMap.remove(fromPath);
        if (entry != null) {
            entry.setPath(toPath);
            this.pathEntryMap.put(toPath, entry);
            this.pathDeletedEntryMap.put(fromPath, entry);
        }
    }

    public FileIndexEntry delete(IPath aPath) {
        if (aPath == null) {
            return null;
        }
        ResourceId id = this.getId(aPath);
        return this.delete(id);
    }

    public FileIndexEntry delete(ResourceId id) {
        if (id == null) {
            return null;
        }
        FileIndexEntry entry = this.idEntryMap.get(id);
        if (entry != null) {
            this.idEntryMap.remove(id);
            this.pathEntryMap.remove(entry.getPath());
            this.pathDeletedEntryMap.put(entry.getPath(), entry);
        }
        return entry;
    }

    public IPath getPath(ResourceId id) {
        IPath path = null;
        if (id == null) {
            return null;
        }
        FileIndexEntry entry = this.idEntryMap.get(id);
        if (entry != null) {
            path = entry.getPath();
        }
        return path;
    }

    public IPath getPath(ResourceId id, boolean includeDeletedEntries) {
        if (!includeDeletedEntries) {
            return this.getPath(id);
        }
        IPath path = this.getPath(id);
        if (path == null) {
            for (FileIndexEntry entry : this.pathDeletedEntryMap.values()) {
                if (!entry.getId().equals((Object)id)) continue;
                return entry.getPath();
            }
        } else {
            return path;
        }
        return null;
    }

    public ResourceId getId(IPath path) {
        if (path == null) {
            return null;
        }
        if (!this.isIncludedInIndex(path)) {
            return null;
        }
        if (!this.contains(path)) {
            this.createEntry(path);
        }
        FileIndexEntry entry = this.pathEntryMap.get(path);
        return entry.getId();
    }

    public ResourceId getId(IPath path, boolean includeDeletedEntries) {
        if (!includeDeletedEntries) {
            return this.getId(path);
        }
        if (this.contains(path, true)) {
            FileIndexEntry entry = this.pathEntryMap.get(path);
            if (entry != null) {
                return entry.getId();
            }
            entry = this.pathDeletedEntryMap.get(path);
            if (entry != null) {
                return entry.getId();
            }
        }
        return null;
    }

    public Set<ResourceId> getResourceIds(IPath parentPath) {
        HashSet<ResourceId> resultSet = new HashSet<ResourceId>();
        for (IPath aPath : this.pathEntryMap.keySet()) {
            FileIndexEntry entry;
            if (!parentPath.isPrefixOf(aPath) || (entry = this.pathEntryMap.get(aPath)).getType() != 1) continue;
            resultSet.add(entry.getId());
        }
        return resultSet;
    }

    public boolean contains(ResourceId id) {
        return this.idEntryMap.containsKey(id);
    }

    public boolean contains(IPath path) {
        return this.pathEntryMap.containsKey(path);
    }

    public boolean contains(IPath path, boolean includeDeletedEntries) {
        if (this.contains(path)) {
            return true;
        }
        if (includeDeletedEntries) {
            return this.pathDeletedEntryMap.containsKey(path);
        }
        return false;
    }

    boolean load(File indexFile) {
        if (indexFile == null || !indexFile.exists()) {
            return false;
        }
        PersistentMap persistentMap = new PersistentMap(CONTENT_TYPE);
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(indexFile);
                persistentMap.load((InputStream)in);
            }
            catch (Throwable t) {
                log.error("Failed to load index file", t);
                FileUtil.close((InputStream)in);
                return false;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close((InputStream)in);
        try {
            List indexEntriesList = (List)persistentMap.get((Object)INDEX_ENTRIES);
            for (Map entryDataMap : indexEntriesList) {
                FileIndexEntry entry = new FileIndexEntry(entryDataMap);
                this.idEntryMap.put(entry.getId(), entry);
                this.pathEntryMap.put(entry.getPath(), entry);
            }
        }
        catch (Throwable t) {
            log.error("Failed to load index file and setup internal data structures", t);
            return false;
        }
        return true;
    }

    void save(File indexFile) {
        block7: {
            if (indexFile == null) {
                throw new IllegalArgumentException("Index file must not be null");
            }
            PersistentMap persistentMap = new PersistentMap(CONTENT_TYPE);
            LinkedList<Map<String, Object>> indexEntriesList = new LinkedList<Map<String, Object>>();
            for (FileIndexEntry entry : this.pathEntryMap.values()) {
                indexEntriesList.add(entry.getDataMap());
            }
            persistentMap.put(INDEX_ENTRIES, indexEntriesList);
            OutputStreamWriter outWriter = null;
            try {
                try {
                    FileOutputStream out = new FileOutputStream(indexFile);
                    outWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                    persistentMap.save((Writer)outWriter);
                }
                catch (Throwable t) {
                    log.error("Failed to save document index", t);
                    FileUtil.close(outWriter);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(outWriter);
                throw throwable;
            }
            FileUtil.close((Writer)outWriter);
        }
    }

    private void add(FileIndexEntry indexEntry) {
        if (indexEntry == null || indexEntry.getId() == null) {
            return;
        }
        this.pathEntryMap.put(indexEntry.getPath(), indexEntry);
        this.idEntryMap.put(indexEntry.getId(), indexEntry);
    }

    public List<WorkspaceService.IndexEntry> getIndexEntries() {
        ArrayList<WorkspaceService.IndexEntry> entries = new ArrayList<WorkspaceService.IndexEntry>();
        entries.addAll(this.pathEntryMap.values());
        return entries;
    }

    public void rebuildIndex() {
    }

    public void refreshIndex() {
        for (FileIndexEntry entry : this.pathEntryMap.values()) {
            this.pathDeletedEntryMap.put(entry.getPath(), entry);
        }
        this.pathEntryMap.clear();
        this.idEntryMap.clear();
        FileIndexRebuildVisitor visitor = new FileIndexRebuildVisitor(this);
        try {
            this.workspaceRoot.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            log.error("Failed to rebuild file index", (Throwable)e);
        }
        this.pathDeletedEntryMap.clear();
    }

    public void update(List<ResourceEvent> events) {
        for (ResourceEvent event : events) {
            IResource resource = event.getResource();
            if (!this.isIncludedInIndex(resource.getFullPath())) break;
            if (resource.getType() == 4 || resource.getType() == 2) {
                if (event.getType().equals((Object)ResourceEvent.EventType.MOVED)) {
                    this.containerMoved(event.getMovedFromPath(), resource.getFullPath());
                }
                if (event.getType().equals((Object)ResourceEvent.EventType.DELETED)) {
                    this.containerDeleted(event.getResourcePath());
                }
            }
            if (resource.getType() != 1) continue;
            if (event.getType().equals((Object)ResourceEvent.EventType.CREATED)) {
                this.createEntry(resource.getFullPath());
            }
            if (event.getType().equals((Object)ResourceEvent.EventType.DELETED)) {
                this.delete(resource.getFullPath());
            }
            if (!event.getType().equals((Object)ResourceEvent.EventType.MOVED)) continue;
            this.resourceMoved(event.getMovedFromPath(), resource.getFullPath());
        }
    }

    private class FileIndexRebuildVisitor
    implements IResourceVisitor {
        private FileIndex fileIndex;

        public FileIndexRebuildVisitor(FileIndex fileIndex2) {
            this.fileIndex = fileIndex2;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource == null) {
                return false;
            }
            if (resource.getType() == 8) {
                return true;
            }
            IPath fullPath = resource.getFullPath();
            if (!FileIndex.this.isIncludedInIndex(fullPath)) {
                return false;
            }
            if (resource.getType() == 2) {
                return true;
            }
            if (FileIndex.this.pathDeletedEntryMap.containsKey(fullPath)) {
                FileIndexEntry entry = (FileIndexEntry)FileIndex.this.pathDeletedEntryMap.remove(fullPath);
                FileIndex.this.pathEntryMap.put(entry.getPath(), entry);
                FileIndex.this.idEntryMap.put(entry.getId(), entry);
            } else {
                this.fileIndex.createEntry(fullPath);
            }
            return true;
        }
    }
}

