/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.internal.FileIndex;
import it.jrc.osint.workspace.internal.ResourceDeltaVisitor;
import it.jrc.osint.workspace.internal.ResourceIdSubscription;
import it.jrc.osint.workspace.internal.ResourceMonitorListener;
import it.jrc.osint.workspace.internal.ResourceMonitorService;
import it.jrc.osint.workspace.internal.ResourceMonitorSubscription;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ResourceMonitorServiceImpl
implements ResourceMonitorService {
    private static final Logger log = LogManager.getLogger((String)ResourceMonitorServiceImpl.class.getName());
    private IResourceChangeListener changeListener;
    private Set<ResourceMonitorSubscription> subscriptions = new HashSet<ResourceMonitorSubscription>();
    private Set<ResourceMonitorSubscription> subscriptionsToBeRemoved = new HashSet<ResourceMonitorSubscription>();
    private Set<ResourceMonitorSubscription> subscriptionsToBeAdded = new HashSet<ResourceMonitorSubscription>();

    public void start() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.changeListener = new ResourceChangeListener();
        workspace.addResourceChangeListener(this.changeListener, 12);
    }

    public void stop() {
        this.updateSubscriptions();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.changeListener);
    }

    @Override
    public void addListener(ResourceMonitorListener listener, IPath path) {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        FileIndex fi = ws.getFileIndex();
        ResourceId id = fi.getId(path);
        this.addListener(listener, id);
    }

    @Override
    public void addListener(ResourceMonitorListener listener, ResourceId id) {
        ResourceIdSubscription s = new ResourceIdSubscription(listener, id);
        this.subscriptionsToBeAdded.add(s);
    }

    @Override
    public void addListener(ResourceMonitorListener listener) {
        ResourceMonitorSubscription s = new ResourceMonitorSubscription(listener);
        this.subscriptionsToBeAdded.add(s);
    }

    @Override
    public void removeListener(ResourceMonitorListener listener) {
        this.subscriptionsToBeRemoved.add(new ResourceMonitorSubscription(listener));
    }

    private void updateSubscriptions() {
        for (ResourceMonitorSubscription s : this.subscriptionsToBeAdded) {
            this.subscriptions.add(s);
        }
        this.subscriptionsToBeAdded.clear();
        for (ResourceMonitorSubscription s : this.subscriptionsToBeRemoved) {
            Iterator<ResourceMonitorSubscription> it = this.subscriptions.iterator();
            while (it.hasNext()) {
                ResourceMonitorSubscription es = it.next();
                if (!es.getListener().equals(s.getListener())) continue;
                it.remove();
            }
        }
        this.subscriptionsToBeRemoved.clear();
    }

    private void fireParsedEvents(List<ResourceEvent> events) {
        this.updateSubscriptions();
        for (ResourceMonitorSubscription s : this.subscriptions) {
            s.processEvents(events);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                int type = event.getType();
                log.debug("event.getType=" + type);
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                event.getDelta().accept((IResourceDeltaVisitor)visitor);
                ResourceMonitorServiceImpl.this.fireParsedEvents(visitor.getEvents());
            }
            catch (CoreException e) {
                log.error("Failed to collect resource change", (Throwable)e);
            }
        }
    }
}

