/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.matcher;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.ConfigurationFeature;
import it.jrc.lt.core.component.matcher.AbstractMatcher;
import it.jrc.lt.core.component.matcher.BasicMatchItem;
import it.jrc.lt.core.component.matcher.MatcherException;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class BasicMatcher
extends AbstractMatcher {
    private MatchWords _mw = null;
    private Map<Integer, List<String>> _mattributes = new HashMap<Integer, List<String>>();
    private Map<Integer, Object[]> _mstrict = new HashMap<Integer, Object[]>();

    protected BasicMatcher() {
    }

    public boolean hasBeenInitialized() {
        return this.getName() != null;
    }

    public void writeToStream(DataOutputStream d) {
        Component.loggerMessageAndReturn((String)"NullComponent: Operation can not be performed.");
    }

    public void readFromStream(DataInputStream d) {
        Component.loggerMessageAndReturn((String)"NullComponent: Operation can not be performed.");
    }

    protected List<ConfigurationFeature> getCompilationFeatures() {
        return Collections.unmodifiableList(Arrays.asList(CompilationFeatures.FEATURES));
    }

    protected List<ConfigurationFeature> getDeploymentFeatures() {
        return Collections.unmodifiableList(Arrays.asList(DeploymentFeatures.FEATURES));
    }

    protected boolean initialize(Configuration configuration) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applySpecificSettings(Configuration configuration) {
        String patternfile = configuration.getFeature(DeploymentFeatures.PATTERNFILE.getName());
        String fieldseparator = configuration.getFeature(DeploymentFeatures.FIELDSEPARATOR.getName());
        String fieldseparatorsplit = fieldseparator.replaceAll("(.)", "\\\\$1");
        String keyvalueseparator = configuration.getFeature(DeploymentFeatures.KEYVALUESEPARATOR.getName());
        File f = new File(patternfile);
        String name = f.toString().substring(f.getParentFile().getParent().length() + 1);
        this.setName(name);
        Component.loggerMessage((String)("component [" + this.getName() + "] uses patternfile [" + patternfile + "] expected in format [pattern " + fieldseparator + " key" + keyvalueseparator + "value]"));
        HashMap<String, Integer> lattributes = new HashMap<String, Integer>();
        Hashtable<String, StringBuilder> ht = new Hashtable<String, StringBuilder>();
        this._mattributes.put(0, null);
        this._mattributes.put(1, null);
        this._mattributes.put(2, null);
        this._mattributes.put(3, null);
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(patternfile)), "UTF-8"));
                int l = 0;
                String line = null;
                block7: while ((line = br.readLine()) != null) {
                    ++l;
                    String stream = line.trim();
                    if (stream.equals("") || stream.startsWith("#") || stream.startsWith("\ufeff")) continue;
                    int i = stream.lastIndexOf(35);
                    if (i != -1) {
                        stream = stream.substring(0, i);
                    }
                    if ((i = stream.indexOf(fieldseparator)) == -1) {
                        if (stream.startsWith("@") && stream.endsWith("]")) {
                            StringBuilder sb = (StringBuilder)ht.get(stream);
                            if (sb == null) {
                                sb = new StringBuilder(1);
                                ht.put(stream, sb);
                                continue;
                            }
                            Component.loggerMessage((String)("component [" + this.getName() + "] ignore line #[" + l + "] [" + line + "] because matcher prefix [" + stream + "] is duplicate"));
                            continue;
                        }
                        Component.logger.warn((Object)("component [" + this.getName() + "] ignore line #[" + l + "] [" + line + "] because without attributes"));
                        continue;
                    }
                    String upattern = stream.substring(0, i).trim();
                    String mpattern = upattern.replaceAll(" & ", "\\+").replaceAll("[\\s!\"#\\$'\\(\\)\\*\\+,\\./:;<=>\\?@\\\\^`{\\|}~\u2019]+", "\\+").replaceFirst("^\\++", "").replaceFirst("\\++$", "");
                    if ("".equals(mpattern)) {
                        Component.logger.warn((Object)("component [" + this.getName() + "] ignore line #[" + l + "] [" + line + "] because matcher pattern [" + mpattern + "] is not valid"));
                        continue;
                    }
                    String spattern = null;
                    String[] attributes = stream.substring(i + fieldseparator.length()).split(fieldseparatorsplit);
                    ArrayList<String[]> combinations = new ArrayList<String[]>();
                    for (String attribute : attributes) {
                        String[] att = attribute.split(keyvalueseparator);
                        if (att.length != 2) {
                            Component.logger.warn((Object)("component [" + this.getName() + "] ignore line #[" + l + "] [" + line + "] because attribute [" + attribute + "] is not valid"));
                            continue block7;
                        }
                        if ("STRICT".equals(att[0].trim())) {
                            spattern = att[1].trim();
                            continue;
                        }
                        combinations.add(new String[]{att[0].trim(), att[1].trim()});
                    }
                    Collections.sort(combinations, new Comparator<String[]>(){

                        @Override
                        public int compare(String[] o1, String[] o2) {
                            int result = o1[0].compareTo(o2[0]);
                            if (result == 0) {
                                result = o1[1].compareTo(o2[1]);
                            }
                            return result;
                        }
                    });
                    StringBuilder sb = new StringBuilder();
                    for (String[] c : combinations) {
                        sb.append(c[0]).append(keyvalueseparator).append(c[1]).append(fieldseparator);
                    }
                    String ssortedattributes = sb.toString();
                    Integer ifacet = (Integer)lattributes.get(ssortedattributes);
                    if (ifacet == null || spattern != null) {
                        ifacet = this._mattributes.size();
                        ArrayList<String> ls = new ArrayList<String>();
                        for (String[] as : combinations) {
                            ls.add(as[0]);
                            ls.add(as[1]);
                        }
                        this._mattributes.put(ifacet, ls);
                        if (spattern != null) {
                            int j;
                            int ileft = 0;
                            int iright = 0;
                            for (j = 0; j < upattern.length() && !Character.isLetterOrDigit(upattern.charAt(j)); ++j) {
                                ++ileft;
                            }
                            for (j = upattern.length() - 1; j >= 0 && !Character.isLetterOrDigit(upattern.charAt(j)); --j) {
                                ++iright;
                            }
                            if (ileft == upattern.length()) {
                                Component.logger.warn((Object)("component [" + this.getName() + "] ignore line #[" + l + "] [" + line + "] because strict pattern [" + spattern + "] is for a user pattern [" + upattern + "] which contains only non-letter-or-digit"));
                                continue;
                            }
                            Pattern ps = null;
                            try {
                                ps = Pattern.compile(spattern);
                            }
                            catch (PatternSyntaxException psex) {
                                Component.logger.warn((Object)("component [" + this.getName() + "] ignore line #[" + l + "] [" + line + "] because strict pattern [" + spattern + "] is not valid (" + psex.getMessage() + ")"));
                                continue;
                            }
                            this._mstrict.put(ifacet, new Object[]{ileft, iright, ps});
                        } else {
                            lattributes.put(ssortedattributes, ifacet);
                        }
                    }
                    if ((sb = (StringBuilder)ht.get(mpattern)) == null) {
                        sb = new StringBuilder(2);
                        sb.append('\u0003');
                        ht.put(mpattern, sb);
                    } else {
                        Component.loggerMessage((String)("component [" + this.getName() + "] matcher pattern [" + mpattern + "] at line #[" + l + "] [" + line + "] is duplicate"));
                    }
                    sb.insert(sb.length() - 1, (char)ifacet.intValue());
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        catch (IOException ioex) {
            throw new MatcherException(ioex);
        }
        Component.loggerMessage((String)("component [" + this.getName() + "] patternfile [" + patternfile + "] loaded; found #[" + this._mattributes.size() + "] attribute combinations"));
        if (this._mattributes.size() > 65534) {
            throw new MatcherException("component [" + this.getName() + "] can support max [65534] different attribute combinations (in current patternfile [" + patternfile + "] there are [" + this._mattributes.size() + "])");
        }
        this._mw = MatchWords.getObject();
        this._mw.init(ht);
        Component.loggerMessage((String)("component [" + this.getName() + "] matchwords loaded with #[" + ht.size() + "] patterns"));
        ht = null;
    }

    @Override
    public ArrayList<BasicMatchItem> mark(final String inputText) {
        final ArrayList<BasicMatchItem> result = new ArrayList<BasicMatchItem>();
        MatchResult mr = new MatchResult(){

            public void setWordCount(int wcount) {
            }

            public void addMatch(char[] cl, int clidx, String mtext, int wnumber, int pos) {
                char patternlength = cl[clidx + 2];
                String pattern = String.valueOf(cl, clidx - patternlength + 1, patternlength);
                ArrayList<Integer> lfacet = new ArrayList<Integer>();
                int i = clidx + 3;
                char ic = '\u0000';
                while ((ic = cl[i++]) != '\u0003') {
                    lfacet.add(Integer.valueOf(ic));
                }
                int posstart = pos;
                int posend = pos + mtext.length();
                logger.debug((Object)("found text [" + mtext + "] (at tword [" + wnumber + "] tpos [" + pos + "]) matching pattern [" + pattern + "] (length [" + patternlength + "]) with facets " + lfacet));
                Iterator i$ = lfacet.iterator();
                while (i$.hasNext()) {
                    int facet = (Integer)i$.next();
                    int poss = posstart;
                    int pose = posend;
                    Object[] ao = (Object[])BasicMatcher.this._mstrict.get(facet);
                    if (ao != null) {
                        String surface;
                        Matcher m;
                        int left = (Integer)ao[0];
                        int right = (Integer)ao[1];
                        Pattern p = (Pattern)ao[2];
                        if (poss - left >= 0) {
                            poss -= left;
                        }
                        if (pose + right <= inputText.length()) {
                            pose += right;
                        }
                        if (!(m = p.matcher(surface = inputText.substring(poss, pose))).find()) continue;
                        if (left != 0 && m.start() - left == 0) {
                            poss += left;
                        }
                        if (right != 0 && m.end() + right == surface.length()) {
                            pose -= right;
                        }
                    }
                    List attributes = (List)BasicMatcher.this._mattributes.get(facet);
                    result.add(new BasicMatchItem(poss, pose - 1, new ArrayList<String>(attributes)));
                }
            }
        };
        this._mw.match(inputText, mr);
        return result;
    }

    @Override
    public Map<Integer, List<String>> getAttributes() {
        return this._mattributes;
    }

    private static final class DeploymentFeatures {
        static final ConfigurationFeature PATTERNFILE = ConfigurationFeature.createFeature((String)"PatternFile", (boolean)true, (String)"");
        static final ConfigurationFeature FIELDSEPARATOR = ConfigurationFeature.createFeature((String)"FieldSeparator", (boolean)false, (String)"|");
        static final ConfigurationFeature KEYVALUESEPARATOR = ConfigurationFeature.createFeature((String)"KeyValueSeparator", (boolean)false, (String)">");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{PATTERNFILE, FIELDSEPARATOR, KEYVALUESEPARATOR};

        private DeploymentFeatures() {
        }
    }

    private static final class CompilationFeatures {
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[0];

        private CompilationFeatures() {
        }
    }
}

