/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.ui.wizard;

import it.jrc.osint.crawler.ui.wizard.NewCrawlerConfigCreationPage;
import it.jrc.osint.util.ui.DialogUtil;
import it.jrc.osint.util.ui.wizard.SelectFileWizardPageController;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewCrawlerConfigWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "it.jrc.osint.ui.wizards.new.crawlerConfig";
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewCrawlerConfigCreationPage mainPage;
    private SelectFileWizardPageController selectFileController;

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile(this.selectFileController.getFilePath());
        if (file == null) {
            return false;
        }
        NewCrawlerConfigWizard.selectAndReveal((IResource)file, this.getWorkbench().getActiveWorkbenchWindow());
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)dw.getShell(), (String)"Failed to create Crawler Configuration", (String)e.getMessage(), (PartInitException)e);
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewCrawlerConfigCreationPage("createCrawlerConfigPage", this.getSelection());
        this.addPage((IWizardPage)this.mainPage);
        this.selectFileController = new SelectFileWizardPageController();
        this.selectFileController.setPageTitle("Optional: select text file to import seed URLs");
        this.selectFileController.setPageDescription("Optional: select text file to import seed URLs");
        this.selectFileController.setPageComplete(true);
        this.addPage(this.selectFileController.getView());
    }

    private IStructuredSelection getSelection() {
        return this.selection;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }

    private IWorkbench getWorkbench() {
        return this.workbench;
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                @Override
                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }
}

