/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.text;

import it.jrc.osint.operations.ErrorCodeRange;
import it.jrc.osint.operations.ErrorConditionCatalog;

public class ErrorConditions
extends ErrorConditionCatalog {
    public static String TEXT_EXTRACTION_FAILED = "textExtractionFailed";
    public static String EXTRACTION_PROVIDER_NOT_FOUND = "extractionProviderNotFound";
    public static String RSS_ITEM_NOT_FOUND = "rssItemNotFound";
    public static String CONTENT_TYPE_DETECTION_FAILED = "contentTypeDetectionFailed";
    public static String UNSUPPORTED_CONTENT_TYPE = "unsupportedContentType";
    private static ErrorConditions errorConditions = new ErrorConditions(ErrorCodeRange.TEXT_EXTRACTION.begin());

    static {
        errorConditions.registerErrorCondition(TEXT_EXTRACTION_FAILED, "Text extraction has failed");
        errorConditions.registerErrorCondition(EXTRACTION_PROVIDER_NOT_FOUND, "No extraction provider failed for document");
        errorConditions.registerErrorCondition(RSS_ITEM_NOT_FOUND, "Document not found for text extraction");
        errorConditions.registerErrorCondition(CONTENT_TYPE_DETECTION_FAILED, "Text extraction failed since the content type of a document could not be detected");
        errorConditions.registerErrorCondition(UNSUPPORTED_CONTENT_TYPE, "Text extraction failed since the content type of a document is not supported");
    }

    private ErrorConditions(int baseErrorCode) {
        super(baseErrorCode);
    }

    public static ErrorConditions getErrorConditions() {
        return errorConditions;
    }
}

