/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.text.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.extract.text.ErrorConditions;
import it.jrc.osint.extract.text.TextExtractionProvider;
import it.jrc.osint.extract.text.internal.TikaInstanceProvider;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.operations.OperationStatus;
import java.io.InputStream;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;

public class TikaTextExtractionProvider
implements TextExtractionProvider {
    private static final Logger log = LogManager.getLogger((String)TikaTextExtractionProvider.class.getCanonicalName());

    @Override
    public OperationStatus extract(InputStream in, DocumentMetaItem anItem) {
        OperationStatus resultStatus = OperationStatus.OK_STATUS;
        ErrorStatusMetaData emd = new ErrorStatusMetaData(anItem);
        RepositoryMetaData rmd = new RepositoryMetaData(anItem);
        try {
            Metadata metaData = new Metadata();
            String contentType = anItem.getContentType();
            String fileName = rmd.getFileName();
            Tika tika = TikaInstanceProvider.getTika();
            tika.setMaxStringLength(-1);
            String resultStr = null;
            if (contentType != null && fileName != null) {
                metaData.set("Content-Type", contentType);
                metaData.set("resourceName", fileName);
            }
            resultStr = tika.parseToString(in, metaData);
            if (metaData.get(TikaCoreProperties.TITLE) != null && metaData.get(TikaCoreProperties.TITLE).length() > 0) {
                anItem.setTitle(metaData.get(TikaCoreProperties.TITLE));
            } else {
                anItem.setTitle(fileName);
            }
            anItem.setText(resultStr);
            rmd.setTextExtracted(true);
        }
        catch (Throwable t) {
            log.error("Failed to extract text", t);
            resultStatus = new OperationStatus(ErrorConditions.getErrorConditions().getErrorCondition(ErrorConditions.TEXT_EXTRACTION_FAILED, t));
            emd.setOperationStatus(resultStatus);
            rmd.setTextExtracted(false);
        }
        return resultStatus;
    }
}

