/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.geocoder.GeocodeMatchResult;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.kml.ItemToKml;
import it.jrc.geoutils.GeoResource;
import it.jrc.geoutils.GeoUtils;
import it.jrc.matcher.MatchResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;

public class GeonamesChecker {
    private static final boolean DEBUG = true;
    Logger logger = Logger.getLogger((String)GeonamesChecker.class.getName());
    String filename = "WebContent/geonames.txt.gz";
    String langfile = "WebContent/iso-languagecodes.txt";
    long menodizero = 0L;
    long countries = 0L;
    long regions = 0L;
    long provincies = 0L;
    private HashMap<String, Integer> langmap;

    public static void main(String[] args) {
        try {
            new GeonamesChecker().checkMatching();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkMatching() throws IOException {
        String fullpath = "test/";
        GeocodeMatcher m = new GeocodeMatcher();
        ProcessRSS prss = m.init(fullpath, null);
        GeocodeMatchResult result = new GeocodeMatchResult();
        ProcessRSS.matcher.match("MEDFORD, New York (AP)  A 33-year-old man described by neighbors as polite and friendly was arrested Wednesday in connection with the deaths of four people who were shot at a New York pharmacy during a robbery for painkillers. David Laffer, whose marriage proposal a few years ago to his....", (MatchResult)result);
        String out = ItemToKml.resourcesToKml(result.getAllPlaces(), GeocodeMatcher.idmap);
        for (GeoResource res : result.getAllPlaces()) {
            System.out.println("---> " + res.getCleanName() + " " + res.cls);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("outGeores.kml"), "utf-8");
        writer.write(out);
        writer.close();
        System.out.println("Done!!");
    }

    public void compareFiles(String newOne, String oldOne) {
    }

    private void check() throws IOException {
        BufferedReader reader = this.getReader(this.filename);
        this.initLanguages(this.langfile);
        HashMap<Long, GeoResource> idmap = new HashMap<Long, GeoResource>();
        HashMap<String, StringBuilder> entries = new HashMap<String, StringBuilder>();
        long problems = 0L;
        long lc = 0L;
        while (reader.ready()) {
            String line = reader.readLine();
            ++lc;
            try {
                GeoResource gr = new GeoResource(line, ";", this.langmap);
                if (gr.name != null && !gr.name.equals("")) {
                    GeoResource f;
                    if (gr.gid == 38683895L) {
                        System.out.println("GRRRRR  " + gr);
                    }
                    if (gr.cls <= 0 && !idmap.containsKey(gr.gid)) {
                        idmap.put(gr.gid, gr);
                    } else if (gr.cls <= 0 && (f = idmap.get(gr.gid)) != null && gr.hasABetterLanguage(f)) {
                        idmap.put(gr.gid, gr);
                    }
                    String hexres = gr.toHexString();
                    if (entries.containsKey(gr.name)) {
                        StringBuilder oldString = (StringBuilder)entries.get(gr.name);
                        String test = oldString.toString();
                        int len = oldString.charAt(0);
                        oldString.setCharAt(0, (char)(++len));
                        oldString.append(hexres);
                        test = oldString.toString();
                        if (test != null) {
                            ++len;
                        }
                    } else {
                        char iival = '\u0001';
                        char ival = iival;
                        StringBuilder sb = new StringBuilder();
                        sb.append(ival);
                        sb.append(hexres);
                        iival = sb.charAt(0);
                        entries.put(gr.name, sb);
                    }
                }
                entries.put("@l']", new StringBuilder(3));
            }
            catch (Exception e) {
                this.logger.error((Object)("Skipping Line:" + lc + " line was:" + line + " error was :" + e.getClass().getCanonicalName() + ":" + e.getMessage()));
                ++problems;
            }
        }
        System.err.println(idmap.size());
        System.out.println();
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(1L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(17705196L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(18432628L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(84214861L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(17244207L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(50409607L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(33626330L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(16846035L, 15, idmap));
        System.err.println("----->" + GeocodeMatcher.getCompleteInfo(17369601L, 15, idmap));
        System.out.println();
        System.err.println("----->" + entries.get(38683895L));
        System.out.println("read : " + lc);
        System.out.println(" Countries " + this.countries + " regions " + this.regions + " provincies " + this.provincies);
    }

    private boolean checkResource(GeoResource gr) {
        if (gr.cls < -1) {
            ++this.menodizero;
            if (GeoUtils.isCountry((long)gr.gid)) {
                System.out.println("\tCountry");
                ++this.countries;
            } else if (GeoUtils.isRegion((long)gr.gid)) {
                System.out.println("\tRegion");
                ++this.regions;
            } else if (GeoUtils.isProvince((long)gr.gid)) {
                ++this.provincies;
                System.out.println("\tProvince");
            } else {
                System.out.println("\tPlace");
            }
            return false;
        }
        return true;
    }

    private BufferedReader getReader(String filename) throws IOException {
        System.err.println(new File(filename).exists());
        if (filename.endsWith("gz")) {
            return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(filename)), "utf-8"));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
    }

    private void initLanguages(String filename) {
        int count = 1;
        try {
            this.logger.info((Object)("Init languages from: " + filename));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
            String line = br.readLine();
            line = br.readLine();
            this.langmap = new HashMap(7000);
            while (line != null) {
                String[] strings = line.split("\t");
                String id = strings[2];
                if (id == null || id.length() == 0) {
                    id = strings[1];
                }
                if (id != null && id.length() > 0) {
                    this.langmap.put(id, count);
                    ++count;
                }
                line = br.readLine();
            }
            this.langmap.put("Eu", -1);
            this.langmap.put("PP", -3);
            this.langmap.put("Xl", -2);
        }
        catch (Exception e) {
            this.logger.info((Object)"Init Languages error:", (Throwable)e);
        }
        this.logger.info((Object)("Init found langauge count:" + this.langmap.size()));
    }
}

