/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Hashtable;

public class SimpleClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    URL baseUrl = null;

    public SimpleClassLoader(URL paths) {
        this.baseUrl = paths;
    }

    private byte[] getClassImplFromDataBase(String className) {
        try {
            className = new File(this.baseUrl.toURI()).toString() + "/" + className.replace('.', '/') + ".class";
            FileInputStream fi = new FileInputStream(className);
            byte[] result = new byte[fi.available()];
            fi.read(result);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        byte[] classData;
        Class<?> result = (Class<?>)this.classes.get(className);
        if (result != null) {
            return result;
        }
        if (className.endsWith("ItemTesterInt") || !className.startsWith("it.jrc.geocoder")) {
            try {
                result = super.findSystemClass(className);
                return result;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((classData = this.getClassImplFromDataBase(className)) == null) {
            throw new ClassNotFoundException();
        }
        result = this.defineClass(className, classData, 0, classData.length);
        if (result == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        this.classes.put(className, result);
        return result;
    }

    public static void main(String[] args) {
        try {
            System.out.println(SimpleClassLoader.getNewClass("it.jrc.blogconfigure.ConfigureBlog", new URL("file:/c:/Documents%20and%20Settings/buccist/jproject/BlogMonitor/bin/")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static Object getNewClass(String string, URL url) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SimpleClassLoader loader = new SimpleClassLoader(url);
        Class class1 = loader.loadClass(string);
        return class1.newInstance();
    }
}

