/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.test.debug.Result;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoStat {
    private static final String dir = "Q:/Stories";
    int days = 390;
    String[] langs = new String[]{"it"};
    String outputdir = "d:/geostats";
    List<String> daysName = Arrays.asList("20111103", "20111102", "20111101", "20111031", "20111030", "20111029", "20111028", "20111027", "20111026");
    public static boolean recalculate = true;
    ProcessRSS prss = null;
    RSSParser parser = new RSSParser();

    public static void main(String[] args) {
        try {
            new GeoStat().go();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void go() throws Exception {
        PrintStream newout = new PrintStream(new FileOutputStream("geoststs.log"));
        System.setOut(newout);
        String res = "";
        for (final String lang : this.langs) {
            File outdir = new File(this.outputdir + "/" + lang);
            if (!outdir.exists()) {
                outdir.mkdirs();
            } else {
                for (File file : outdir.listFiles()) {
                    file.delete();
                }
            }
            if (recalculate) {
                GeocodeMatcher m = new GeocodeMatcher();
                this.prss = m.init("WebContent/", null);
            }
            if (!new File(dir).exists()) {
                throw new IOException("please mount the Q: share!!!");
            }
            File[] files = new File(dir).listFiles();
            Arrays.sort(files, Collections.reverseOrder());
            Result result = new Result();
            for (int i = 1; i < this.days; ++i) {
                File day = files[i];
                if (!this.daysName.contains(day.getName())) continue;
                System.out.println("DAY : " + day);
                File[] stories = day.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().equals(lang);
                    }
                });
                for (File story : stories[0].listFiles()) {
                    if (story.getName().contains("#")) continue;
                    RSS rss = this.parse(story);
                    this.addResult(rss, result, recalculate, outdir);
                }
            }
            res = res + "RESULTS for (" + lang + ") \t" + result.total + " \t " + result.empty + " \t " + result.found + " \t " + result.single + "\n";
        }
        System.out.println();
        System.out.println(res);
        System.out.flush();
    }

    private void addResult(RSS rss, Result result, boolean recheck, File outdir) throws Exception {
        Vector items = rss.getItems();
        result.total += (long)items.size();
        ArrayList<Object> empties = new ArrayList<RSSItem>();
        if (recalculate) {
            this.prss.runForRSSMixed(rss);
        }
        for (RSSItem item : items) {
            ArrayList elements = item.getElements("emm:georss");
            if (elements == null || elements.size() == 0) {
                empties.add(item);
                ++result.empty;
                continue;
            }
            if (elements.size() == 1) {
                ++result.single;
                ++result.found;
                continue;
            }
            result.found += (long)elements.size();
        }
        if (empties.size() > 0) {
            try {
                this.saveEmpties(rss, empties, outdir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            empties = new ArrayList();
        }
    }

    private void saveEmpties(RSS rss, ArrayList<RSSItem> empties, File outdir) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outdir, rss.getGuid())), "utf-8");
        rss.getItems().clear();
        rss.getItems().addAll(empties);
        rss.toXML((Writer)writer);
        writer.close();
    }

    private RSS parse(File file) throws Exception {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
        RSS rss = this.parser.parse((Reader)reader);
        reader.close();
        return rss;
    }
}

