/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.emmutils.HTTPStream;
import it.jrc.geocoder.GeocodeMatchResult;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geoutils.GeoResource;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

public class OneIdTwoPattern {
    String file = "http://emm.jrc.it/rss?type=story&id=ap-en-000f3b18e446771fc6925b0451422af9&language=en&format=raw";
    String guid = "xinhuanet_en-39bda7220833281932b967713dce0f1c";
    private String fullpath = "WebContent/";
    RSSParser parser = new RSSParser();

    private void check() throws Exception {
        GeocodeMatcher m = new GeocodeMatcher();
        ProcessRSS prss = m.init(this.fullpath, null);
        String text = " Brazil ciao Brasile ";
        GeocodeMatchResult res = new GeocodeMatchResult();
        m.match(text, res);
        System.out.println(res.getAllPlaces());
        for (GeoResource r : res.getAllPlaces()) {
            System.out.println(r.getCleanName() + "  " + r.count + " I:" + r.internalCount + "  " + r.wpos + "   " + r.gid);
        }
    }

    private void leaveOnly(String guid, RSS rss) {
        Iterator iterator = rss.getItems().iterator();
        while (iterator.hasNext()) {
            RSSItem item = (RSSItem)iterator.next();
            if (item.getGuid().equals(guid)) continue;
            iterator.remove();
        }
    }

    public static void main(String[] args) {
        try {
            new OneIdTwoPattern().check();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void takeAwayGeo(RSS rss) {
        for (RSSItem item : rss.getItems()) {
            if (item.getElements("emm:georss").size() <= 0) continue;
            for (SimpleElement elem : item.getElements("emm:georss")) {
                item.removeElement(elem);
            }
        }
    }

    private RSS getRss() throws Exception {
        InputStreamReader reader = null;
        reader = this.file.startsWith("http") ? new InputStreamReader((InputStream)new HTTPStream(this.file)) : new InputStreamReader((InputStream)new FileInputStream(this.file), "utf-8");
        RSS rss = this.parser.parse((Reader)reader);
        reader.close();
        return rss;
    }
}

