/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug.xml;

import it.jrc.geocoder.test.debug.xml.XMLDocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReader {
    static XMLReader instance = new XMLReader();

    private XMLReader() {
    }

    public static XMLReader getInstance() {
        return instance;
    }

    public void read(InputStream is, javax.swing.text.Document d, int pos) throws IOException, BadLocationException {
        if (!(d instanceof XMLDocument)) {
            return;
        }
        XMLDocument doc = (XMLDocument)d;
        doc.setUserChanges(false);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setCoalescing(true);
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        try {
            DocumentBuilder dbXML = dbf.newDocumentBuilder();
            Document dom = dbXML.parse(is);
            this.fixDom(dom);
            ArrayList<DefaultStyledDocument.ElementSpec> specs = new ArrayList<DefaultStyledDocument.ElementSpec>();
            DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(new SimpleAttributeSet(), 2);
            specs.add(spec);
            if (doc.getLength() == 0) {
                this.writeNode(doc, dom, pos, specs);
            } else {
                this.writeNode(doc, dom.getDocumentElement(), pos, specs);
            }
            DefaultStyledDocument.ElementSpec[] data = new DefaultStyledDocument.ElementSpec[specs.size()];
            specs.toArray(data);
            doc.insert(pos, data);
            doc.setUserChanges(true);
        }
        catch (SAXException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getMessage());
        }
        catch (IOException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getMessage());
        }
    }

    private void fixDom(Document dom) {
        NodeList nodeList = dom.getChildNodes();
        this.fixNodeList(nodeList);
    }

    private void fixNodeList(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            if ("description".equals(item.getNodeName())) {
                item.setTextContent(this.cut(item.getTextContent()));
            }
            if (item.getChildNodes() == null) continue;
            this.fixNodeList(item.getChildNodes());
        }
    }

    private String cut(String nodeValue) {
        int MAX = 200;
        if (nodeValue.length() < MAX) {
            return nodeValue;
        }
        return nodeValue.substring(0, MAX) + "\n" + this.cut(nodeValue.substring(MAX));
    }

    public int writeNode(javax.swing.text.Document doc, Node node, int pos, ArrayList<DefaultStyledDocument.ElementSpec> specs) throws BadLocationException {
        NodeList list;
        SimpleAttributeSet tagAttrs = new SimpleAttributeSet();
        tagAttrs.addAttribute("$ename", XMLDocument.TAG_ELEMENT);
        SimpleAttributeSet tagRowStartAttrs = new SimpleAttributeSet();
        tagRowStartAttrs.addAttribute("$ename", XMLDocument.TAG_ROW_START_ELEMENT);
        SimpleAttributeSet tagRowEndAttrs = new SimpleAttributeSet();
        tagRowEndAttrs.addAttribute("$ename", XMLDocument.TAG_ROW_END_ELEMENT);
        DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(tagAttrs, 1);
        specs.add(spec);
        spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 1);
        specs.add(spec);
        int offs = pos;
        spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, "<".toCharArray(), 0, 1);
        specs.add(spec);
        if (node instanceof Document && doc.getLength() == 0) {
            Document dd = (Document)node;
            String nodeStr = "?xml version=\"" + dd.getXmlVersion() + "\" encoding=\"" + dd.getXmlEncoding() + "\"?";
            spec = new DefaultStyledDocument.ElementSpec(XMLDocument.TAGNAME_ATTRIBUTES, 3, nodeStr.toCharArray(), 0, nodeStr.length());
        } else {
            spec = new DefaultStyledDocument.ElementSpec(XMLDocument.TAGNAME_ATTRIBUTES, 3, node.getNodeName().toCharArray(), 0, node.getNodeName().length());
        }
        specs.add(spec);
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && attrs.getLength() > 0) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, " ".toCharArray(), 0, 1);
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.ATTRIBUTENAME_ATTRIBUTES, 3, name.toCharArray(), 0, name.length());
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, "=\"".toCharArray(), 0, 2);
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.ATTRIBUTEVALUE_ATTRIBUTES, 3, value.toCharArray(), 0, value.length());
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, "\"".toCharArray(), 0, 1);
                specs.add(spec);
            }
        }
        if ((list = node.getChildNodes()) != null && list.getLength() > 0) {
            spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, ">\n".toCharArray(), 0, 2);
            specs.add(spec);
            spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 2);
            specs.add(spec);
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n instanceof Element) {
                    Element child = (Element)n;
                    offs += this.writeNode(doc, child, offs, specs);
                    continue;
                }
                if (n.getNodeType() == 8) {
                    String str = n.getNodeValue();
                    int ii = str.indexOf("\n");
                    while (ii > 0) {
                        spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 1);
                        specs.add(spec);
                        String value = str.substring(0, ii);
                        spec = new DefaultStyledDocument.ElementSpec(XMLDocument.COMMENT_ATTRIBUTES, 3, value.toCharArray(), 0, value.length());
                        specs.add(spec);
                        spec = new DefaultStyledDocument.ElementSpec(XMLDocument.COMMENT_ATTRIBUTES, 3, "\n".toCharArray(), 0, 1);
                        specs.add(spec);
                        spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 2);
                        specs.add(spec);
                        str = str.substring(ii + 1);
                        ii = str.indexOf("\n");
                    }
                    spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 1);
                    specs.add(spec);
                    spec = new DefaultStyledDocument.ElementSpec(XMLDocument.COMMENT_ATTRIBUTES, 3, str.toCharArray(), 0, str.length());
                    specs.add(spec);
                    spec = new DefaultStyledDocument.ElementSpec(XMLDocument.COMMENT_ATTRIBUTES, 3, "\n".toCharArray(), 0, 1);
                    specs.add(spec);
                    spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 2);
                    specs.add(spec);
                    continue;
                }
                spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 1);
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.PLAIN_ATTRIBUTES, 3, n.getNodeValue().toCharArray(), 0, n.getNodeValue().length());
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.PLAIN_ATTRIBUTES, 3, "\n".toCharArray(), 0, 1);
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(tagRowStartAttrs, 2);
                specs.add(spec);
            }
            spec = new DefaultStyledDocument.ElementSpec(tagRowEndAttrs, 1);
            specs.add(spec);
            if (node instanceof Document) {
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.TAGNAME_ATTRIBUTES, 3, " ".toCharArray(), 0, 1);
                specs.add(spec);
            } else {
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, "</".toCharArray(), 0, 2);
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.TAGNAME_ATTRIBUTES, 3, node.getNodeName().toCharArray(), 0, node.getNodeName().length());
                specs.add(spec);
                spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, ">\n".toCharArray(), 0, 2);
                specs.add(spec);
            }
            spec = new DefaultStyledDocument.ElementSpec(tagRowEndAttrs, 2);
            specs.add(spec);
        } else {
            spec = new DefaultStyledDocument.ElementSpec(XMLDocument.BRACKET_ATTRIBUTES, 3, "/>\n".toCharArray(), 0, 3);
            specs.add(spec);
            spec = new DefaultStyledDocument.ElementSpec(new SimpleAttributeSet(), 2);
            specs.add(spec);
        }
        spec = new DefaultStyledDocument.ElementSpec(tagAttrs, 2);
        specs.add(spec);
        return offs - pos;
    }

    public int writeNodeOld(javax.swing.text.Document doc, Element node, int pos) throws BadLocationException {
        NodeList list;
        int offs = pos;
        doc.insertString(offs, "<", XMLDocument.BRACKET_ATTRIBUTES);
        doc.insertString(++offs, node.getNodeName(), XMLDocument.TAGNAME_ATTRIBUTES);
        offs += node.getNodeName().length();
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && attrs.getLength() > 0) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                doc.insertString(offs, " ", XMLDocument.BRACKET_ATTRIBUTES);
                doc.insertString(++offs, name, XMLDocument.ATTRIBUTENAME_ATTRIBUTES);
                doc.insertString(offs += name.length(), "=\"", XMLDocument.BRACKET_ATTRIBUTES);
                doc.insertString(offs += 2, value, XMLDocument.ATTRIBUTEVALUE_ATTRIBUTES);
                doc.insertString(offs += value.length(), "\"", XMLDocument.BRACKET_ATTRIBUTES);
                ++offs;
            }
        }
        if ((list = node.getChildNodes()) != null && list.getLength() > 0) {
            doc.insertString(offs, ">\n", XMLDocument.BRACKET_ATTRIBUTES);
            offs += 2;
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n instanceof Element) {
                    Element child = (Element)n;
                    offs += this.writeNodeOld(doc, child, offs);
                    continue;
                }
                doc.insertString(offs, n.getNodeValue() + "\n", XMLDocument.PLAIN_ATTRIBUTES);
                offs += n.getNodeValue().length() + 1;
            }
            doc.insertString(offs, "<", XMLDocument.BRACKET_ATTRIBUTES);
            doc.insertString(++offs, node.getNodeName(), XMLDocument.TAGNAME_ATTRIBUTES);
            doc.insertString(offs += node.getNodeName().length(), "/>\n", XMLDocument.BRACKET_ATTRIBUTES);
            offs += 3;
        } else {
            doc.insertString(offs, "/>\n", XMLDocument.BRACKET_ATTRIBUTES);
            offs += 3;
        }
        return offs - pos;
    }

    private static void printNode(Node node, String indent) {
        switch (node.getNodeType()) {
            case 9: {
                System.out.println("<xml version=\"1.0\">\n");
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    XMLReader.printNode(nodes.item(i), "");
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                System.out.print(indent + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    System.out.print(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\"");
                }
                System.out.print(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        XMLReader.printNode(children.item(i), indent + "  ");
                    }
                }
                System.out.print("</" + name + ">");
                break;
            }
            case 3: {
                System.out.print(node.getNodeValue());
                break;
            }
            default: {
                System.out.print(node.getNodeValue());
            }
        }
    }
}

