/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.internal;

import it.jrc.osint.console.OSINTConsolePlugin;
import it.jrc.osint.crawler.CrawlerConfiguration;
import it.jrc.osint.crawler.internal.BookmarkCrawler;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.util.URLFilter;
import it.jrc.osint.util.URLUtil;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.workspace.CaseProject;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CrawlJob
extends Job {
    private static final Logger log = LogManager.getLogger((String)CrawlJob.class.getName());
    private CrawlerConfiguration config;
    private List<URLBookmark> bookmarks = new ArrayList<URLBookmark>();
    private CaseProject targetProject;
    private String operationName;

    public CrawlJob(String jobName, CrawlerConfiguration config, String operationName, CaseProject targetProject) {
        super(jobName);
        this.config = config;
        this.operationName = operationName;
        this.targetProject = targetProject;
    }

    public List<URLBookmark> getBookmarks() {
        return this.bookmarks;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public CaseProject getTargetProject() {
        return this.targetProject;
    }

    protected IStatus run(IProgressMonitor monitor) {
        log.debug("user.dir:" + System.getProperty("user.dir"));
        monitor.beginTask("Crawling ", -1);
        Writer out = null;
        try {
            try {
                ArrayList<String> urls = new ArrayList<String>();
                urls.addAll(this.config.getSites());
                BookmarkCrawler crawler = new BookmarkCrawler(urls, this.config.getMaxDepth(), this.config.getWorkersPerSite(), this.config.getRandomDelayMs(), monitor);
                crawler.start();
                crawler.sync();
                monitor.subTask("Importing crawled bookmarks");
                List<URLBookmark> crawledBookmarks = crawler.getBookmarks();
                URLFilter includeFilter = null;
                if (this.config.getIncludePattern() != null && !"".equals(this.config.getIncludePattern())) {
                    includeFilter = URLUtil.createFilter((String[])new String[]{this.config.getIncludePattern()});
                }
                URLFilter excludeFilter = null;
                if (this.config.getExcludePattern() != null && !"".equals(this.config.getExcludePattern())) {
                    excludeFilter = URLUtil.createFilter((String[])new String[]{this.config.getExcludePattern()});
                }
                Iterator<URLBookmark> bmIterator = crawledBookmarks.iterator();
                while (bmIterator.hasNext()) {
                    boolean addBookmark = true;
                    URLBookmark bm = bmIterator.next();
                    if (includeFilter != null && !includeFilter.matches(bm.getURL())) {
                        addBookmark = false;
                    }
                    if (excludeFilter != null && excludeFilter.matches(bm.getURL())) {
                        addBookmark = false;
                    }
                    if (addBookmark) {
                        this.bookmarks.add(bm);
                        continue;
                    }
                    OSINTConsolePlugin.getConsole().info("Bookmark with URL " + bm.getURL() + " filtered out due to settings in crawler configuration");
                }
            }
            catch (Exception e) {
                log.error("Exception occurred during crawl operation", (Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                monitor.done();
                FileUtil.close(out);
                return iStatus;
            }
        }
        finally {
            monitor.done();
            FileUtil.close(out);
        }
        return Status.OK_STATUS;
    }
}

