/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.decorator;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.ui.WorkspaceUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.widgets.Display;

public class DocumentsFolderDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private static final Logger log = LogManager.getLogger((String)DocumentsFolderDecorator.class.getName());

    public void decorate(Object element, final IDecoration decoration) {
        IFolder aFolder;
        if (element instanceof IFolder && "Documents".equals((aFolder = (IFolder)element).getName())) {
            IContainer parent = aFolder.getParent();
            try {
                if (parent instanceof IProject) {
                    IProject parentProject = (IProject)parent;
                    if (!parentProject.isAccessible()) {
                        return;
                    }
                    if (parentProject.hasNature("it.jrc.osint.workspace.caseProjectNature")) {
                        IDecorationContext context = decoration.getDecorationContext();
                        if (context instanceof DecorationContext) {
                            ((DecorationContext)context).putProperty("org.eclipse.jface.viewers.IDecoration.disableReplace", (Object)Boolean.TRUE);
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ImageDescriptor overlayIcon = WorkspaceUIPlugin.getPlugin().getImageRegistry().getDescriptor("workset");
                                    decoration.addOverlay(overlayIcon, 5);
                                }
                                catch (Throwable t) {
                                    log.error("Failed to place overlay icon for Documents folder", t);
                                }
                            }
                        });
                    }
                }
            }
            catch (Throwable t) {
                log.error("Decoration failed", t);
            }
        }
    }
}

