/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.navigator;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class FolderStatusProvider
extends LabelProviderAdapter
implements IDescriptionProvider {
    private static final Logger log = LogManager.getLogger((String)FolderStatusProvider.class.getName());

    public String getDescription(Object anElement) {
        if (anElement == null) {
            return "";
        }
        if (anElement instanceof IProject) {
            IProject prj = (IProject)anElement;
            IPath path = prj.getLocation();
            if (path != null) {
                return path.toString();
            }
            return prj.getName();
        }
        if (anElement instanceof IFolder) {
            try {
                IFolder folder = (IFolder)anElement;
                IResource[] members = folder.members();
                if (members != null) {
                    StringBuffer strBuf = new StringBuffer(folder.getFullPath().toString());
                    strBuf.append("  (");
                    strBuf.append(this.numFiles(members));
                    strBuf.append(" files  ");
                    strBuf.append(this.numFolders(members));
                    strBuf.append(" folders)");
                    return strBuf.toString();
                }
            }
            catch (CoreException e) {
                log.error("Failed to retrieve number of contained files", (Throwable)e);
            }
        }
        return null;
    }

    private int numFiles(IResource[] members) {
        int numFiles = 0;
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile) {
                ++numFiles;
            }
            ++n2;
        }
        return numFiles;
    }

    private int numFolders(IResource[] members) {
        int numFolders = 0;
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder) {
                ++numFolders;
            }
            ++n2;
        }
        return numFolders;
    }
}

