/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.preferences;

import it.jrc.osint.workspace.ConfigProject;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ActiveConfigProjectPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ComboFieldEditor activeConfigProjectCombo;

    public ActiveConfigProjectPreferencePage() {
        super(1);
        IScopeContext is = InstanceScope.INSTANCE;
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(is, "it.jrc.osint.workspace");
        this.setPreferenceStore((IPreferenceStore)prefStore);
        this.setDescription("Select active configuration project for current workspace");
    }

    public void createFieldEditors() {
        WorkspaceService ws = WorkspacePlugin.getWorkspaceService();
        List configProjects = ws.getConfigProjects();
        if (configProjects.isEmpty()) {
            String[][] comboModel = new String[][]{{"", ""}};
            this.activeConfigProjectCombo = new ComboFieldEditor("activeConfigProject", "Configuration Project", comboModel, this.getFieldEditorParent());
            this.activeConfigProjectCombo.setEnabled(false, this.getFieldEditorParent());
        } else {
            String[][] comboModel = new String[configProjects.size()][2];
            int i = 0;
            while (i < configProjects.size()) {
                ConfigProject prj = (ConfigProject)configProjects.get(i);
                comboModel[i][0] = prj.getName();
                comboModel[i][1] = prj.getId().toString();
                ++i;
            }
            this.activeConfigProjectCombo = new ComboFieldEditor("activeConfigProject", "Configuration Project", comboModel, this.getFieldEditorParent());
        }
        this.addField((FieldEditor)this.activeConfigProjectCombo);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        return super.performOk();
    }
}

