/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.views;

import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.ui.WorkspaceUIPlugin;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class FileIndexView
extends ViewPart {
    public static final String VIEW_ID = "it.jrc.osint.ui.views.fileIndex";
    private TableViewer tableViewer;
    private Table table;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite(container, 0);
        composite.setBounds(0, 0, 64, 64);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(composite, 67584);
        this.tableViewer.setColumnProperties(new String[0]);
        String[] titles = new String[]{"Path", "Id", "Deleted", "Type"};
        int[] bounds = new int[]{250, 150, 20, 20};
        TableViewerColumn col = this.createTableViewerColumn(this.tableViewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WorkspaceService.IndexEntry e = (WorkspaceService.IndexEntry)element;
                return e.getPath().toString();
            }
        });
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 150, true));
        col = this.createTableViewerColumn(this.tableViewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WorkspaceService.IndexEntry e = (WorkspaceService.IndexEntry)element;
                return e.getId().toString();
            }
        });
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 150, true));
        col = this.createTableViewerColumn(this.tableViewer, titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WorkspaceService.IndexEntry e = (WorkspaceService.IndexEntry)element;
                if (e.getType() == 1) {
                    return "F";
                }
                if (e.getType() == 4) {
                    return "P";
                }
                return "D";
            }
        });
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(15, 20, true));
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof WorkspaceService.IndexEntry && e2 instanceof WorkspaceService.IndexEntry) {
                    String path1 = ((WorkspaceService.IndexEntry)e1).getPath().toString();
                    String path2 = ((WorkspaceService.IndexEntry)e2).getPath().toString();
                    return path1.compareTo(path2);
                }
                throw new IllegalArgumentException("Not comparable: " + e1 + " " + e2);
            }
        });
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.refresh();
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createActions() {
    }

    private void initializeToolBar() {
    }

    private void initializeMenu() {
    }

    public void setFocus() {
    }

    public void refresh() {
        List indexEntries = WorkspaceUIPlugin.getWorkspaceService().getIndexEntries();
        this.tableViewer.setInput((Object)indexEntries);
    }
}

