/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.wizard;

import it.jrc.osint.workspace.ui.wizard.WorkspaceMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetGroup;

public class WizardNewProjectCreationPage
extends WizardPage {
    private String initialProjectFieldValue;
    Text projectNameField;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = WizardNewProjectCreationPage.this.validatePage();
            WizardNewProjectCreationPage.this.setPageComplete(valid);
        }
    };
    private WorkingSetGroup workingSetGroup;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public WizardNewProjectCreationPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public WizardNewProjectCreationPage(String pageName, IStructuredSelection selection, String[] workingSetTypes) {
        this(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public WorkingSetGroup createWorkingSetGroup(Composite composite, IStructuredSelection selection, String[] supportedWorkingSetTypes) {
        if (this.workingSetGroup != null) {
            return this.workingSetGroup;
        }
        this.workingSetGroup = new WorkingSetGroup(composite, selection, supportedWorkingSetTypes);
        return this.workingSetGroup;
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(WorkspaceMessages.WizardNewProjectCreationPage_nameLabel);
        projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String name) {
        this.initialProjectFieldValue = name == null ? null : name.trim();
    }

    protected boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkspaceMessages.WizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(WorkspaceMessages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return true;
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup == null ? new IWorkingSet[]{} : this.workingSetGroup.getSelectedWorkingSets();
    }
}

