/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component;

import it.jrc.lt.core.component.ConfigurationFeature;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import piskorski.util.functions.PropertiesFunctions;

public class Configuration {
    protected Properties settings = new Properties();
    private static final Configuration nullConfiguration = new Configuration(){

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public String getFeature(String featureName) {
            return "";
        }

        @Override
        public String getFeature(String featureName, String tempDefault) {
            return tempDefault;
        }

        @Override
        public void addFeature(String featureName, String featureValue) {
        }
    };

    protected Configuration() {
    }

    public static Configuration getInstance() {
        return new Configuration();
    }

    public static Configuration initializeFrom(String fileName) {
        Properties properties = PropertiesFunctions.readProperties(fileName);
        if (properties == null) {
            return nullConfiguration;
        }
        Configuration conf = Configuration.getInstance();
        conf.settings.putAll((Map<?, ?>)properties);
        return conf;
    }

    public static Configuration initializeFrom(String fileName, String charSet) {
        Properties properties = PropertiesFunctions.readProperties(fileName, charSet);
        if (properties == null) {
            return nullConfiguration;
        }
        Configuration conf = Configuration.getInstance();
        conf.settings.putAll((Map<?, ?>)properties);
        return conf;
    }

    public static Configuration initializeFrom(Properties properties) {
        if (properties == null) {
            return nullConfiguration;
        }
        Configuration conf = Configuration.getInstance();
        conf.settings.putAll((Map<?, ?>)properties);
        return conf;
    }

    public String getFeature(String featureName) {
        return this.settings.getProperty(featureName);
    }

    public String getFeature(String featureName, String tempDefault) {
        return this.settings.getProperty(featureName, tempDefault);
    }

    public void addFeature(String featureName, String featureValue) {
        this.settings.put(featureName, featureValue);
    }

    public ArrayList<String> checkConfiguration(List<ConfigurationFeature> specificFeatures) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (this.isNull()) {
            errorList.add("Empty configuration object.");
        }
        for (ConfigurationFeature f : specificFeatures) {
            if (f.isObligatory()) {
                if (this.getFeature(f.getName()) != null) continue;
                errorList.add("<" + f.getName() + "> feature is missing");
                continue;
            }
            if (this.getFeature(f.getName()) != null) continue;
            this.addFeature(f.getName(), f.defaultValue());
        }
        return errorList;
    }

    public boolean isNull() {
        return false;
    }

    public String print() {
        StringBuffer conf = new StringBuffer();
        Set<String> names = this.stringPropertyNames(this.settings);
        for (String name : names) {
            conf.append(name + "=" + this.settings.getProperty(name));
            conf.append(" ");
        }
        return conf.toString();
    }

    private Set<String> stringPropertyNames(Properties props) {
        HashSet<String> retVal = new HashSet<String>();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (!(key instanceof String)) continue;
            retVal.add((String)key);
        }
        return retVal;
    }
}

