/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.application;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.application.AbstractComponentApplication;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractDisjunctionOfFlatPatternMatcherItems;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractFlatPatternMatcher;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractFlatPatternMatcherItem;
import it.jrc.lt.core.component.flatpatternmatcher.TokenTagger;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.util.ArrayList;

public class BasicFlatPatternMatcherApp
extends AbstractComponentApplication {
    private static final String RESOURCE_FILE = "ResourceFile";
    private static final String TOKENIZER_RESOURCE_FILE = "TokenizerResourceFile";
    private static final String TOKENIZER_PRODUCES_WHITESPACES = "TokenizerProducesWhitespaces";
    private static final String TOKENTAGGER = "TokenTagger";
    private static final String TOKENTAGGER_CONFIGURATION_FILE = "TokenTaggerConfigurationFile";
    private TokenTagger tokenTagger;
    private AbstractTokenizer tokenizer;
    private AbstractFlatPatternMatcher matcher;

    @Override
    public boolean initialize(Configuration configuration) {
        this.tokenizer = AbstractTokenizer.createInstance("basicTokenizer");
        String tokenizerFile = configuration.getFeature(TOKENIZER_RESOURCE_FILE, "");
        String producesWhitespaces = configuration.getFeature(TOKENIZER_PRODUCES_WHITESPACES, "true");
        if (tokenizerFile.compareTo("") == 0) {
            return false;
        }
        this.tokenizer.readFromFile(tokenizerFile);
        if (producesWhitespaces.compareTo("true") == 0) {
            this.tokenizer.produceWhitespaceTokens();
        }
        if (this.tokenizer.isNullComponent() || !this.tokenizer.hasBeenInitialized()) {
            return false;
        }
        String tokenTaggerName = configuration.getFeature(TOKENTAGGER, "");
        String tokenTaggerFile = configuration.getFeature(TOKENTAGGER_CONFIGURATION_FILE, "");
        this.tokenTagger = TokenTagger.getInstance(tokenTaggerName);
        if (this.tokenTagger == null) {
            return false;
        }
        if (!this.tokenTagger.initialize(tokenTaggerFile)) {
            return false;
        }
        this.matcher = AbstractFlatPatternMatcher.createInstance("basicFlatPatternMatcher");
        boolean status = this.matcher.readFromFile(configuration.getFeature(RESOURCE_FILE, ""));
        this.matcher.applySettings(configuration);
        return status && !this.matcher.isNullComponent() && this.matcher.hasBeenInitialized();
    }

    @Override
    public StringBuffer process(String inputText) {
        ArrayList<AbstractTokenItem> tokens = this.tokenizer.tokenize(inputText);
        ArrayList<AbstractDisjunctionOfFlatPatternMatcherItems> matchItems = this.matcher.findMatch(tokens, inputText, this.tokenTagger);
        StringBuffer result = new StringBuffer();
        boolean tokenPositions = this.matcher.producesTokenPositions();
        for (AbstractDisjunctionOfFlatPatternMatcherItems it : matchItems) {
            int numItems = it.getNumberOfItems();
            for (int k = 0; k < numItems; ++k) {
                AbstractFlatPatternMatcherItem item = it.getItem(k);
                int start = tokenPositions ? tokens.get(item.getStart()).getStart() : item.getStart();
                int end = tokenPositions ? tokens.get(item.getEnd()).getEnd() : item.getEnd();
                result.append(inputText.substring(start, end + 1));
                result.append(" ");
                result.append(item.toString());
                result.append(LINE_SEPARATOR);
            }
            result.append("----------------------------------");
            result.append(LINE_SEPARATOR);
        }
        return result;
    }
}

