/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.application;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.application.AbstractComponentApplication;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import java.util.ArrayList;

public class BasicTokenizerApp
extends AbstractComponentApplication {
    private static final String RESOURCE_FILE = "ResourceFile";
    private AbstractTokenizer tokenizer;

    @Override
    public boolean initialize(Configuration configuration) {
        this.tokenizer = AbstractTokenizer.createInstance("basicTokenizer");
        boolean status = this.tokenizer.readFromFile(configuration.getFeature(RESOURCE_FILE, ""));
        this.tokenizer.applySettings(configuration);
        return status && !this.tokenizer.isNullComponent() && this.tokenizer.hasBeenInitialized();
    }

    @Override
    public StringBuffer process(String inputText) {
        ArrayList<AbstractTokenItem> tokens = this.tokenizer.tokenize(inputText);
        StringBuffer result = new StringBuffer();
        for (AbstractTokenItem t : tokens) {
            result.append(t.toString() + " | " + (!t.isWhiteSpace() ? t.getText(inputText) : "-WHITESPACE-") + LINE_SEPARATOR);
            result.append("----------------------------------");
            result.append(LINE_SEPARATOR);
        }
        return result;
    }
}

