/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.flatpatternmatcher;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.ComponentException;
import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.ConfigurationFeature;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractDisjunctionOfFlatPatternMatcherItems;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractFlatPatternMatcher;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractFlatPatternMatcherItem;
import it.jrc.lt.core.component.flatpatternmatcher.MatchStrategy;
import it.jrc.lt.core.component.flatpatternmatcher.TokenTagger;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSATraversing;
import piskorski.fs.letterfs.fsa.DynamicLetterMarkedTravFSAInterface;
import piskorski.fs.letterfs.fsa.FiniteStateAlgorithms;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.functions.DataStream;
import piskorski.util.functions.Files;
import piskorski.util.functions.Maps;

public final class BasicFlatPatternMatcher
extends AbstractFlatPatternMatcher {
    String[] types = null;
    String[] subtypes = null;
    String[] patternElements = null;
    private transient HashMap<String, Integer> typesMapping = null;
    private transient HashMap<String, Integer> subTypesMapping = null;
    private transient HashMap<String, Integer> patternElementsMapping = null;
    private static transient int UNDEFINED_TAG = -1;
    private DictionaryLetterFSA patternMatcherAutomaton = null;
    private final int patternBoundaryMarker = 0;
    private static final char comment = '#';
    private static final char startTokenClass = '[';
    private static final char endTokenClass = ']';
    private static final String patternElementSeparator = " ";
    private static final char rangeOpenBracket = '<';
    private static final char rangeCloseBracket = '>';
    private static final String rangeSeparator = ",";
    private static final transient String className = "[" + BasicFlatPatternMatcher.class.getSimpleName() + "] ";

    protected BasicFlatPatternMatcher() {
        this.setDefaults();
        this.name = null;
    }

    private void setDefaults() {
        this.setMatchStrategy(MatchStrategy.LONGEST_MATCH);
        this.caseSensitiveModeActive();
        this.returnCharacterPositions();
    }

    @Override
    protected List<ConfigurationFeature> getCompilationFeatures() {
        return Collections.unmodifiableList(Arrays.asList(CompilationFeatures.FEATURES));
    }

    @Override
    protected List<ConfigurationFeature> getDeploymentFeatures() {
        return Collections.unmodifiableList(Arrays.asList(DeploymentFeatures.FEATURES));
    }

    @Override
    protected void applySpecificSettings(Configuration configuration) {
        MatchStrategy[] myStrategies;
        if (configuration.getFeature(DeploymentFeatures.CASE_SENSITIVE.getName()).compareTo("false") == 0) {
            this.caseInsensitiveModeActive();
        }
        if (configuration.getFeature(DeploymentFeatures.OUTPUT_TOKEN_POSITIONS.getName()).compareTo("true") == 0) {
            this.returnTokenPositions();
        }
        String strategy = configuration.getFeature(DeploymentFeatures.MATCH_STRATEGY.getName());
        for (MatchStrategy s : myStrategies = MatchStrategy.values()) {
            if (s.getName().compareTo(strategy) != 0) continue;
            this.setMatchStrategy(s);
        }
    }

    private DictionaryLetterFSA constructAutomaton(StringArrayList entries) {
        Component.loggerMessage("Flat Pattern Matcher automaton construction");
        DynamicLetterMarkedTravFSAInterface tempAutomaton = FiniteStateAlgorithms.MinDetAutomatonFromListOfWordsX(entries.toArray(), false, 10, 3, false);
        Component.loggerMessage("Flat Pattern Matcher automaton compression");
        DictionaryLetterFSA compressedAutomaton = DictionaryLetterFSA.getInstance("BASIC");
        compressedAutomaton.initializeFrom(tempAutomaton);
        return compressedAutomaton;
    }

    private StringArrayList encodePatterns(StringArrayList entries, boolean downcaseEntries) throws ComponentException {
        int len = entries.size();
        StringArrayList encodedPatterns = new StringArrayList(len);
        this.typesMapping = new HashMap();
        this.subTypesMapping = new HashMap();
        this.patternElementsMapping = new HashMap();
        this.typesMapping.put("", 0);
        this.subTypesMapping.put("", 0);
        this.patternElementsMapping.put("", 0);
        int typeCounter = 1;
        int subtypeCounter = 1;
        int patternElementCounter = 1;
        StringBuffer currentEncodedPattern = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            String next = entries.get(i);
            StringTokenizer st = new StringTokenizer(next, "\t");
            if (st.countTokens() < 3) {
                Component.loggerMessageAndExit("Syntax error at line with the entry: " + next);
            }
            String pattern = st.nextToken();
            String type = st.nextToken();
            String subtype = st.nextToken();
            if (!this.typesMapping.containsKey(type)) {
                this.typesMapping.put(type, typeCounter++);
            }
            if (!this.subTypesMapping.containsKey(subtype)) {
                this.subTypesMapping.put(subtype, subtypeCounter++);
            }
            StringTokenizer myPattern = new StringTokenizer(pattern, patternElementSeparator);
            currentEncodedPattern.setLength(0);
            while (myPattern.hasMoreElements()) {
                String nextElement = myPattern.nextToken();
                if (downcaseEntries && nextElement.charAt(0) != '[' && nextElement.indexOf(93) == -1) {
                    nextElement = nextElement.toLowerCase();
                }
                if (!this.patternElementsMapping.containsKey(nextElement)) {
                    this.patternElementsMapping.put(nextElement, patternElementCounter++);
                }
                currentEncodedPattern.append((char)this.patternElementsMapping.get(nextElement).intValue());
            }
            currentEncodedPattern.append((char)this.patternBoundaryMarker);
            currentEncodedPattern.append((char)this.typesMapping.get(type).intValue());
            currentEncodedPattern.append((char)this.subTypesMapping.get(subtype).intValue());
            encodedPatterns.add(currentEncodedPattern.toString());
        }
        return encodedPatterns;
    }

    private StringArrayList expandEntries(String[] entries, String whitespace_code) throws ComponentException {
        int len = entries.length;
        StringArrayList expandedPatterns = new StringArrayList(len);
        for (int i = 0; i < len; ++i) {
            String next = entries[i];
            StringTokenizer st = new StringTokenizer(next, "\t");
            if (st.countTokens() < 3) {
                Component.loggerMessageAndExit("Syntax error at line with the entry: " + next);
            }
            String pattern = st.nextToken();
            String type = st.nextToken();
            String subtype = st.nextToken();
            StringArrayList myExpandedPatterns = this.expandPattern(pattern, whitespace_code);
            if (myExpandedPatterns == null) {
                Component.loggerMessageAndExit("Syntax error at line with the entry (while expanding pattern): " + next);
            }
            int numMyExpandedPatterns = myExpandedPatterns.size();
            for (int k = 0; k < numMyExpandedPatterns; ++k) {
                expandedPatterns.add(myExpandedPatterns.get(k) + "\t" + type + "\t" + subtype);
            }
        }
        return expandedPatterns;
    }

    private StringArrayList expandPattern(String restPattern, String whitespace_code) {
        StringArrayList result = new StringArrayList();
        int endPos = restPattern.indexOf(32);
        StringArrayList currentResult = new StringArrayList();
        String patternElement = endPos == -1 ? restPattern : restPattern.substring(0, endPos);
        int startTokenClassIndex = patternElement.indexOf(91);
        int endTokenClassIndex = patternElement.indexOf(93);
        if (startTokenClassIndex == 0 && endTokenClassIndex != -1) {
            int startBracket = patternElement.indexOf(60, endTokenClassIndex);
            int endBracket = patternElement.indexOf(62, endTokenClassIndex);
            if (startBracket == endTokenClassIndex + 1 && endBracket == patternElement.length() - 1 && startBracket + 3 < endBracket) {
                int max;
                int min;
                StringTokenizer st = new StringTokenizer(patternElement.substring(startBracket + 1, endBracket), rangeSeparator, true);
                if (st.countTokens() != 3) {
                    return null;
                }
                String minS = st.nextToken();
                String comma = st.nextToken();
                String maxS = st.nextToken();
                if (comma.length() != 1) {
                    return null;
                }
                if (comma.compareTo(rangeSeparator) != 0) {
                    return null;
                }
                try {
                    min = Integer.parseInt(minS);
                    max = Integer.parseInt(maxS);
                }
                catch (Exception e) {
                    return null;
                }
                if (min > max) {
                    return null;
                }
                StringBuffer newElem = new StringBuffer();
                String toRepeat = patternElement.substring(startTokenClassIndex, endTokenClassIndex + 1);
                for (int i = 0; i < min; ++i) {
                    newElem.append(toRepeat);
                    if (i + 1 >= min) continue;
                    newElem.append(patternElementSeparator);
                    if (whitespace_code.length() <= 0) continue;
                    newElem.append(whitespace_code);
                    newElem.append(patternElementSeparator);
                }
                currentResult.add(newElem.toString());
                for (int k = min; k < max; ++k) {
                    newElem.append(patternElementSeparator);
                    if (whitespace_code.length() > 0) {
                        newElem.append(whitespace_code);
                        newElem.append(patternElementSeparator);
                    }
                    newElem.append(toRepeat);
                    currentResult.add(newElem.toString());
                }
            } else {
                if (endTokenClassIndex != patternElement.length() - 1) {
                    return null;
                }
                currentResult.add(patternElement);
            }
        } else {
            currentResult.add(patternElement);
        }
        if (endPos == -1) {
            return currentResult;
        }
        StringArrayList resultForRestPattern = this.expandPattern(restPattern.substring(endPos + 1), whitespace_code);
        if (resultForRestPattern == null) {
            return null;
        }
        int numElements = currentResult.size();
        for (int i = 0; i < numElements; ++i) {
            int numOtherElements = resultForRestPattern.size();
            String currentEl = currentResult.get(i);
            for (int k = 0; k < numOtherElements; ++k) {
                result.add(currentEl + patternElementSeparator + resultForRestPattern.get(k));
            }
        }
        return result;
    }

    private void createinitialiseDataStructures() {
        this.types = Maps.convertHashMapToStringArray(this.typesMapping);
        this.subtypes = Maps.convertHashMapToStringArray(this.subTypesMapping);
        this.patternElements = Maps.convertHashMapToStringArray(this.patternElementsMapping);
    }

    private void createHashMaps() {
        this.typesMapping = Maps.convertStringArrayToHashMap(this.types);
        this.subTypesMapping = Maps.convertStringArrayToHashMap(this.subtypes);
        this.patternElementsMapping = Maps.convertStringArrayToHashMap(this.patternElements);
    }

    @Override
    protected boolean initialize(Configuration configuration) {
        Component.loggerMessage("Read flat pattern matcher resources from file");
        CompilationVariables comp = new CompilationVariables(configuration);
        this.setName(comp.name);
        try {
            Component.loggerMessage("Reading patterns from: " + comp.patternsFile);
            String[] entries = Files.FileToStringArray(comp.patternsFile, '#', comp.characterSet);
            Component.loggerMessage("Number of patterns: " + entries.length);
            Component.loggerMessage("Expanding the patterns");
            StringArrayList expandedEntries = this.expandEntries(entries, comp.whitespace_code);
            Component.loggerMessage("Number of patterns after expansion: " + expandedEntries.size());
            Component.loggerMessage("Encoding the patterns");
            StringArrayList encodedPatterns = this.encodePatterns(expandedEntries, comp.downcaseEntries);
            Component.loggerMessage("Convert the patterns into an automaton");
            this.patternMatcherAutomaton = this.constructAutomaton(encodedPatterns);
            Component.loggerMessage("Create internal data structures");
            this.createinitialiseDataStructures();
            Component.loggerMessage("Flat Pattern Information");
            Component.loggerMessage("Name: " + this.getName());
            Component.loggerMessage("Number of Patterns (after expansion): " + encodedPatterns.size());
            Component.loggerMessage("Number of Types: " + (this.types.length - 1));
            Component.loggerMessage("Number of SubTypes: " + (this.subtypes.length - 1));
            Component.loggerMessage("Number of Different Pattern Elements: " + (this.patternElements.length - 1));
            entries = null;
        }
        catch (Exception e) {
            Component.loggerMessage(className + e.toString() + e.getMessage());
            return false;
        }
        comp = null;
        return true;
    }

    @Override
    public boolean hasBeenInitialized() {
        if (this.types == null) {
            return false;
        }
        if (this.subtypes == null) {
            return false;
        }
        if (this.patternElements == null) {
            return false;
        }
        if (this.typesMapping == null) {
            return false;
        }
        if (this.subTypesMapping == null) {
            return false;
        }
        if (this.patternElementsMapping == null) {
            return false;
        }
        if (this.patternMatcherAutomaton == null) {
            return false;
        }
        return this.name != null;
    }

    @Override
    public void writeToStream(DataOutputStream d) throws IOException {
        DataStream.writeStringArray(d, this.types);
        DataStream.writeStringArray(d, this.subtypes);
        DataStream.writeStringArray(d, this.patternElements);
        this.patternMatcherAutomaton.writeToDataOutputStream(d);
        DataStream.writeString(d, this.getName());
    }

    @Override
    public void readFromStream(DataInputStream d) throws IOException {
        this.types = DataStream.readStringArray(d);
        this.subtypes = DataStream.readStringArray(d);
        this.patternElements = DataStream.readStringArray(d);
        this.createHashMaps();
        this.patternMatcherAutomaton = DictionaryLetterFSA.getInstance("BASIC");
        this.patternMatcherAutomaton.readFromDataInputStream(d);
        this.setName(DataStream.readString(d));
    }

    @Override
    public ArrayList<AbstractDisjunctionOfFlatPatternMatcherItems> findMatch(ArrayList<AbstractTokenItem> tokens, char[] inputText, TokenTagger tagger) {
        ArrayList<AbstractDisjunctionOfFlatPatternMatcherItems> result = new ArrayList<AbstractDisjunctionOfFlatPatternMatcherItems>(tokens.size() / 20);
        int numTokens = tokens.size();
        int startPos = 0;
        boolean longestMatch = this.getMatchStrategy().equals(MatchStrategy.LONGEST_MATCH);
        boolean allLongestMatch = this.getMatchStrategy().equals(MatchStrategy.ALL_LONGEST_MATCHES);
        MatchingData mData = new MatchingData(tagger, this);
        while (startPos < numTokens) {
            AbstractDisjunctionOfFlatPatternMatcherItems singleResult = this.findMatchesAtGivenPosition(inputText, tokens, longestMatch || allLongestMatch, startPos, tagger, mData);
            if (singleResult != null) {
                result.add(singleResult);
                startPos = longestMatch ? mData.lastToken + 1 : startPos + 1;
                continue;
            }
            ++startPos;
        }
        return result;
    }

    private AbstractDisjunctionOfFlatPatternMatcherItems findMatchesAtGivenPosition(char[] inputText, ArrayList<AbstractTokenItem> tokens, boolean longestMatch, int startPos, TokenTagger tagger, MatchingData mData) {
        if (inputText.length == 0) {
            return null;
        }
        int maxToken = tokens.size();
        mData.clear(startPos);
        mData.toBeInspectedStates.add(this.patternMatcherAutomaton.getInitialState());
        for (int currentToken = startPos; currentToken < maxToken && mData.toBeInspectedStates.size() > 0; ++currentToken) {
            AbstractTokenItem tok = tokens.get(currentToken);
            mData.codesToProcess.clear();
            if (tok.isWhiteSpace() && mData.whitespaceCode != UNDEFINED_TAG) {
                mData.codesToProcess.add(mData.whitespaceCode);
            } else {
                String nextSurfaceForm = String.copyValueOf(inputText, tok.getStart(), tok.getEnd() - tok.getStart() + 1);
                StringArrayList semClassOfNextToken = tagger.tagToken(nextSurfaceForm);
                Integer code = this.patternElementsMapping.get(this.isCaseSensitive() ? nextSurfaceForm : nextSurfaceForm.toLowerCase());
                if (code != null) {
                    mData.codesToProcess.add(code);
                }
                int len = semClassOfNextToken.size();
                for (int i = 0; i < len; ++i) {
                    code = this.patternElementsMapping.get(semClassOfNextToken.get(i));
                    if (code == null) continue;
                    mData.codesToProcess.add(code);
                }
            }
            int numCodes = mData.codesToProcess.size();
            for (DictionaryLetterFSA.State state : mData.toBeInspectedStates) {
                for (int i = 0; i < numCodes; ++i) {
                    StringArrayList labels;
                    DictionaryLetterFSA.Transition tempTransition = state.getTransitionLabelledWith((char)mData.codesToProcess.get(i));
                    if (tempTransition == null) continue;
                    DictionaryLetterFSA.State nextState = tempTransition.getTargetState();
                    mData.candidateStates.add(nextState);
                    DictionaryLetterFSA.Transition finalTransition = nextState.getTransitionLabelledWith((char)this.patternBoundaryMarker);
                    if (finalTransition == null) continue;
                    if (longestMatch && mData.lastToken < currentToken) {
                        mData.lastToken = currentToken;
                        mData.flatPatternMatcherTemporaryResults.clear();
                    }
                    if ((labels = DictionaryLetterFSATraversing.getPathLabels(finalTransition.getTargetState())) == null) continue;
                    int start = this.producesTokenPositions() ? startPos : tokens.get(startPos).getStart();
                    int end = this.producesTokenPositions() ? currentToken : tokens.get(currentToken).getEnd();
                    this.addFlatPatternMatcherResults(start, end, labels, mData.flatPatternMatcherTemporaryResults);
                }
            }
            mData.updateStateSets();
        }
        return mData.flatPatternMatcherTemporaryResults.size() == 0 ? null : new DisjunctionOfBasicFlatPatternMatcherItems(mData.flatPatternMatcherTemporaryResults);
    }

    private void addFlatPatternMatcherResults(int start, int end, StringArrayList labels, HashSet<BasicFlatPatternMatcherItem> flatPatternMatcherTemporaryResults) {
        int len = labels.size();
        for (int i = 0; i < len; ++i) {
            String label = labels.get(i);
            flatPatternMatcherTemporaryResults.add(new BasicFlatPatternMatcherItem(start, end, (byte)label.charAt(0), (byte)label.charAt(1)));
        }
    }

    private class MatchingData {
        HashSet<BasicFlatPatternMatcherItem> flatPatternMatcherTemporaryResults = new HashSet(100);
        IntArrayList codesToProcess = new IntArrayList(10);
        HashSet<DictionaryLetterFSA.State> toBeInspectedStates = new HashSet(100);
        HashSet<DictionaryLetterFSA.State> candidateStates = new HashSet(100);
        int lastToken = 0;
        int whitespaceCode;

        public MatchingData(TokenTagger tagger, BasicFlatPatternMatcher matcher) {
            Integer codeWhitespace = (Integer)matcher.patternElementsMapping.get(tagger.tagForWhiteSpaceToken());
            this.whitespaceCode = codeWhitespace != null ? codeWhitespace : UNDEFINED_TAG;
        }

        public void clear(int startToken) {
            this.flatPatternMatcherTemporaryResults.clear();
            this.codesToProcess.clear();
            this.toBeInspectedStates.clear();
            this.candidateStates.clear();
            this.lastToken = startToken;
        }

        void updateStateSets() {
            HashSet<DictionaryLetterFSA.State> tempStates = this.toBeInspectedStates;
            this.toBeInspectedStates = this.candidateStates;
            this.candidateStates = tempStates;
            this.candidateStates.clear();
        }
    }

    private class CompilationVariables {
        String characterSet;
        String patternsFile;
        boolean downcaseEntries;
        String name;
        String whitespace_code;

        CompilationVariables(Configuration configuration) {
            this.characterSet = configuration.getFeature(CompilationFeatures.CHARACTERSET.getName());
            this.patternsFile = configuration.getFeature(CompilationFeatures.PATTERN_FILE.getName());
            this.downcaseEntries = configuration.getFeature(CompilationFeatures.DOWNCASE_ENTRIES.getName()).compareTo("true") == 0;
            this.name = configuration.getFeature(CompilationFeatures.NAME.getName());
            this.whitespace_code = configuration.getFeature(CompilationFeatures.WHITESPACE_CODE.getName());
        }
    }

    private final class DisjunctionOfBasicFlatPatternMatcherItems
    extends AbstractDisjunctionOfFlatPatternMatcherItems {
        private final BasicFlatPatternMatcherItem[] myItems;

        @Override
        public int getNumberOfItems() {
            return this.myItems.length;
        }

        @Override
        public AbstractFlatPatternMatcherItem getItem(int i) {
            return i >= 0 && i < this.myItems.length ? this.myItems[i] : null;
        }

        private DisjunctionOfBasicFlatPatternMatcherItems() {
            this.myItems = null;
        }

        DisjunctionOfBasicFlatPatternMatcherItems(HashSet<BasicFlatPatternMatcherItem> items) {
            int len = items.size();
            this.myItems = new BasicFlatPatternMatcherItem[len];
            int i = 0;
            for (BasicFlatPatternMatcherItem it : items) {
                this.myItems[i++] = it;
            }
        }
    }

    private class BasicFlatPatternMatcherItem
    extends AbstractFlatPatternMatcherItem {
        private BasicFlatPatternMatcherItem() {
        }

        BasicFlatPatternMatcherItem(int start, int end, byte type, byte subtype) {
            super(start, end, type, subtype);
        }

        public boolean equals(Object other) {
            boolean result = false;
            if (other instanceof BasicFlatPatternMatcherItem) {
                BasicFlatPatternMatcherItem that = (BasicFlatPatternMatcherItem)other;
                result = this.getStart() == that.getStart() && this.getEnd() == that.getEnd() && this.getType() == that.getType() && this.getSubType() == that.getSubType();
            }
            return result;
        }

        public int hashCode() {
            return this.getStart() * this.getType() + this.getSubType();
        }

        @Override
        protected String getType(byte type) {
            if (type >= 0 && type < BasicFlatPatternMatcher.this.types.length) {
                return BasicFlatPatternMatcher.this.types[type];
            }
            return null;
        }

        @Override
        protected String getSubType(byte subtype) {
            if (subtype >= 0 && subtype < BasicFlatPatternMatcher.this.subtypes.length) {
                return BasicFlatPatternMatcher.this.subtypes[subtype];
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("[START: ");
            result.append(this.getStart());
            result.append(", END: ");
            result.append(this.getEnd());
            result.append(", TYPE: ");
            result.append(this.getTypeAsString());
            result.append(", SUBTYPE: ");
            result.append(this.getSubTypeAsString());
            result.append("]");
            return result.toString();
        }
    }

    private static final class DeploymentFeatures {
        static final ConfigurationFeature CHARACTER_SET = ConfigurationFeature.createFeature("CharacterSet", false, "UTF-8");
        static final ConfigurationFeature MATCH_STRATEGY = ConfigurationFeature.createFeature("MatchStrategy", false, "longest-match");
        static final ConfigurationFeature CASE_SENSITIVE = ConfigurationFeature.createFeature("CaseSensitive", false, "true");
        static final ConfigurationFeature OUTPUT_TOKEN_POSITIONS = ConfigurationFeature.createFeature("OutputTokenPositions", false, "false");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{CHARACTER_SET, MATCH_STRATEGY, CASE_SENSITIVE, OUTPUT_TOKEN_POSITIONS};

        private DeploymentFeatures() {
        }
    }

    private static final class CompilationFeatures {
        static final ConfigurationFeature NAME = ConfigurationFeature.createFeature("Name", true, "");
        static final ConfigurationFeature PATTERN_FILE = ConfigurationFeature.createFeature("EntryFile", true, "");
        static final ConfigurationFeature WHITESPACE_CODE = ConfigurationFeature.createFeature("WhitespaceCode", false, "");
        static final ConfigurationFeature DOWNCASE_ENTRIES = ConfigurationFeature.createFeature("DownCaseEntries", false, "false");
        static final ConfigurationFeature CHARACTERSET = ConfigurationFeature.createFeature("CharacterSet", false, "UTF-8");
        static final ConfigurationFeature[] FEATURES = new ConfigurationFeature[]{NAME, PATTERN_FILE, WHITESPACE_CODE, DOWNCASE_ENTRIES, CHARACTERSET};

        private CompilationFeatures() {
        }
    }
}

