/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.morphology;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.gazetteer.AbstractDisjunctionOfGazetteerItems;
import it.jrc.lt.core.component.gazetteer.AbstractGazetteer;
import it.jrc.lt.core.component.gazetteer.GazetteerException;
import it.jrc.lt.core.component.morphology.AbstractDisjunctionOfMorphologyItems;
import it.jrc.lt.core.component.morphology.AbstractMorphology;
import it.jrc.lt.core.component.morphology.AbstractMorphologyItem;
import it.jrc.lt.core.component.morphology.LanguageSpecificTreatment;
import it.jrc.lt.core.component.morphology.MultextMorphologyItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

final class EnglishSpecificTreatment
extends LanguageSpecificTreatment {
    AbstractMorphology morphology;
    private AbstractGazetteer mappingRules;
    private static String pseudo = "-";
    public static final byte APOSTROPHEE = 9;
    public static final byte WORD_WITH_HYPHEN_LOWERCASE = 24;
    public static final byte WORD_WITH_HYPHEN_UPERCASE = 25;

    protected EnglishSpecificTreatment(AbstractMorphology morphology) throws GazetteerException {
        this.morphology = morphology;
        this.prepareGazetteer();
    }

    @Override
    public boolean hasBeenInitialized() {
        if (this.morphology == null) {
            return false;
        }
        return this.mappingRules != null;
    }

    private String[] readPatterns() {
        ArrayList<String> entries = new ArrayList<String>();
        try {
            String line;
            Thread.currentThread().getContextClassLoader();
            URL pURL = ClassLoader.getSystemResource("resources/multext/EnglishSpecificTreatment.txt");
            if (pURL == null) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(pURL.openStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                entries.add(line);
            }
            in.close();
        }
        catch (IOException err) {
            return null;
        }
        String[] result = new String[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            result[i] = (String)entries.get(i);
        }
        return result;
    }

    private void prepareGazetteer() throws GazetteerException {
        String[] attributes = new String[]{"*TAG"};
        String[] entries = this.readPatterns();
        Configuration configuration = Configuration.getInstance();
        configuration.addFeature("CharacterSet", "UTF-8");
        configuration.addFeature("InputSeparator", "|");
        configuration.addFeature("AttributeValueSeparator", ":");
        if (entries != null) {
            this.mappingRules = AbstractGazetteer.createInstance("basicGazetteer");
            this.mappingRules.createFrom(attributes, entries, configuration);
        }
    }

    @Override
    int process(ArrayList<AbstractDisjunctionOfMorphologyItems> returnResult, ArrayList<AbstractTokenItem> tokens, int position, char[] inputText) {
        AbstractTokenItem currentToken = tokens.get(position);
        char[] currentWord = currentToken.toCharArray(inputText);
        returnResult.clear();
        switch (currentToken.getType()) {
            case 9: {
                String newWord;
                AbstractDisjunctionOfMorphologyItems morphInfo;
                String candidate;
                AbstractDisjunctionOfGazetteerItems gazInfo;
                if (position <= 0 || position + 1 >= tokens.size()) break;
                AbstractTokenItem nextToken = tokens.get(position + 1);
                AbstractTokenItem prevToken = tokens.get(position - 1);
                if (currentToken.getEnd() + 1 != nextToken.getStart() || currentToken.getStart() != prevToken.getEnd() + 1 || (gazInfo = this.mappingRules.lookUp((candidate = new String(inputText, prevToken.getStart(), nextToken.getEnd() - prevToken.getStart() + 1)).toLowerCase())) == null || gazInfo.getNumberOfItems() <= 0 || gazInfo.getItem(0).getValue(0).compareTo("CX") != 0 || (morphInfo = this.morphology.search((newWord = new String(inputText, currentToken.getStart(), nextToken.getEnd() - currentToken.getStart() + 1)).toCharArray())) == null) break;
                int start = currentToken.getStart();
                int end = nextToken.getEnd();
                int len = morphInfo.getNumberOfItems();
                ArrayList<AbstractMorphologyItem> newItems = new ArrayList<AbstractMorphologyItem>();
                for (int i = 0; i < len; ++i) {
                    AbstractMorphologyItem item = morphInfo.getItem(i);
                    newItems.add(new MultextMorphologyItem(start, end, item.getPos(), item.getLemma(), item.getTags()));
                }
                returnResult.add(new AbstractDisjunctionOfMorphologyItems(newItems));
                return position + 1;
            }
            case 24: 
            case 25: {
                StringTokenizer strTokenizer = new StringTokenizer(new String(currentWord), "-", false);
                StringBuffer pattern = new StringBuffer();
                while (strTokenizer.hasMoreTokens()) {
                    String next = strTokenizer.nextToken();
                    String downcased = next.toLowerCase();
                    String nextPos = this.morphology.getPartOfSpeech(next);
                    String downcasedPos = this.morphology.getPartOfSpeech(downcased);
                    if (nextPos != null || downcasedPos != null) {
                        pattern.append(nextPos != null ? nextPos : downcasedPos);
                    } else {
                        pattern.append("U");
                    }
                    if (!strTokenizer.hasMoreTokens()) continue;
                    pattern.append("-");
                }
                AbstractDisjunctionOfGazetteerItems gazInfo = this.mappingRules.lookUp(pattern.toString());
                if (gazInfo == null || gazInfo.getNumberOfItems() <= 0) break;
                String pos = gazInfo.getItem(0).getValue(0);
                int len = pos.length();
                int start = currentToken.getStart();
                int end = currentToken.getEnd();
                ArrayList<AbstractMorphologyItem> newItems = new ArrayList<AbstractMorphologyItem>();
                for (int i = 0; i < len; ++i) {
                    newItems.add(new MultextMorphologyItem(start, end, pos.charAt(i), pseudo, pseudo));
                }
                returnResult.add(new AbstractDisjunctionOfMorphologyItems(newItems));
                return position;
            }
        }
        return position;
    }
}

