/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.core.component.tokenizer;

import it.jrc.lt.core.component.Component;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.BasicTokenizer;
import it.jrc.lt.core.component.tokenizer.ClassifyingTokenizer;
import java.util.ArrayList;
import java.util.Map;

public abstract class AbstractTokenizer
extends Component {
    private boolean whitespaceTokens;

    protected AbstractTokenizer() {
        this.ignoreWhitespaceTokens();
    }

    public static AbstractTokenizer createInstance(String type) {
        if (type == null) {
            return null;
        }
        if (type.compareTo("basicTokenizer") == 0) {
            return new BasicTokenizer();
        }
        if (type.compareTo("classifyingTokenizer") == 0) {
            return new ClassifyingTokenizer();
        }
        return null;
    }

    public void produceWhitespaceTokens() {
        this.whitespaceTokens = true;
    }

    public void ignoreWhitespaceTokens() {
        this.whitespaceTokens = false;
    }

    public boolean producesWhitespaceTokens() {
        return this.whitespaceTokens;
    }

    public ArrayList<AbstractTokenItem> tokenize(String inputText) {
        return this.tokenize(inputText.toCharArray());
    }

    public abstract ArrayList<AbstractTokenItem> tokenize(char[] var1);

    public abstract Map<Byte, String> getTypeNames();
}

