/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSA;
import piskorski.fs.letterfs.fsa.LetterFSAInterface;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.CharacterArrayList;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.functions.Files;

public class DictionaryLetterFSA_Impl_TransMatrix
extends DictionaryLetterFSA {
    private int numTransitions;
    private int numStates;
    private char[] alphabet;
    private boolean[] isFinal;
    private int[][] transMatrix;
    private int initialState;
    private int[] symbolIndex;
    private static final int UNDEFINED_SYMBOL = -1;

    @Override
    public int getNumberOfTransitions() {
        return this.numTransitions;
    }

    @Override
    public int getNumberOfStates() {
        return this.numStates;
    }

    @Override
    public CharacterArrayList getAlphabet() {
        CharacterArrayList result = new CharacterArrayList();
        for (int i = 0; i < this.alphabet.length; ++i) {
            result.add(this.alphabet[i]);
        }
        return result;
    }

    @Override
    public DictionaryLetterFSA.State getInitialState() {
        return new State(this.initialState);
    }

    @Override
    public void initializeFrom(LetterFSAInterface A) {
        int i;
        int i2;
        this.numStates = A.getNumberOfStates();
        this.numTransitions = A.getNumberOfTransitions();
        CharacterArrayList alphabet = A.getAlphabet();
        int len = alphabet.size();
        this.alphabet = new char[len];
        for (i2 = 0; i2 < len; ++i2) {
            this.alphabet[i2] = alphabet.get(i2);
        }
        this.isFinal = new boolean[this.numStates];
        Arrays.fill(this.isFinal, false);
        this.transMatrix = new int[this.numStates][];
        for (i2 = 0; i2 < this.numStates; ++i2) {
            this.transMatrix[i2] = new int[this.alphabet.length];
            Arrays.fill(this.transMatrix[i2], -1);
        }
        HashMap<Integer, Integer> stateID = new HashMap<Integer, Integer>();
        IntArrayList states = A.getStates();
        len = states.size();
        for (i = 0; i < len; ++i) {
            int nextState = states.get(i);
            stateID.put(new Integer(nextState), new Integer(i));
            if (!A.isFinalState(nextState)) continue;
            this.isFinal[i] = true;
        }
        this.initialState = (Integer)stateID.get(new Integer(A.getInitialState()));
        this.symbolIndex = new int[65536];
        Arrays.fill(this.symbolIndex, -1);
        len = this.alphabet.length;
        for (i = 0; i < len; ++i) {
            this.symbolIndex[this.alphabet[i]] = i;
        }
        this.numStates = states.size();
        for (int i3 = 0; i3 < this.numStates; ++i3) {
            int nextState = states.get(i3);
            int nextStateID = (Integer)stateID.get(new Integer(nextState));
            TransitionArrayList transitions = A.getTransitions(nextState);
            int numTransitions = transitions.size();
            for (int j = 0; j < numTransitions; ++j) {
                int nextTarget = transitions.getTarget(j);
                int nextTargetID = (Integer)stateID.get(new Integer(nextTarget));
                char nextLabel = transitions.getSymbol(j);
                int nextLabelID = this.symbolIndex[nextLabel];
                this.transMatrix[nextStateID][nextLabelID] = nextTargetID;
            }
        }
    }

    @Override
    public boolean saveToFile(String file) {
        byte[] fill = null;
        boolean status = true;
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(byteOS);
            status = this.writeToDataOutputStream(d);
            d.close();
            byteOS.close();
            if (status) {
                fill = byteOS.toByteArray();
            }
        }
        catch (IOException e) {
            return false;
        }
        if (status) {
            status = Files.writeByteArrayToFile(fill, file);
        }
        fill = null;
        return status;
    }

    @Override
    public boolean readFromFile(String file) {
        byte[] randomAccess = null;
        File FileName = new File(file);
        int size = (int)FileName.length();
        randomAccess = new byte[size];
        boolean status = Files.readByteArrayFromFile(randomAccess, file);
        if (!status) {
            return false;
        }
        try {
            ByteArrayInputStream byteIS = new ByteArrayInputStream(randomAccess);
            DataInputStream d = new DataInputStream(byteIS);
            this.readFromDataInputStream(d);
            d.close();
            byteIS.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean writeToDataOutputStream(DataOutputStream d) throws IOException {
        int i;
        d.writeInt(this.numTransitions);
        d.writeInt(this.numStates);
        d.writeInt(this.initialState);
        int len = this.alphabet.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeChar(this.alphabet[i]);
        }
        len = this.symbolIndex.length;
        d.writeInt(len);
        for (i = 0; i < len; ++i) {
            d.writeInt(this.symbolIndex[i]);
        }
        len = this.numStates;
        for (i = 0; i < len; ++i) {
            d.writeBoolean(this.isFinal[i]);
        }
        int alphLen = this.alphabet.length;
        for (int i2 = 0; i2 < len; ++i2) {
            for (int j = 0; j < alphLen; ++j) {
                d.writeInt(this.transMatrix[i2][j]);
            }
        }
        return true;
    }

    @Override
    public boolean readFromDataInputStream(DataInputStream d) throws IOException {
        int i;
        this.numTransitions = d.readInt();
        this.numStates = d.readInt();
        this.initialState = d.readInt();
        int len = d.readInt();
        this.alphabet = new char[len];
        for (i = 0; i < len; ++i) {
            this.alphabet[i] = d.readChar();
        }
        len = d.readInt();
        this.symbolIndex = new int[len];
        for (i = 0; i < len; ++i) {
            this.symbolIndex[i] = d.readInt();
        }
        this.isFinal = new boolean[this.numStates];
        for (i = 0; i < this.isFinal.length; ++i) {
            this.isFinal[i] = d.readBoolean();
        }
        this.transMatrix = new int[this.numStates][];
        len = this.numStates;
        int alphLen = this.alphabet.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.transMatrix[i2] = new int[alphLen];
            for (int j = 0; j < alphLen; ++j) {
                this.transMatrix[i2][j] = d.readInt();
            }
        }
        return true;
    }

    @Override
    public boolean writeToByteBuffer(ByteBuffer b) {
        return false;
    }

    @Override
    public boolean readFromByteBuffer(ByteBuffer b) {
        return false;
    }

    private final class Transition
    implements DictionaryLetterFSA.Transition {
        private int state;
        private int index;

        @Override
        public DictionaryLetterFSA.State getTargetState() {
            return new State(DictionaryLetterFSA_Impl_TransMatrix.this.transMatrix[this.state][this.index]);
        }

        public Transition(int state, int index) {
            this.state = state;
            this.index = index;
        }

        @Override
        public char getLabel() {
            return DictionaryLetterFSA_Impl_TransMatrix.this.alphabet[this.index];
        }

        @Override
        public boolean pointsToFinalState() {
            return DictionaryLetterFSA_Impl_TransMatrix.this.isFinal[DictionaryLetterFSA_Impl_TransMatrix.this.transMatrix[this.state][this.index]];
        }
    }

    private final class State
    implements DictionaryLetterFSA.State {
        private int state;
        private static final int UNDEFINED = -1;

        @Override
        public DictionaryLetterFSA.Transition getFirstTransition() {
            int len = DictionaryLetterFSA_Impl_TransMatrix.this.alphabet.length;
            for (int i = 0; i < len; ++i) {
                if (DictionaryLetterFSA_Impl_TransMatrix.this.transMatrix[this.state][i] == -1) continue;
                return new Transition(this.state, i);
            }
            return null;
        }

        public State(int state) {
            this.state = state;
        }

        @Override
        public DictionaryLetterFSA.Transition getNextTransition(DictionaryLetterFSA.Transition transition) {
            Transition myTransition = (Transition)transition;
            int len = DictionaryLetterFSA_Impl_TransMatrix.this.alphabet.length;
            for (int count = myTransition.index + 1; count < len; ++count) {
                if (DictionaryLetterFSA_Impl_TransMatrix.this.transMatrix[this.state][count] == -1) continue;
                return new Transition(this.state, count);
            }
            return null;
        }

        @Override
        public DictionaryLetterFSA.Transition getTransitionLabelledWith(char label) {
            if (DictionaryLetterFSA_Impl_TransMatrix.this.symbolIndex[label] == -1) {
                return null;
            }
            if (DictionaryLetterFSA_Impl_TransMatrix.this.transMatrix[this.state][DictionaryLetterFSA_Impl_TransMatrix.this.symbolIndex[label]] != -1) {
                return new Transition(this.state, DictionaryLetterFSA_Impl_TransMatrix.this.symbolIndex[label]);
            }
            return null;
        }

        public boolean equals(Object s) {
            return this.state == ((State)s).state;
        }
    }
}

