/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import piskorski.fs.letterfs.fsa.DictionaryLetterFSAImpl_1;
import piskorski.fs.letterfs.fsa.DynamicLetterMarkedTravFSAInterface;
import piskorski.fs.letterfs.fsa.DynamicLetterMarkedTravFSA_Impl;
import piskorski.fs.letterfs.fsa.FiniteStateProcessingException;
import piskorski.fs.letterfs.fsa.LetterDynamicFSA;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.functions.Files;
import piskorski.util.functions.Memory;
import piskorski.util.set.SimpleIntSet;
import piskorski.util.strings.StringFunctions;

public class FiniteStateAlgorithms {
    private static int maxNumberOfStates;
    private static int maxNumberOfSymbols;
    private static int numBitsForSymbols;
    private static int numBitsForStates;
    private static char[] Alphabet;
    private static int[] SymbolToIndexInAlphabet;
    private static int[] numIntsForTrans;
    private static final int ALL0 = 0;
    private static final int ALL1 = -1;
    private static int CnumBitsForStates;
    private static int CnumBitsForSymbols;
    private static int MAX_CHAR;

    private static void exceptionMessage(String Message) throws FiniteStateProcessingException {
        System.out.println(Message);
        throw new FiniteStateProcessingException(Message);
    }

    public static LetterDynamicFSA MinDetAutomatonFromListOfWords(String fileName, String inputCharacterSet, boolean withPathCompression, int repetition, int minNumPaths, boolean reversePaths) throws FiniteStateProcessingException {
        String[] data;
        try {
            data = Files.FileToStringArray(fileName, inputCharacterSet);
        }
        catch (Exception e) {
            throw new FiniteStateProcessingException("Could not read from file: " + fileName);
        }
        return FiniteStateAlgorithms.MinDetAutomatonFromListOfWords(data, withPathCompression, repetition, minNumPaths, reversePaths);
    }

    public static DynamicLetterMarkedTravFSAInterface MinDetAutomatonFromListOfWordsX(String fileName, String inputCharacterSet, boolean withPathCompression, int repetition, int minNumPaths, boolean reversePaths) throws FiniteStateProcessingException {
        String[] data;
        try {
            data = Files.FileToStringArray(fileName, inputCharacterSet);
        }
        catch (Exception e) {
            throw new FiniteStateProcessingException("Could not read from file: " + fileName);
        }
        return FiniteStateAlgorithms.MinDetAutomatonFromListOfWordsX(data, withPathCompression, repetition, minNumPaths, reversePaths);
    }

    private static String transitionListToString(boolean isFinal, TransitionArrayList transitions) {
        StringBuffer Result = new StringBuffer();
        if (isFinal) {
            Result.append('1');
        } else {
            Result.append('0');
        }
        if (transitions != null) {
            int len = transitions.size();
            for (int i = 0; i < len; ++i) {
                Result.append(transitions.getSymbol(i));
                Result.append('$');
                Result.append(transitions.getTarget(i));
                Result.append('$');
            }
        }
        return Result.toString();
    }

    private static SimpleIntSet transitionListToSimpleIntArrayList(boolean isFinal, TransitionArrayList transitions) {
        SimpleIntSet Result = new SimpleIntSet();
        int transSize = transitions.size();
        int[] a = new int[numIntsForTrans[transSize]];
        a[0] = isFinal ? 3 : 1;
        int currentInt = 0;
        int currentBit = 2;
        for (int currentTransition = 0; currentTransition < transSize; ++currentTransition) {
            int now;
            int nextChar;
            if (numBitsForSymbols + currentBit <= 32) {
                int n = currentInt++;
                a[n] = a[n] | SymbolToIndexInAlphabet[transitions.getSymbol(currentTransition)] << currentBit;
                if ((currentBit += numBitsForSymbols) >= 32) {
                    currentBit = 0;
                }
            } else {
                nextChar = SymbolToIndexInAlphabet[transitions.getSymbol(currentTransition)];
                now = 32 - currentBit;
                int n = currentInt++;
                a[n] = a[n] | (~(-1 << now) & nextChar) << currentBit;
                a[currentInt] = nextChar >>> now;
                currentBit += CnumBitsForSymbols;
            }
            if (numBitsForStates + currentBit <= 32) {
                int n = currentInt++;
                a[n] = a[n] | transitions.getTarget(currentTransition) << currentBit;
                if ((currentBit += numBitsForStates) < 32) continue;
                currentBit = 0;
                continue;
            }
            nextChar = transitions.getTarget(currentTransition);
            now = 32 - currentBit;
            int n = currentInt++;
            a[n] = a[n] | (~(-1 << now) & nextChar) << currentBit;
            a[currentInt] = nextChar >>> now;
            currentBit += CnumBitsForStates;
        }
        Result.set(a);
        return Result;
    }

    private static void transitionListToSimpleIntArrayList(SimpleIntSet set, boolean isFinal, TransitionArrayList transitions) {
        set.clear();
        int transSize = transitions.size();
        int[] a = new int[numIntsForTrans[transSize]];
        a[0] = isFinal ? 3 : 1;
        int currentInt = 0;
        int currentBit = 2;
        for (int currentTransition = 0; currentTransition < transSize; ++currentTransition) {
            int now;
            int nextChar;
            if (numBitsForSymbols + currentBit <= 32) {
                int n = currentInt++;
                a[n] = a[n] | SymbolToIndexInAlphabet[transitions.getSymbol(currentTransition)] << currentBit;
                if ((currentBit += numBitsForSymbols) >= 32) {
                    currentBit = 0;
                }
            } else {
                nextChar = SymbolToIndexInAlphabet[transitions.getSymbol(currentTransition)];
                now = 32 - currentBit;
                int n = currentInt++;
                a[n] = a[n] | (~(-1 << now) & nextChar) << currentBit;
                a[currentInt] = nextChar >>> now;
                currentBit += CnumBitsForSymbols;
            }
            if (numBitsForStates + currentBit <= 32) {
                int n = currentInt++;
                a[n] = a[n] | transitions.getTarget(currentTransition) << currentBit;
                if ((currentBit += numBitsForStates) < 32) continue;
                currentBit = 0;
                continue;
            }
            nextChar = transitions.getTarget(currentTransition);
            now = 32 - currentBit;
            int n = currentInt++;
            a[n] = a[n] | (~(-1 << now) & nextChar) << currentBit;
            a[currentInt] = nextChar >>> now;
            currentBit += CnumBitsForStates;
        }
        set.set(a);
    }

    public static DynamicLetterMarkedTravFSAInterface MinDetAutomatonFromListOfWordsX(String[] data, boolean withPathCompression, int repetition, int minNumPaths, boolean reversePaths) {
        Integer newRegisteredState;
        Integer newTarget;
        int currentChild;
        int currentParent;
        int k;
        Integer child;
        int i;
        int numberOfEntries = data.length;
        Arrays.sort(data);
        boolean[] charCheck = new boolean[MAX_CHAR];
        Arrays.fill(charCheck, false);
        maxNumberOfStates = 0;
        for (i = 0; i < numberOfEntries; ++i) {
            int len = data[i].length();
            maxNumberOfStates = maxNumberOfStates + len + 1;
            for (int j = 0; j < len; ++j) {
                charCheck[data[i].charAt((int)j)] = true;
            }
        }
        maxNumberOfSymbols = 0;
        for (i = 0; i < MAX_CHAR; ++i) {
            if (!charCheck[i]) continue;
            ++maxNumberOfSymbols;
        }
        Alphabet = new char[maxNumberOfSymbols];
        SymbolToIndexInAlphabet = new int[MAX_CHAR];
        int count = 0;
        for (i = 0; i < MAX_CHAR; ++i) {
            if (charCheck[i]) {
                FiniteStateAlgorithms.Alphabet[count] = (char)i;
                FiniteStateAlgorithms.SymbolToIndexInAlphabet[i] = count++;
                continue;
            }
            FiniteStateAlgorithms.SymbolToIndexInAlphabet[i] = -1;
        }
        numBitsForStates = Memory.howManyBits(maxNumberOfStates);
        numBitsForSymbols = Memory.howManyBits(maxNumberOfSymbols += repetition);
        CnumBitsForStates = numBitsForStates - 32;
        CnumBitsForSymbols = numBitsForSymbols - 32;
        numIntsForTrans = new int[maxNumberOfSymbols + 1];
        for (i = 0; i < maxNumberOfSymbols + 1; ++i) {
            FiniteStateAlgorithms.numIntsForTrans[i] = (2 + i * (numBitsForStates + numBitsForSymbols)) / 32;
            int rest = (2 + i * (numBitsForStates + numBitsForSymbols)) % 32;
            if (rest == 0) continue;
            int n = i;
            numIntsForTrans[n] = numIntsForTrans[n] + 1;
        }
        DynamicLetterMarkedTravFSA_Impl A = new DynamicLetterMarkedTravFSA_Impl(numberOfEntries * 3, numberOfEntries);
        HashMap<Integer, Integer> lastStateMap = new HashMap<Integer, Integer>();
        HashMap<SimpleIntSet, Integer> register = new HashMap<SimpleIntSet, Integer>(200000, 0.75f);
        IntArrayList lastChildChain = new IntArrayList();
        char last = (char)(data[numberOfEntries - 1].charAt(0) + '\u0001');
        for (i = 0; i < numberOfEntries; ++i) {
            IntArrayList newStates;
            int prefixLength = A.longestPrefix(data[i]);
            int lastState = A.delta(data[i], prefixLength, 0);
            if (prefixLength >= data[i].length()) continue;
            if (A.hasTransitions(lastState)) {
                lastChildChain.clear();
                lastChildChain.add(lastState);
                child = (Integer)lastStateMap.get(new Integer(lastState));
                while (child != null) {
                    lastChildChain.add(child);
                    child = (Integer)lastStateMap.get(child);
                }
                for (k = lastChildChain.size() - 1; k >= 1; --k) {
                    currentParent = lastChildChain.get(k - 1);
                    currentChild = lastChildChain.get(k);
                    SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
                    if (register.containsKey(currentChildEncoding)) {
                        newTarget = (Integer)register.get(currentChildEncoding);
                        A.modifyTargetInFirstTransition(currentParent, currentChild, newTarget);
                        lastStateMap.put(new Integer(currentParent), newTarget);
                        A.removeState(currentChild);
                        lastStateMap.remove(new Integer(currentChild));
                        continue;
                    }
                    newRegisteredState = new Integer(currentChild);
                    register.put(currentChildEncoding, newRegisteredState);
                    lastStateMap.remove(newRegisteredState);
                }
            }
            if ((newStates = A.addWordReturnNewStates(lastState, data[i], prefixLength)).size() <= 0) continue;
            Integer nextState = new Integer(newStates.get(0));
            lastStateMap.put(new Integer(lastState), nextState);
            int len = newStates.size() - 1;
            for (int j = 0; j < len; ++j) {
                Integer oldState = nextState;
                nextState = new Integer(newStates.get(j + 1));
                lastStateMap.put(oldState, nextState);
            }
        }
        lastChildChain.clear();
        lastChildChain.add(0);
        child = (Integer)lastStateMap.get(new Integer(0));
        while (child != null) {
            lastChildChain.add(child);
            child = (Integer)lastStateMap.get(child);
        }
        for (k = lastChildChain.size() - 1; k >= 1; --k) {
            currentParent = lastChildChain.get(k - 1);
            currentChild = lastChildChain.get(k);
            SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
            if (register.containsKey(currentChildEncoding)) {
                newTarget = (Integer)register.get(currentChildEncoding);
                A.modifyTargetInFirstTransition(currentParent, currentChild, newTarget);
                lastStateMap.put(new Integer(currentParent), newTarget);
                A.removeState(currentChild);
                lastStateMap.remove(new Integer(currentChild));
                continue;
            }
            newRegisteredState = new Integer(currentChild);
            register.put(currentChildEncoding, newRegisteredState);
            lastStateMap.remove(newRegisteredState);
        }
        return A;
    }

    public static DynamicLetterMarkedTravFSAInterface MinDetAutomatonFromSortedListOfStringsInFile(String fileName, String inputCharset, int blockSize, char separator, boolean withPathCompression, int repetition, int minNumPaths, boolean reversePaths) throws IOException {
        int currentChild;
        int currentParent;
        Integer child;
        int i;
        boolean[] charCheck = new boolean[MAX_CHAR];
        Arrays.fill(charCheck, false);
        maxNumberOfStates = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), inputCharset), blockSize);
        in.mark(1);
        int FirstSymbol = in.read();
        if (FirstSymbol != 65279) {
            in.reset();
        }
        StringArrayList stringBlock = new StringArrayList(blockSize);
        block0: while (true) {
            stringBlock.clear();
            Files.readMarkedStringsFromBuffer(stringBlock, in, blockSize, separator);
            int stringBlockSize = stringBlock.size();
            if (stringBlockSize == 0) break;
            i = 0;
            while (true) {
                if (i >= stringBlockSize) continue block0;
                String next = stringBlock.get(i);
                int len = next.length();
                maxNumberOfStates = maxNumberOfStates + len + 1;
                for (int j = 0; j < len; ++j) {
                    charCheck[next.charAt((int)j)] = true;
                }
                ++i;
            }
            break;
        }
        in.close();
        maxNumberOfSymbols = 0;
        for (i = 0; i < MAX_CHAR; ++i) {
            if (!charCheck[i]) continue;
            ++maxNumberOfSymbols;
        }
        Alphabet = new char[maxNumberOfSymbols];
        SymbolToIndexInAlphabet = new int[MAX_CHAR];
        int count = 0;
        for (i = 0; i < MAX_CHAR; ++i) {
            if (charCheck[i]) {
                FiniteStateAlgorithms.Alphabet[count] = (char)i;
                FiniteStateAlgorithms.SymbolToIndexInAlphabet[i] = count++;
                continue;
            }
            FiniteStateAlgorithms.SymbolToIndexInAlphabet[i] = -1;
        }
        numBitsForStates = Memory.howManyBits(maxNumberOfStates);
        numBitsForSymbols = Memory.howManyBits(maxNumberOfSymbols += repetition);
        CnumBitsForStates = numBitsForStates - 32;
        CnumBitsForSymbols = numBitsForSymbols - 32;
        numIntsForTrans = new int[maxNumberOfSymbols + 1];
        for (i = 0; i < maxNumberOfSymbols + 1; ++i) {
            FiniteStateAlgorithms.numIntsForTrans[i] = (2 + i * (numBitsForStates + numBitsForSymbols)) / 32;
            int rest = (2 + i * (numBitsForStates + numBitsForSymbols)) % 32;
            if (rest == 0) continue;
            int n = i;
            numIntsForTrans[n] = numIntsForTrans[n] + 1;
        }
        DynamicLetterMarkedTravFSA_Impl A = new DynamicLetterMarkedTravFSA_Impl(100000, 100000);
        HashMap<Integer, Integer> lastStateMap = new HashMap<Integer, Integer>();
        HashMap<SimpleIntSet, Integer> register = new HashMap<SimpleIntSet, Integer>(maxNumberOfStates / 3, 0.75f);
        IntArrayList lastChildChain = new IntArrayList();
        in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), inputCharset), blockSize);
        in.mark(1);
        FirstSymbol = in.read();
        if (FirstSymbol != 65279) {
            in.reset();
        }
        stringBlock.clear();
        int cc = 0;
        while (true) {
            stringBlock.clear();
            Files.readMarkedStringsFromBufferWithoutSeparators(stringBlock, in, blockSize, separator);
            int stringBlockSize = stringBlock.size();
            if (stringBlockSize == 0) break;
            for (i = 0; i < stringBlockSize; ++i) {
                IntArrayList newStates;
                String nextString = stringBlock.get(i);
                int prefixLength = A.longestPrefix(nextString);
                int lastState = A.delta(nextString, prefixLength, 0);
                if (prefixLength >= nextString.length()) continue;
                if (A.hasTransitions(lastState)) {
                    lastChildChain.clear();
                    lastChildChain.add(lastState);
                    child = (Integer)lastStateMap.get(new Integer(lastState));
                    while (child != null) {
                        lastChildChain.add(child);
                        child = (Integer)lastStateMap.get(child);
                    }
                    for (int k = lastChildChain.size() - 1; k >= 1; --k) {
                        currentParent = lastChildChain.get(k - 1);
                        currentChild = lastChildChain.get(k);
                        SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
                        if (register.containsKey(currentChildEncoding)) {
                            Integer newTarget = (Integer)register.get(currentChildEncoding);
                            A.modifyTargetInFirstTransition(currentParent, currentChild, newTarget);
                            lastStateMap.put(new Integer(currentParent), newTarget);
                            A.removeState(currentChild);
                            lastStateMap.remove(new Integer(currentChild));
                            continue;
                        }
                        Integer newRegisteredState = new Integer(currentChild);
                        register.put(currentChildEncoding, newRegisteredState);
                        lastStateMap.remove(newRegisteredState);
                    }
                }
                if ((newStates = A.addWordReturnNewStates(lastState, nextString, prefixLength)).size() <= 0) continue;
                Integer nextState = new Integer(newStates.get(0));
                lastStateMap.put(new Integer(lastState), nextState);
                int len = newStates.size() - 1;
                for (int j = 0; j < len; ++j) {
                    Integer oldState = nextState;
                    nextState = new Integer(newStates.get(j + 1));
                    lastStateMap.put(oldState, nextState);
                }
            }
            ++cc;
        }
        in.close();
        lastChildChain.clear();
        lastChildChain.add(0);
        child = (Integer)lastStateMap.get(new Integer(0));
        while (child != null) {
            lastChildChain.add(child);
            child = (Integer)lastStateMap.get(child);
        }
        for (int k = lastChildChain.size() - 1; k >= 1; --k) {
            currentParent = lastChildChain.get(k - 1);
            currentChild = lastChildChain.get(k);
            SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
            if (register.containsKey(currentChildEncoding)) {
                Integer newTarget = (Integer)register.get(currentChildEncoding);
                A.modifyTargetInFirstTransition(currentParent, currentChild, newTarget);
                lastStateMap.put(new Integer(currentParent), newTarget);
                A.removeState(currentChild);
                lastStateMap.remove(new Integer(currentChild));
                continue;
            }
            Integer newRegisteredState = new Integer(currentChild);
            register.put(currentChildEncoding, newRegisteredState);
            lastStateMap.remove(newRegisteredState);
        }
        return A;
    }

    public static LetterDynamicFSA MinDetAutomatonFromListOfWords(String[] data, boolean withPathCompression, int repetition, int minNumPaths, boolean reversePaths) {
        Integer oldState;
        Integer nextState;
        IntArrayList newStates;
        Integer newRegisteredState;
        Integer newTarget;
        int currentChild;
        int currentParent;
        int k;
        Integer child;
        int lastState;
        int prefixLength;
        int i;
        int numberOfEntries = data.length;
        Arrays.sort(data);
        boolean[] charCheck = new boolean[MAX_CHAR];
        Arrays.fill(charCheck, false);
        maxNumberOfStates = 0;
        for (i = 0; i < numberOfEntries; ++i) {
            int len = data[i].length();
            maxNumberOfStates = maxNumberOfStates + len + 1;
            for (int j = 0; j < len; ++j) {
                charCheck[data[i].charAt((int)j)] = true;
            }
        }
        maxNumberOfSymbols = 0;
        for (i = 0; i < MAX_CHAR; ++i) {
            if (!charCheck[i]) continue;
            ++maxNumberOfSymbols;
        }
        Alphabet = new char[maxNumberOfSymbols];
        SymbolToIndexInAlphabet = new int[MAX_CHAR];
        int count = 0;
        for (i = 0; i < MAX_CHAR; ++i) {
            if (charCheck[i]) {
                FiniteStateAlgorithms.Alphabet[count] = (char)i;
                FiniteStateAlgorithms.SymbolToIndexInAlphabet[i] = count++;
                continue;
            }
            FiniteStateAlgorithms.SymbolToIndexInAlphabet[i] = -1;
        }
        System.out.println("NumberofSymbols: " + maxNumberOfSymbols);
        numBitsForStates = Memory.howManyBits(maxNumberOfStates);
        numBitsForSymbols = Memory.howManyBits(maxNumberOfSymbols += repetition);
        System.out.println("NumberofBitsForAlphabet: " + Memory.howManyBits(maxNumberOfSymbols));
        System.out.println("NumberofBitsForStates: " + Memory.howManyBits(maxNumberOfStates));
        CnumBitsForStates = numBitsForStates - 32;
        CnumBitsForSymbols = numBitsForSymbols - 32;
        numIntsForTrans = new int[maxNumberOfSymbols + 1];
        for (i = 0; i < maxNumberOfSymbols + 1; ++i) {
            FiniteStateAlgorithms.numIntsForTrans[i] = (2 + i * (numBitsForStates + numBitsForSymbols)) / 32;
            int rest = (2 + i * (numBitsForStates + numBitsForSymbols)) % 32;
            if (rest == 0) continue;
            int n = i;
            numIntsForTrans[n] = numIntsForTrans[n] + 1;
        }
        LetterDynamicFSA A = new LetterDynamicFSA(100000, 100000, true);
        HashMap<Integer, Integer> lastStateMap = new HashMap<Integer, Integer>();
        HashMap<SimpleIntSet, Integer> register = new HashMap<SimpleIntSet, Integer>(100000, 0.75f);
        IntArrayList lastChildChain = new IntArrayList();
        char last = (char)(data[numberOfEntries - 1].charAt(0) + '\u0001');
        System.out.println("Start Insertion");
        for (i = 0; i < numberOfEntries; ++i) {
            prefixLength = A.longestPrefix(data[i]);
            lastState = A.delta(data[i], prefixLength);
            if (prefixLength >= data[i].length()) continue;
            if (A.hasChildren(lastState)) {
                lastChildChain.clear();
                lastChildChain.add(lastState);
                child = (Integer)lastStateMap.get(new Integer(lastState));
                while (child != null) {
                    lastChildChain.add(child);
                    child = (Integer)lastStateMap.get(child);
                }
                for (k = lastChildChain.size() - 1; k >= 1; --k) {
                    currentParent = lastChildChain.get(k - 1);
                    currentChild = lastChildChain.get(k);
                    SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
                    if (register.containsKey(currentChildEncoding)) {
                        newTarget = (Integer)register.get(currentChildEncoding);
                        A.replaceTarget(currentParent, currentChild, newTarget);
                        lastStateMap.put(new Integer(currentParent), newTarget);
                        A.removeState(currentChild);
                        lastStateMap.remove(new Integer(currentChild));
                        continue;
                    }
                    newRegisteredState = new Integer(currentChild);
                    register.put(currentChildEncoding, newRegisteredState);
                    lastStateMap.remove(newRegisteredState);
                }
            }
            if ((newStates = A.addSufixReturnNewStates(lastState, data[i], prefixLength)).size() <= 0) continue;
            nextState = new Integer(newStates.get(0));
            lastStateMap.put(new Integer(lastState), nextState);
            int len = newStates.size() - 1;
            for (int j = 0; j < len; ++j) {
                oldState = nextState;
                nextState = new Integer(newStates.get(j + 1));
                lastStateMap.put(oldState, nextState);
            }
        }
        lastChildChain.clear();
        lastChildChain.add(0);
        child = (Integer)lastStateMap.get(new Integer(0));
        while (child != null) {
            lastChildChain.add(child);
            child = (Integer)lastStateMap.get(child);
        }
        for (k = lastChildChain.size() - 1; k >= 1; --k) {
            currentParent = lastChildChain.get(k - 1);
            currentChild = lastChildChain.get(k);
            SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
            if (register.containsKey(currentChildEncoding)) {
                newTarget = (Integer)register.get(currentChildEncoding);
                A.replaceTarget(currentParent, currentChild, newTarget);
                lastStateMap.put(new Integer(currentParent), newTarget);
                A.removeState(currentChild);
                lastStateMap.remove(new Integer(currentChild));
                continue;
            }
            newRegisteredState = new Integer(currentChild);
            register.put(currentChildEncoding, newRegisteredState);
            lastStateMap.remove(newRegisteredState);
        }
        System.out.println("Automaton without path compression");
        A.printOverview();
        System.out.println("-----------------------------------------");
        if (withPathCompression) {
            Object[] Paths;
            System.out.println("Path Compression active");
            for (int loop = 0; loop < repetition && (Paths = A.compressSimplePaths(lastStateMap, register, new String(new Character(last).toString()), reversePaths)).length >= minNumPaths; ++loop) {
                Integer newRegisteredState2;
                Integer newTarget2;
                int k2;
                System.out.println("Path Compression level: " + loop);
                System.out.println(" #paths " + Paths.length);
                numberOfEntries = Paths.length;
                if (!charCheck[last]) {
                    charCheck[last] = true;
                    FiniteStateAlgorithms.SymbolToIndexInAlphabet[last] = Alphabet.length + 1;
                }
                Arrays.sort(Paths);
                numberOfEntries = Paths.length;
                for (i = 0; i < numberOfEntries; ++i) {
                    prefixLength = A.longestPrefix((String)Paths[i]);
                    lastState = A.delta((String)Paths[i], prefixLength);
                    if (A.hasChildren(lastState)) {
                        lastChildChain.clear();
                        lastChildChain.add(lastState);
                        child = lastStateMap.get(new Integer(lastState));
                        while (child != null) {
                            lastChildChain.add(child);
                            child = lastStateMap.get(child);
                        }
                        for (k2 = lastChildChain.size() - 1; k2 >= 1; --k2) {
                            currentParent = lastChildChain.get(k2 - 1);
                            currentChild = lastChildChain.get(k2);
                            SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
                            if (register.containsKey(currentChildEncoding)) {
                                newTarget2 = (Integer)register.get(currentChildEncoding);
                                A.replaceTarget(currentParent, currentChild, newTarget2);
                                lastStateMap.put(new Integer(currentParent), newTarget2);
                                A.removeState(currentChild);
                                lastStateMap.remove(new Integer(currentChild));
                                continue;
                            }
                            newRegisteredState2 = new Integer(currentChild);
                            register.put(currentChildEncoding, newRegisteredState2);
                            lastStateMap.remove(newRegisteredState2);
                        }
                    }
                    if ((newStates = A.addSufixReturnNewStates(lastState, (String)Paths[i], prefixLength)).size() <= 0) continue;
                    nextState = new Integer(newStates.get(0));
                    lastStateMap.put(new Integer(lastState), nextState);
                    int len = newStates.size() - 1;
                    for (int j = 0; j < len; ++j) {
                        oldState = nextState;
                        nextState = new Integer(newStates.get(j + 1));
                        lastStateMap.put(oldState, nextState);
                    }
                }
                lastChildChain.clear();
                lastChildChain.add(0);
                child = lastStateMap.get(new Integer(0));
                while (child != null) {
                    lastChildChain.add(child);
                    child = lastStateMap.get(child);
                }
                for (k2 = lastChildChain.size() - 1; k2 >= 1; --k2) {
                    currentParent = lastChildChain.get(k2 - 1);
                    currentChild = lastChildChain.get(k2);
                    SimpleIntSet currentChildEncoding = FiniteStateAlgorithms.transitionListToSimpleIntArrayList(A.isFinalState(currentChild), A.getTransitions(currentChild));
                    if (register.containsKey(currentChildEncoding)) {
                        newTarget2 = (Integer)register.get(currentChildEncoding);
                        A.replaceTarget(currentParent, currentChild, newTarget2);
                        lastStateMap.put(new Integer(currentParent), newTarget2);
                        A.removeState(currentChild);
                        lastStateMap.remove(new Integer(currentChild));
                        continue;
                    }
                    newRegisteredState2 = new Integer(currentChild);
                    register.put(currentChildEncoding, newRegisteredState2);
                    lastStateMap.remove(newRegisteredState2);
                }
                last = (char)(((String)Paths[numberOfEntries - 1]).charAt(0) + '\u0001');
                System.out.println("Automaton after path compression level: " + loop);
                A.printOverview();
                System.out.println("----------------------------------------" + loop);
            }
        }
        System.out.println("Final Compressed Automaton");
        A.printOverview();
        return A;
    }

    private static String[] prepareInput(String AttributeFile, String ListFile, String InputCs, char InputSeparator) throws FiniteStateProcessingException {
        String NextValue;
        String NextAttr;
        String NextEntry;
        StringTokenizer ST;
        String Line;
        int i;
        String[] Attributes2;
        ArrayList<String> ConvertedData = new ArrayList<String>();
        int averageLength = 0;
        HashMap<String, Integer> AttributeMapping = new HashMap<String, Integer>();
        try {
            Attributes2 = Files.FileToStringArray(AttributeFile, InputCs);
        }
        catch (Exception e) {
            throw new FiniteStateProcessingException("Could not read from file: " + AttributeFile);
        }
        boolean[] StringValuedAttribute = new boolean[Attributes2.length];
        for (int i2 = 0; i2 < Attributes2.length; ++i2) {
            if (Attributes2[i2].charAt(0) == '$') {
                AttributeMapping.put(Attributes2[i2].substring(1), new Integer(i2));
                StringValuedAttribute[i2] = true;
                continue;
            }
            AttributeMapping.put(Attributes2[i2], new Integer(i2));
            StringValuedAttribute[i2] = false;
        }
        int NumberAttributes = AttributeMapping.size();
        int[] valueCounters = new int[NumberAttributes];
        HashMap[] AttributeValueMapping = new HashMap[NumberAttributes];
        for (i = 0; i < NumberAttributes; ++i) {
            AttributeValueMapping[i] = new HashMap();
            valueCounters[i] = !StringValuedAttribute[i] ? 0 : -1;
        }
        int firstNotStringValued = -1;
        for (i = 0; i < NumberAttributes; ++i) {
            if (StringValuedAttribute[i]) continue;
            firstNotStringValued = i;
            break;
        }
        int count = 0;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ListFile), InputCs));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            count = 0;
            while ((Line = in.readLine()) != null) {
                if ((Line = Line.trim()).length() <= 0 || Line.charAt(0) == '#') continue;
                averageLength += Line.length();
                ST = new StringTokenizer(Line, ":" + InputSeparator + "\n" + "\r");
                NextEntry = null;
                if (Line.indexOf(InputSeparator) == -1 || !ST.hasMoreTokens()) {
                    in.close();
                    FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                } else {
                    NextEntry = ST.nextToken().trim();
                }
                while (ST.hasMoreTokens()) {
                    int NextValueInt;
                    Integer ValueCode;
                    int CCode;
                    NextAttr = null;
                    NextValue = null;
                    try {
                        NextAttr = ST.nextToken().trim();
                        if (NextAttr.length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " -> Missing attribute name");
                        }
                        if ((NextValue = ST.nextToken().trim()).length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Missing attribute value");
                        }
                    }
                    catch (NoSuchElementException e) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                    }
                    Integer Code = (Integer)AttributeMapping.get(NextAttr);
                    if (Code == null) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Attribute name " + NextAttr + " unknown.");
                    }
                    if (StringValuedAttribute[CCode = Code.intValue()] || (ValueCode = (Integer)AttributeValueMapping[CCode].get(NextValue)) != null) continue;
                    int n = CCode;
                    valueCounters[n] = valueCounters[n] + 1;
                    AttributeValueMapping[CCode].put(NextValue, new Integer(NextValueInt));
                }
                ++count;
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            FiniteStateAlgorithms.exceptionMessage("File Not Found:" + ListFile);
        }
        catch (IOException e) {
            FiniteStateAlgorithms.exceptionMessage("IO Exception while processing file: " + ListFile);
        }
        int howManyAttributes = 0;
        for (int i3 = 0; i3 < NumberAttributes; ++i3) {
            if (StringValuedAttribute[i3]) continue;
            ++howManyAttributes;
        }
        int[] OrderOfCodingAttributes = new int[howManyAttributes];
        if (firstNotStringValued != -1) {
            int i4;
            int[] valueCountersCopy = new int[valueCounters.length];
            for (i4 = 0; i4 < valueCountersCopy.length; ++i4) {
                valueCountersCopy[i4] = valueCounters[i4];
            }
            for (i4 = 0; i4 < howManyAttributes; ++i4) {
                int max = firstNotStringValued;
                for (int j = 0; j < valueCountersCopy.length; ++j) {
                    if (valueCountersCopy[j] <= valueCountersCopy[max]) continue;
                    max = j;
                }
                OrderOfCodingAttributes[i4] = max;
                valueCountersCopy[max] = -1;
            }
        }
        int[] CurrAttrVal = new int[NumberAttributes];
        for (int i5 = 0; i5 < NumberAttributes; ++i5) {
            CurrAttrVal[i5] = -1;
        }
        int patternYes = 0;
        int patternNo = 0;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ListFile), InputCs));
            count = 0;
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            String LastEntry = new String();
            int currentIndex = 0;
            while ((Line = in.readLine()) != null) {
                int i6;
                if ((Line = Line.trim()).length() <= 0 || Line.charAt(0) == '#') continue;
                ST = new StringTokenizer(Line, ":" + InputSeparator + "\n" + "\r");
                NextEntry = null;
                if (Line.indexOf(InputSeparator) == -1 || !ST.hasMoreTokens()) {
                    in.close();
                    FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                } else {
                    NextEntry = ST.nextToken().trim();
                }
                if (LastEntry.compareTo(NextEntry) == 0) {
                    ++currentIndex;
                } else {
                    LastEntry = new String(NextEntry);
                    currentIndex = 0;
                }
                while (ST.hasMoreTokens()) {
                    NextAttr = null;
                    NextValue = null;
                    try {
                        NextAttr = ST.nextToken().trim();
                        if (NextAttr.length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " -> Missing attribute name");
                        }
                        if ((NextValue = ST.nextToken().trim()).length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Missing attribute value");
                        }
                    }
                    catch (NoSuchElementException e) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                    }
                    Integer Code = (Integer)AttributeMapping.get(NextAttr);
                    int CCode = Code;
                    if (CurrAttrVal[CCode] != -1) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Double occurence of attribute: " + NextAttr);
                    }
                    if (StringValuedAttribute[CCode]) {
                        CurrAttrVal[CCode] = 1;
                        String Pattern2 = StringFunctions.FormingPattern(NextEntry, NextValue);
                        if (Pattern2 == null) {
                            ConvertedData.add(NextEntry + ':' + currentIndex + (char)CCode + NextValue);
                            ++patternNo;
                            continue;
                        }
                        ++patternYes;
                        ConvertedData.add(NextEntry + ':' + currentIndex + (char)CCode + Pattern2);
                        continue;
                    }
                    Integer ValueCode = (Integer)AttributeValueMapping[CCode].get(NextValue);
                    CurrAttrVal[CCode] = ValueCode;
                }
                ++count;
                StringBuffer Next = new StringBuffer();
                Next.append(NextEntry);
                Next.append(':');
                Next.append(currentIndex);
                boolean any = false;
                for (i6 = 0; i6 < howManyAttributes; ++i6) {
                    if (CurrAttrVal[OrderOfCodingAttributes[i6]] == -1) continue;
                    Next.append((char)OrderOfCodingAttributes[i6]);
                    Next.append((char)CurrAttrVal[OrderOfCodingAttributes[i6]]);
                    any = true;
                }
                for (i6 = 0; i6 < NumberAttributes; ++i6) {
                    CurrAttrVal[i6] = -1;
                }
                if (!any) continue;
                ConvertedData.add(Next.toString());
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            FiniteStateAlgorithms.exceptionMessage("File Not Found:" + ListFile);
        }
        catch (IOException e) {
            FiniteStateAlgorithms.exceptionMessage("IO Exception while processing file: " + ListFile);
        }
        System.out.println("Gazetteer Information");
        System.out.println("Number of Entries: " + count);
        System.out.println("Average Line length in gazetteer sources: " + averageLength / count);
        System.out.println("Formation pattern applicability: " + (double)patternYes / (double)(patternNo + patternYes));
        int strValAttr = 0;
        for (int i7 = 0; i7 < StringValuedAttribute.length; ++i7) {
            if (!StringValuedAttribute[i7]) continue;
            ++strValAttr;
        }
        System.out.println("#String-valued Attributes: " + strValAttr);
        int len = ConvertedData.size();
        String[] RESULT = new String[len];
        for (int i8 = 0; i8 < len; ++i8) {
            RESULT[i8] = (String)ConvertedData.get(i8);
        }
        return RESULT;
    }

    private static String[] prepareInputAlaKowaltowski(String AttributeFile, String ListFile, String InputCs, char InputSeparator) throws FiniteStateProcessingException {
        int i;
        String NextValue;
        String NextAttr;
        String NextEntry;
        StringTokenizer ST;
        String Line;
        int i2;
        String[] Attributes2;
        ArrayList<String> ConvertedData = new ArrayList<String>();
        int averageLength = 0;
        char maxChar = '\u0000';
        HashMap<String, Integer> AttributeMapping = new HashMap<String, Integer>();
        try {
            Attributes2 = Files.FileToStringArray(AttributeFile, InputCs);
        }
        catch (Exception e) {
            throw new FiniteStateProcessingException("Could not read from file: " + AttributeFile);
        }
        boolean[] StringValuedAttribute = new boolean[Attributes2.length];
        for (int i3 = 0; i3 < Attributes2.length; ++i3) {
            if (Attributes2[i3].charAt(0) == '$') {
                AttributeMapping.put(Attributes2[i3].substring(1), new Integer(i3));
                StringValuedAttribute[i3] = true;
                continue;
            }
            AttributeMapping.put(Attributes2[i3], new Integer(i3));
            StringValuedAttribute[i3] = false;
        }
        int NumberAttributes = AttributeMapping.size();
        int[] valueCounters = new int[NumberAttributes];
        HashMap[] AttributeValueMapping = new HashMap[NumberAttributes];
        for (i2 = 0; i2 < NumberAttributes; ++i2) {
            AttributeValueMapping[i2] = new HashMap();
            valueCounters[i2] = !StringValuedAttribute[i2] ? 0 : -1;
        }
        int firstNotStringValued = -1;
        for (i2 = 0; i2 < NumberAttributes; ++i2) {
            if (StringValuedAttribute[i2]) continue;
            firstNotStringValued = i2;
            break;
        }
        int count = 0;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ListFile), InputCs));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            count = 0;
            while ((Line = in.readLine()) != null) {
                if ((Line = Line.trim()).length() <= 0 || Line.charAt(0) == '#') continue;
                averageLength += Line.length();
                ST = new StringTokenizer(Line, ":" + InputSeparator + "\n" + "\r");
                NextEntry = null;
                if (Line.indexOf(InputSeparator) == -1 || !ST.hasMoreTokens()) {
                    in.close();
                    FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                } else {
                    NextEntry = ST.nextToken().trim();
                }
                if (NextEntry.charAt(0) > maxChar) {
                    maxChar = NextEntry.charAt(0);
                }
                while (ST.hasMoreTokens()) {
                    int NextValueInt;
                    Integer ValueCode;
                    int CCode;
                    NextAttr = null;
                    NextValue = null;
                    try {
                        NextAttr = ST.nextToken().trim();
                        if (NextAttr.length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " -> Missing attribute name");
                        }
                        if ((NextValue = ST.nextToken().trim()).length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Missing attribute value");
                        }
                    }
                    catch (NoSuchElementException e) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                    }
                    Integer Code = (Integer)AttributeMapping.get(NextAttr);
                    if (Code == null) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Attribute name " + NextAttr + " unknown.");
                    }
                    if (StringValuedAttribute[CCode = Code.intValue()] || (ValueCode = (Integer)AttributeValueMapping[CCode].get(NextValue)) != null) continue;
                    int n = CCode;
                    valueCounters[n] = valueCounters[n] + 1;
                    AttributeValueMapping[CCode].put(NextValue, new Integer(NextValueInt));
                }
                ++count;
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            FiniteStateAlgorithms.exceptionMessage("File Not Found:" + ListFile);
        }
        catch (IOException e) {
            FiniteStateAlgorithms.exceptionMessage("IO Exception while processing file: " + ListFile);
        }
        int howManyAttributes = 0;
        for (int i4 = 0; i4 < NumberAttributes; ++i4) {
            if (StringValuedAttribute[i4]) continue;
            ++howManyAttributes;
        }
        int[] OrderOfCodingAttributes = new int[howManyAttributes];
        if (firstNotStringValued != -1) {
            int[] valueCountersCopy = new int[valueCounters.length];
            for (i = 0; i < valueCountersCopy.length; ++i) {
                valueCountersCopy[i] = valueCounters[i];
            }
            for (i = 0; i < howManyAttributes; ++i) {
                int max = firstNotStringValued;
                for (int j = 0; j < valueCountersCopy.length; ++j) {
                    if (valueCountersCopy[j] <= valueCountersCopy[max]) continue;
                    max = j;
                }
                OrderOfCodingAttributes[i] = max;
                valueCountersCopy[max] = -1;
            }
        }
        int[] CurrAttrVal = new int[NumberAttributes];
        for (int i5 = 0; i5 < NumberAttributes; ++i5) {
            CurrAttrVal[i5] = -1;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ListFile), InputCs));
            count = 0;
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            String LastEntry = new String();
            int currentIndex = 0;
            while ((Line = in.readLine()) != null) {
                int i6;
                if ((Line = Line.trim()).length() <= 0 || Line.charAt(0) == '#') continue;
                ST = new StringTokenizer(Line, ":" + InputSeparator + "\n" + "\r");
                NextEntry = null;
                if (Line.indexOf(InputSeparator) == -1 || !ST.hasMoreTokens()) {
                    in.close();
                    FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                } else {
                    NextEntry = ST.nextToken().trim();
                }
                if (LastEntry.compareTo(NextEntry) == 0) {
                    ++currentIndex;
                } else {
                    LastEntry = new String(NextEntry);
                    currentIndex = 0;
                }
                ConvertedData.add(NextEntry + "*");
                while (ST.hasMoreTokens()) {
                    NextAttr = null;
                    NextValue = null;
                    try {
                        NextAttr = ST.nextToken().trim();
                        if (NextAttr.length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " -> Missing attribute name");
                        }
                        if ((NextValue = ST.nextToken().trim()).length() == 0) {
                            in.close();
                            FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Missing attribute value");
                        }
                    }
                    catch (NoSuchElementException e) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count);
                    }
                    Integer Code = (Integer)AttributeMapping.get(NextAttr);
                    int CCode = Code;
                    if (CurrAttrVal[CCode] != -1) {
                        in.close();
                        FiniteStateAlgorithms.exceptionMessage("Syntax error at line: " + count + " Double occurence of attribute: " + NextAttr);
                    }
                    if (StringValuedAttribute[CCode]) {
                        CurrAttrVal[CCode] = 1;
                        String Pattern2 = StringFunctions.FormingPattern(NextEntry, NextValue);
                        if (Pattern2 == null) {
                            ConvertedData.add((char)(CCode + maxChar + 1) + NextValue);
                            continue;
                        }
                        ConvertedData.add((char)(CCode + maxChar + 1) + Pattern2);
                        continue;
                    }
                    Integer ValueCode = (Integer)AttributeValueMapping[CCode].get(NextValue);
                    CurrAttrVal[CCode] = ValueCode;
                }
                ++count;
                StringBuffer Next = new StringBuffer();
                boolean any = false;
                for (i6 = 0; i6 < howManyAttributes; ++i6) {
                    if (CurrAttrVal[OrderOfCodingAttributes[i6]] == -1) continue;
                    Next.append((char)OrderOfCodingAttributes[i6]);
                    Next.append((char)CurrAttrVal[OrderOfCodingAttributes[i6]]);
                    any = true;
                }
                for (i6 = 0; i6 < NumberAttributes; ++i6) {
                    CurrAttrVal[i6] = -1;
                }
                if (!any) continue;
                ConvertedData.add((char)(NumberAttributes + maxChar + 1) + Next.toString());
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            FiniteStateAlgorithms.exceptionMessage("File Not Found:" + ListFile);
        }
        catch (IOException e) {
            FiniteStateAlgorithms.exceptionMessage("IO Exception while processing file: " + ListFile);
        }
        System.out.println("Gazetteer Information");
        System.out.println("Number of Entries: " + count);
        System.out.println("Average Line length: " + averageLength / count);
        int strValAttr = 0;
        for (i = 0; i < StringValuedAttribute.length; ++i) {
            if (!StringValuedAttribute[i]) continue;
            ++strValAttr;
        }
        System.out.println("#String-valued Attributes: " + strValAttr);
        int len = ConvertedData.size();
        String[] STAFF = new String[len];
        for (int i7 = 0; i7 < len; ++i7) {
            STAFF[i7] = (String)ConvertedData.get(i7);
        }
        return STAFF;
    }

    private static void prepareUKpostal(String ListFile, String outputFile) throws FiniteStateProcessingException {
        try {
            String Line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ListFile), "ISO-8859-1"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "ISO-8859-1"));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            while ((Line = in.readLine()) != null) {
                if ((Line = Line.trim()).length() <= 0 || Line.charAt(0) == '#') continue;
                StringTokenizer ST = new StringTokenizer(Line, "\n\r\t*");
                try {
                    String NextAttr = ST.nextToken().trim();
                    out.write(NextAttr + " | ");
                    NextAttr = ST.nextToken().trim();
                    out.write("COUNTY:" + NextAttr);
                    NextAttr = ST.nextToken().trim();
                    out.write(" | PCODE:" + NextAttr + "\n");
                }
                catch (Exception e) {
                    FiniteStateAlgorithms.exceptionMessage("Exception while processing file: " + ListFile);
                }
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            FiniteStateAlgorithms.exceptionMessage("File Not Found:" + ListFile);
        }
        catch (IOException e) {
            FiniteStateAlgorithms.exceptionMessage("IO Exception while processing file: " + ListFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void prepareGeoNames(String ListFile, String outputFile) throws FiniteStateProcessingException {
        int count = 0;
        try {
            String Line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ListFile), "UTF-8"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            count = 0;
            while ((Line = in.readLine()) != null) {
                if ((Line = Line.trim()).length() > 0 && Line.charAt(0) != '#') {
                    StringBuffer FinalEntry = new StringBuffer();
                    String keyWord = new String();
                    StringTokenizer ST = new StringTokenizer(Line, "\n\r\t", true);
                    try {
                        String NextAttr = ST.nextToken().trim();
                        FinalEntry.append("RC:" + NextAttr.trim() + " | ");
                        NextAttr = ST.nextToken();
                        NextAttr = ST.nextToken();
                        if (NextAttr.charAt(0) != '\t') {
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("UTM:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("JOG:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("FC:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("DSG:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("PC:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("CC1:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("ADM1:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("ADM2:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("CC2:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("NT:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("LC:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("SHORT_FORM:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("GENERIC:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("SORT_NAME:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        keyWord = NextAttr = ST.nextToken();
                        if (NextAttr.charAt(0) != '\t') {
                            FinalEntry.append("FULL_NAME:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) != '\t') {
                            FinalEntry.append("FULL_NAME_ND:" + NextAttr.trim() + " | ");
                            NextAttr = ST.nextToken();
                        }
                        if ((NextAttr = ST.nextToken()).charAt(0) == '\t') {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        FiniteStateAlgorithms.exceptionMessage("Exception while processing file: " + ListFile);
                        out.close();
                    }
                    out.write(keyWord + " | " + FinalEntry.toString());
                    out.write("\n");
                }
                if (++count <= 200000) continue;
            }
            in.close();
            out.close();
            return;
        }
        catch (FileNotFoundException e) {
            FiniteStateAlgorithms.exceptionMessage("File Not Found:" + ListFile);
            return;
        }
        catch (IOException e) {
            FiniteStateAlgorithms.exceptionMessage("IO Exception while processing file: " + ListFile);
        }
    }

    private static String[] prepareSimpleInput(String ListFile, String InputCs) throws FiniteStateProcessingException {
        ArrayList<String> ConvertedData = new ArrayList<String>(100000);
        try {
            String Line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ListFile), InputCs));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            while ((Line = in.readLine()) != null) {
                Line = Line.trim();
                ConvertedData.add(Line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            FiniteStateAlgorithms.exceptionMessage("File Not Found:" + ListFile);
        }
        catch (IOException e) {
            FiniteStateAlgorithms.exceptionMessage("IO Exception while processing file: " + ListFile);
        }
        int len = ConvertedData.size();
        String[] STAFF = new String[len];
        for (int i = 0; i < len; ++i) {
            STAFF[i] = (String)ConvertedData.get(i);
        }
        return STAFF;
    }

    public static void main(String[] args) throws FiniteStateProcessingException {
        String AttributeFile = args[0];
        String EntryFile = args[1];
        String Encoding = args[2];
        boolean WithPathCompression = false;
        boolean KowaltowskiEncoding = false;
        boolean DataPreparation = true;
        boolean reversePaths = false;
        boolean Convert = false;
        if (args.length > 3) {
            System.out.println(args[3]);
            if (args[3].indexOf("t") != -1) {
                DataPreparation = false;
            }
            if (args[3].indexOf("x") != -1) {
                Convert = true;
            }
            if (args[3].indexOf("r") != -1) {
                reversePaths = true;
            }
            if (DataPreparation) {
                if (args[3].indexOf("k") != -1) {
                    KowaltowskiEncoding = true;
                }
                System.out.println("With Kowaltowski Method: " + KowaltowskiEncoding);
            }
            if (args[3].indexOf("p") != -1) {
                WithPathCompression = true;
            }
            System.out.println("With Path Compression: " + WithPathCompression);
        }
        long timeStart = System.currentTimeMillis();
        System.out.println("Convert Data");
        if (Convert) {
            FiniteStateAlgorithms.prepareGeoNames(AttributeFile, EntryFile);
        } else {
            String[] ConvertedData;
            if (DataPreparation) {
                ConvertedData = KowaltowskiEncoding ? FiniteStateAlgorithms.prepareInputAlaKowaltowski(AttributeFile, EntryFile, Encoding, '|') : FiniteStateAlgorithms.prepareInput(AttributeFile, EntryFile, Encoding, '|');
            } else {
                System.out.println("No Special Preparation");
                try {
                    ConvertedData = Files.FileToStringArray(EntryFile, Encoding);
                }
                catch (Exception e) {
                    throw new FiniteStateProcessingException("Could not access the file: " + EntryFile);
                }
            }
            System.out.println("End Convert Data");
            DynamicLetterMarkedTravFSAInterface AUTOMAT = FiniteStateAlgorithms.MinDetAutomatonFromListOfWordsX(ConvertedData, WithPathCompression, 10, 3, reversePaths);
            DictionaryLetterFSAImpl_1 B = new DictionaryLetterFSAImpl_1();
            B.initializeFrom(AUTOMAT);
            B.saveToFile("Automacik");
            DictionaryLetterFSAImpl_1 C = new DictionaryLetterFSAImpl_1();
            C.readFromFile("Automacik");
            long timeEnd = System.currentTimeMillis();
            System.out.println("Time: " + (float)(timeEnd - timeStart) / 1000.0f);
        }
    }

    static {
        MAX_CHAR = 65536;
    }
}

