/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import piskorski.fs.letterfs.fsa.InOutDegree;
import piskorski.fs.letterfs.fsa.TransitionArrayList;
import piskorski.util.arraylist.BooleanArrayList;
import piskorski.util.arraylist.CharacterArrayList;
import piskorski.util.arraylist.IntArrayList;
import piskorski.util.strings.StringFunctions;

public class LetterDynamicFSA {
    private IntArrayList states;
    private BooleanArrayList finalStates;
    private BooleanArrayList markedStates;
    private IntArrayList targets;
    private CharacterArrayList symbols;
    private IntArrayList next;
    private IntArrayList freeStates;
    private IntArrayList freeTransitions;
    private BooleanArrayList isState;
    private int numStates;
    private int numTransitions;
    private boolean stateMarkingActive;
    private int[] firstStatTransitions;

    public boolean isFinalState(int state) {
        if (this.isState.get(state)) {
            return this.finalStates.get(state);
        }
        return false;
    }

    public boolean isMarkedState(int state) {
        if (this.isState.get(state)) {
            return this.markedStates.get(state);
        }
        return false;
    }

    public void setFinalState(int state) {
        if (this.isState.get(state)) {
            this.finalStates.set(state, true);
        }
    }

    public void markState(int state) {
        if (this.isState.get(state)) {
            this.markedStates.set(state, true);
        }
    }

    public void setNonFinalState(int state) {
        if (this.isState.get(state)) {
            this.finalStates.set(state, false);
        }
    }

    public void unmarkState(int state) {
        if (this.isState.get(state)) {
            this.markedStates.set(state, false);
        }
    }

    public int addState() {
        if (!this.freeStates.empty()) {
            int which = this.freeStates.removeLast();
            this.isState.set(which, true);
            this.finalStates.set(which, false);
            this.states.set(which, -1);
            if (this.stateMarkingActive) {
                this.markedStates.set(which, false);
            }
            ++this.numStates;
            return which;
        }
        this.isState.add(true);
        this.finalStates.add(false);
        this.states.add(-1);
        if (this.stateMarkingActive) {
            this.markedStates.add(false);
        }
        ++this.numStates;
        return this.states.size() - 1;
    }

    private boolean isState(int state) {
        if (state < 0 || state >= this.isState.size()) {
            return false;
        }
        return this.isState.get(state);
    }

    public int removeState(int state) {
        if (this.isState.get(state)) {
            this.removeAllEdgesFromState(state);
            this.freeStates.add(state);
            if (this.stateMarkingActive) {
                this.markedStates.set(state, false);
            }
            this.isState.set(state, false);
            --this.numStates;
        }
        return this.numStates;
    }

    public void removeAllEdgesFromState(int state) {
        if (this.isState.get(state)) {
            int nextEdge = this.getFirstEdge(state);
            this.states.set(state, -1);
            while (nextEdge != -1) {
                if (state == 0) {
                    this.firstStatTransitions[this.symbols.get((int)nextEdge)] = -1;
                }
                this.freeTransitions.add(nextEdge);
                --this.numTransitions;
                nextEdge = this.next.get(nextEdge);
            }
        }
    }

    public boolean addEdge(int source, int target, char symbol) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target && this.symbols.get(nextEdgeIndex) == symbol) {
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        if (source == 0) {
            this.firstStatTransitions[symbol] = target;
        }
        if (!this.freeTransitions.empty()) {
            nextEdgeIndex = this.freeTransitions.removeLast();
            this.targets.set(nextEdgeIndex, target);
            this.symbols.set(nextEdgeIndex, symbol);
            this.next.set(nextEdgeIndex, firstEdgeIndex);
            this.states.set(source, nextEdgeIndex);
        } else {
            nextEdgeIndex = this.targets.size();
            this.targets.add(target);
            this.symbols.add(symbol);
            this.next.add(firstEdgeIndex);
            this.states.set(source, nextEdgeIndex);
        }
        ++this.numTransitions;
        return true;
    }

    public boolean replaceEdge(int source, int target, char symbol, int newTarget, char newSymbol) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target && this.symbols.get(nextEdgeIndex) == symbol) {
                this.targets.set(nextEdgeIndex, newTarget);
                this.symbols.set(nextEdgeIndex, newSymbol);
                if (source == 0) {
                    this.firstStatTransitions[symbol] = -1;
                    this.firstStatTransitions[newSymbol] = newTarget;
                }
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    public boolean replaceTarget(int source, int target, char symbol, int newTarget) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target && this.symbols.get(nextEdgeIndex) == symbol) {
                this.targets.set(nextEdgeIndex, newTarget);
                if (source == 0) {
                    this.firstStatTransitions[symbol] = newTarget;
                }
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    public boolean replaceTarget(int source, int target, int newTarget) {
        int nextEdgeIndex;
        if (!this.isState.get(source) || !this.isState.get(target)) {
            return false;
        }
        int firstEdgeIndex = nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target) {
                this.targets.set(nextEdgeIndex, newTarget);
                if (source == 0) {
                    this.firstStatTransitions[this.symbols.get((int)nextEdgeIndex)] = newTarget;
                }
                return true;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return false;
    }

    public int getTargetState(int source, char symbol) {
        if (!this.isState.get(source)) {
            return -1;
        }
        if (source == 0) {
            return this.firstStatTransitions[symbol];
        }
        int nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol) {
                return this.targets.get(nextEdgeIndex);
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return -1;
    }

    public char getSymbolOnTransition(int source, int target) {
        if (!this.isState.get(source)) {
            return '\u0000';
        }
        if (!this.isState.get(target)) {
            return '\u0000';
        }
        int nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.targets.get(nextEdgeIndex) == target) {
                return this.symbols.get(nextEdgeIndex);
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return '\u0000';
    }

    public TransitionArrayList getTransitions(int source) {
        if (!this.isState.get(source)) {
            return null;
        }
        TransitionArrayList T = new TransitionArrayList();
        int nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            T.add(this.targets.get(nextEdgeIndex), this.symbols.get(nextEdgeIndex));
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return T;
    }

    private int getEdge(int source, char symbol) {
        if (!this.isState.get(source)) {
            return -1;
        }
        int nextEdgeIndex = this.states.get(source);
        while (nextEdgeIndex != -1) {
            if (this.symbols.get(nextEdgeIndex) == symbol) {
                return nextEdgeIndex;
            }
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return -1;
    }

    public boolean removeEdge(int source, char symbol) {
        if (!this.isState.get(source)) {
            return false;
        }
        if (source == 0) {
            this.firstStatTransitions[symbol] = -1;
        }
        int nextEdgeIndex = this.states.get(source);
        int previousEdge = -1;
        while (nextEdgeIndex != -1 && this.symbols.get(nextEdgeIndex) != symbol) {
            previousEdge = nextEdgeIndex;
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        if (nextEdgeIndex == -1) {
            return false;
        }
        int nextEdge = this.next.get(nextEdgeIndex);
        if (previousEdge != -1) {
            this.next.set(previousEdge, nextEdge);
        } else if (nextEdge != -1) {
            this.states.set(source, nextEdge);
        } else {
            this.states.set(source, -1);
        }
        this.freeTransitions.add(nextEdgeIndex);
        --this.numTransitions;
        return true;
    }

    public boolean hasChildren(int state) {
        return this.getFirstEdge(state) != -1;
    }

    private int getFirstEdge(int state) {
        if (!this.isState.get(state)) {
            return -1;
        }
        return this.states.get(state);
    }

    public int getFirstTargetState(int state) {
        if (!this.isState.get(state)) {
            return -1;
        }
        int edge = this.getFirstEdge(state);
        if (edge == -1) {
            return -1;
        }
        return this.targets.get(edge);
    }

    private int getNextEdge(int edgeIndex) {
        if (edgeIndex < 0) {
            return -1;
        }
        return this.next.get(edgeIndex);
    }

    private int getTargetState(int edgeIndex) {
        if (edgeIndex < 0) {
            return -1;
        }
        return this.targets.get(edgeIndex);
    }

    private char getSymbol(int edgeIndex) {
        if (edgeIndex < 0) {
            return ' ';
        }
        return this.symbols.get(edgeIndex);
    }

    public int getNumberStates() {
        return this.numStates;
    }

    public int getNumberEdges() {
        return this.numTransitions;
    }

    public boolean addSufix(int state, String word) {
        if (!this.isState.get(state)) {
            return false;
        }
        int len = word.length();
        int lastState = state;
        for (int i = 0; i < len; ++i) {
            int nextState = this.addState();
            this.addEdge(lastState, nextState, word.charAt(i));
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return true;
    }

    public IntArrayList addSufixReturnNewStates(int state, String word) {
        IntArrayList newStates = new IntArrayList();
        if (!this.isState.get(state)) {
            return null;
        }
        int len = word.length();
        int lastState = state;
        for (int i = 0; i < len; ++i) {
            int nextState = this.addState();
            this.addEdge(lastState, nextState, word.charAt(i));
            newStates.add(nextState);
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return newStates;
    }

    public boolean addSufix(int state, String word, int start) {
        if (!this.isState.get(state)) {
            return false;
        }
        int len = word.length();
        int lastState = state;
        int i = start;
        while (i < len) {
            int nextState = this.addState();
            this.addEdge(lastState, nextState, word.charAt(i++));
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return true;
    }

    public IntArrayList addSufixReturnNewStates(int state, String word, int start) {
        IntArrayList newStates = new IntArrayList();
        if (!this.isState.get(state)) {
            return null;
        }
        int len = word.length();
        int lastState = state;
        int i = start;
        while (i < len) {
            int nextState = this.addState();
            this.addEdge(lastState, nextState, word.charAt(i++));
            newStates.add(nextState);
            lastState = nextState;
        }
        if (lastState != -1) {
            this.setFinalState(lastState);
        }
        return newStates;
    }

    public int longestPrefix(String word) {
        int state = 0;
        int len = word.length();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int nextState = this.getTargetState(state, word.charAt(i));
            if (nextState == -1) {
                return count;
            }
            state = nextState;
            ++count;
        }
        return count;
    }

    public boolean acccepts(String word) {
        int nextState = 0;
        int len = word.length();
        if (len > 0) {
            nextState = this.firstStatTransitions[word.charAt(0)];
            for (int i = 1; i < len; ++i) {
                if ((nextState = this.getTargetState(nextState, word.charAt(i))) != -1) continue;
                return false;
            }
        }
        return this.isFinalState(nextState);
    }

    public int delta(String word, int len) {
        int nextState = 0;
        boolean count = false;
        if (len > 0) {
            nextState = this.firstStatTransitions[word.charAt(0)];
            for (int i = 1; i < len && (nextState = this.getTargetState(nextState, word.charAt(i))) != -1; ++i) {
            }
        }
        return nextState;
    }

    public int outDegree(int state) {
        int numTrans = 0;
        if (!this.isState.get(state)) {
            return -1;
        }
        int nextEdgeIndex = this.states.get(state);
        while (nextEdgeIndex != -1) {
            ++numTrans;
            nextEdgeIndex = this.next.get(nextEdgeIndex);
        }
        return numTrans;
    }

    public InOutDegree[] inOutDegree() {
        int maxNumStates = this.states.size();
        InOutDegree[] iOMap = new InOutDegree[maxNumStates];
        for (int i = 0; i < maxNumStates; ++i) {
            iOMap[i] = new InOutDegree(-1, -1);
        }
        IntArrayList States = new IntArrayList();
        States.add(0);
        while (States.size() > 0) {
            int sourceState = States.removeLast();
            int nextEdgeIndex = this.states.get(sourceState);
            while (nextEdgeIndex != -1) {
                int targetState = this.targets.get(nextEdgeIndex);
                if (iOMap[sourceState].getOutDegree() != -1) {
                    iOMap[sourceState].incrementOutDegree();
                } else {
                    iOMap[sourceState].set(0, 1);
                }
                if (iOMap[targetState].getInDegree() != -1) {
                    iOMap[targetState].incrementInDegree();
                } else {
                    States.add(targetState);
                    iOMap[targetState].set(1, 0);
                }
                nextEdgeIndex = this.next.get(nextEdgeIndex);
            }
        }
        return iOMap;
    }

    public boolean[] computeCharInAlphabet() {
        boolean[] isInAlphabet = new boolean[65536];
        Arrays.fill(isInAlphabet, false);
        for (int i = 0; i < this.isState.size(); ++i) {
            TransitionArrayList Transitions;
            if (!this.isState.get(i) || (Transitions = this.getTransitions(i)) == null) continue;
            for (int k = 0; k < Transitions.size(); ++k) {
                isInAlphabet[Transitions.getSymbol((int)k)] = true;
            }
        }
        return isInAlphabet;
    }

    public String[] compressSimplePaths(HashMap<Integer, Integer> LastState, HashMap register, String Prefix, boolean reversePaths) {
        int i;
        Integer lastStateTarget;
        String[] ExtraSymbols = new String[65536];
        ArrayList<String> Co = new ArrayList<String>();
        for (int i2 = 0; i2 < 65536; ++i2) {
            ExtraSymbols[i2] = null;
        }
        int numNewSymbols = 0;
        char[] symbol = new char[1000];
        int symbolLen = 0;
        HashMap<String, Integer> newSymbols = new HashMap<String, Integer>(1000);
        InOutDegree[] deg = this.inOutDegree();
        for (int i3 = 0; i3 < this.isState.size(); ++i3) {
            if (!this.isState.get(i3) || this.isFinalState(i3) || deg[i3].getInDegree() != 1 || deg[i3].getOutDegree() != 1) continue;
            this.markState(i3);
        }
        Iterator RegisterIterator = register.entrySet().iterator();
        while (RegisterIterator.hasNext()) {
            int state = (Integer)RegisterIterator.next().getValue();
            if (!this.isState.get(state) || !this.isMarkedState(state)) continue;
            RegisterIterator.remove();
        }
        Iterator<Integer> LastStateIterator = LastState.keySet().iterator();
        HashMap<Integer, Integer> newLastState = new HashMap<Integer, Integer>();
        while (LastStateIterator.hasNext()) {
            Integer lastState = LastStateIterator.next();
            lastStateTarget = LastState.get(lastState);
            int source = lastState;
            int target = lastStateTarget;
            if (this.isMarkedState(source)) {
                LastStateIterator.remove();
                continue;
            }
            if (!this.isMarkedState(target)) continue;
            int nextTarget = target;
            while (this.isMarkedState(nextTarget)) {
                nextTarget = this.getFirstTargetState(nextTarget);
            }
            newLastState.put(lastState, new Integer(nextTarget));
            LastStateIterator.remove();
        }
        for (Integer lastState : newLastState.keySet()) {
            lastStateTarget = (Integer)newLastState.get(lastState);
            LastState.put(lastState, lastStateTarget);
        }
        boolean[] isInAlphabet = this.computeCharInAlphabet();
        int numSymbolsInAlphabet = 0;
        for (int i4 = 0; i4 < 65536; ++i4) {
            if (!isInAlphabet[i4]) continue;
            ++numSymbolsInAlphabet;
        }
        int nextFreeSymbol = 0;
        while (isInAlphabet[nextFreeSymbol]) {
            ++nextFreeSymbol;
        }
        for (i = 0; i < this.isState.size(); ++i) {
            TransitionArrayList Transitions;
            if (!this.isState.get(i) || this.isMarkedState(i) || (Transitions = this.getTransitions(i)) == null) continue;
            for (int k = 0; k < Transitions.size(); ++k) {
                int nextTarget = Transitions.getTarget(k);
                if (!this.isMarkedState(nextTarget)) continue;
                symbolLen = 0;
                symbol[symbolLen++] = Transitions.getSymbol(k);
                this.removeEdge(i, Transitions.getSymbol(k));
                while (this.isMarkedState(nextTarget)) {
                    int nextEdge = this.getFirstEdge(nextTarget);
                    int oldState = nextTarget;
                    symbol[symbolLen++] = this.getSymbol(nextEdge);
                    nextTarget = this.getTargetState(nextEdge);
                    this.removeState(oldState);
                }
                String newSymbol = new String(symbol, 1, symbolLen - 1);
                if (!newSymbols.containsKey(newSymbol)) {
                    if (reversePaths) {
                        Co.add(Prefix + StringFunctions.reverse(newSymbol));
                    } else {
                        Co.add(Prefix + newSymbol);
                    }
                    newSymbols.put(newSymbol, new Integer(numNewSymbols));
                    ++numNewSymbols;
                }
                this.addEdge(i, nextTarget, symbol[0]);
            }
        }
        ExtraSymbols = new String[Co.size()];
        for (i = 0; i < Co.size(); ++i) {
            ExtraSymbols[i] = (String)Co.get(i);
        }
        return ExtraSymbols;
    }

    private void standardInit() {
        this.states = new IntArrayList();
        this.finalStates = new BooleanArrayList();
        this.targets = new IntArrayList();
        this.symbols = new CharacterArrayList();
        this.next = new IntArrayList();
        this.freeStates = new IntArrayList();
        this.freeTransitions = new IntArrayList();
        this.isState = new BooleanArrayList();
        this.numStates = 0;
        this.addState();
        this.numTransitions = 0;
        this.firstStatTransitions = new int[65536];
        Arrays.fill(this.firstStatTransitions, -1);
    }

    private void markingStatesInit(boolean active) {
        this.stateMarkingActive = active;
        this.markedStates = this.stateMarkingActive ? new BooleanArrayList() : null;
    }

    public LetterDynamicFSA() {
        this.standardInit();
        this.markingStatesInit(false);
    }

    public LetterDynamicFSA(boolean withStateMarking) {
        this.standardInit();
        this.markingStatesInit(withStateMarking);
    }

    public LetterDynamicFSA(int numStates, int numTransitions, boolean withStateMarking) {
        this.states = new IntArrayList(numStates);
        this.finalStates = new BooleanArrayList(numStates);
        this.isState = new BooleanArrayList(numStates);
        this.targets = new IntArrayList(numTransitions);
        this.symbols = new CharacterArrayList(numTransitions);
        this.next = new IntArrayList(numTransitions);
        this.freeStates = new IntArrayList();
        this.freeTransitions = new IntArrayList();
        this.numStates = 0;
        this.numTransitions = 0;
        this.markingStatesInit(withStateMarking);
        this.addState();
        this.firstStatTransitions = new int[65536];
        Arrays.fill(this.firstStatTransitions, -1);
    }

    public void print() {
        System.out.println("AUTOMATON INFO");
        System.out.println("Number of States: " + this.numStates);
        System.out.println("Number of Transitions: " + this.numTransitions);
        InOutDegree[] D = this.inOutDegree();
        for (int i = 0; i < this.isState.size(); ++i) {
            if (!this.isState.get(i)) continue;
            if (this.isFinalState(i)) {
                System.out.print("F");
            }
            System.out.print("[" + i + "] -> ");
            TransitionArrayList Transitions = this.getTransitions(i);
            if (Transitions != null) {
                for (int k = 0; k < Transitions.size(); ++k) {
                    System.out.print(" (" + Transitions.getSymbol(k) + "," + Transitions.getTarget(k) + ")");
                }
                System.out.println(" ");
            }
            if (D[i].getInDegree() != -1) {
                System.out.println("IN-DEG: " + D[i].getInDegree() + " " + D[i].getOutDegree());
                continue;
            }
            System.out.println("NOT-REACHABLE STATE");
        }
    }

    public void printOverview() {
        int numFinal = 0;
        for (int i = 0; i < this.isState.size(); ++i) {
            if (!this.isState.get(i) || !this.isFinalState(i)) continue;
            ++numFinal;
        }
        System.out.println("Number of States: " + this.numStates);
        System.out.println("Number of Final States: " + numFinal);
        System.out.println("Number of Transitions: " + this.numTransitions);
    }
}

