/*
 * Decompiled with CFR 0.152.
 */
package piskorski.fs.letterfs.fsa;

public class TransitionArrayList {
    private transient int[] targets;
    private transient char[] symbols;
    private int size;
    private int minCapacity;

    public TransitionArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.targets = new int[initialCapacity];
        this.symbols = new char[initialCapacity];
    }

    public TransitionArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.targets.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.targets;
            char[] oldData2 = this.symbols;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.targets = new int[newCapacity];
            this.symbols = new char[newCapacity];
            System.arraycopy(oldData, 0, this.targets, 0, this.size);
            System.arraycopy(oldData2, 0, this.symbols, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getTarget(int index) {
        return this.targets[index];
    }

    public char getSymbol(int index) {
        return this.symbols[index];
    }

    public void set(int index, int target, char symbol) {
        this.targets[index] = target;
        this.symbols[index] = symbol;
    }

    public void add(int target, char symbol) {
        if (this.size + 1 > this.targets.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.targets.length;
            int[] oldData = this.targets;
            char[] oldData2 = this.symbols;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.targets = new int[newCapacity];
            this.symbols = new char[newCapacity];
            System.arraycopy(oldData, 0, this.targets, 0, this.size);
            System.arraycopy(oldData2, 0, this.symbols, 0, this.size);
        }
        this.targets[this.size] = target;
        this.symbols[this.size++] = symbol;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public void removeLast() {
        if (this.size > 0) {
            --this.size;
        }
    }

    public void remove(int index) {
        if (index == this.size - 1) {
            this.removeLast();
        } else {
            --this.size;
            this.targets[index] = this.targets[this.size];
            this.symbols[index] = this.symbols[this.size];
        }
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        StringBuffer Result = new StringBuffer();
        Result.append("* ");
        for (int i = 0; i < this.size; ++i) {
            Result.append("(");
            Result.append(this.symbols[i]);
            Result.append(",");
            Result.append(this.targets[i]);
            Result.append(") ");
        }
        return Result.toString();
    }
}

