/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.arraylist;

public final class StringArrayList {
    private transient String[] elementData;
    private int size;
    private int minCapacity;

    public StringArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new String[initialCapacity];
    }

    public StringArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            String[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new String[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String get(int index) {
        return this.elementData[index];
    }

    public void set(int index, String value) {
        this.elementData[index] = value;
    }

    public boolean add(String o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            String[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new String[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean add(String[] inputStrings) {
        int len = inputStrings.length;
        for (int i = 0; i < len; ++i) {
            this.add(inputStrings[i]);
        }
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public String removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public String remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        String temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }

    public String[] toArray() {
        int len = this.size();
        String[] out = new String[len];
        for (int i = 0; i < len; ++i) {
            out[i] = this.get(i);
        }
        return out;
    }
}

