/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.fileoperations;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import piskorski.util.functions.Files;

public class AddAttributes {
    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            System.out.println("Usage: AddAttributes InputFile OutputFile SpecialTable Encoding");
            System.exit(0);
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        String specialTable = args[2];
        String encoding = args[3];
        HashMap<Character, Character> charMapping = new HashMap<Character, Character>();
        String[] Input = Files.FileToStringArray(specialTable, encoding);
        int len = Input.length;
        for (int i = 0; i < len; ++i) {
            StringTokenizer sT = new StringTokenizer(Input[i], "\t");
            String f = sT.nextToken();
            String l = sT.nextToken();
            charMapping.put(new Character(f.charAt(0)), new Character(l.charAt(0)));
        }
        Input = Files.FileToStringArray(inputFileName, encoding);
        len = Input.length;
        String endOfLine = System.getProperty("line.separator");
        HashSet<String> entries = new HashSet<String>();
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int k = 0;
            String nextEntry = Input[i];
            int length = nextEntry.length();
            while (nextEntry.charAt(k) != '|' && nextEntry.charAt(k) != '\t' && ++k != length) {
            }
            String entry = nextEntry.substring(0, k).trim();
            int lenEntry = entry.length();
            if (entries.contains(entry)) continue;
            entries.add(entry);
            StringBuffer converted = new StringBuffer();
            for (k = 0; k < lenEntry; ++k) {
                char nChar = entry.charAt(k);
                Character c = new Character(nChar);
                if (charMapping.containsKey(c)) {
                    converted.append(((Character)charMapping.get(c)).charValue());
                    continue;
                }
                converted.append(nChar);
            }
            if (entries.contains(converted.toString())) continue;
            entries.add(converted.toString());
            System.out.println("NEW: " + converted.toString() + " vs. " + entry);
        }
        for (String next : entries) {
            output.append(next);
            output.append(" | ");
            output.append("GTYPE:person_position");
            output.append(" | ");
            output.append("GNUMBER:pl");
            output.append(" | ");
            output.append("SURFACE:");
            output.append(next);
            output.append(endOfLine);
        }
        Files.StringBufferToFile(outputFileName, output, "UTF-8");
    }
}

