/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.functions;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DataStream {
    public static void writeString(DataOutputStream d, String s) throws IOException {
        d.writeInt(s.length());
        for (int i = 0; i < s.length(); ++i) {
            d.writeChar(s.charAt(i));
        }
    }

    public static void writeStringArray(DataOutputStream d, String[] s) throws IOException {
        int len = s.length;
        d.writeInt(len);
        for (int i = 0; i < len; ++i) {
            DataStream.writeString(d, s[i]);
        }
    }

    public static void writeBooleanArray(DataOutputStream d, boolean[] b) throws IOException {
        int len = b.length;
        d.writeInt(len);
        for (int i = 0; i < len; ++i) {
            d.writeBoolean(b[i]);
        }
    }

    public static void writeCharArray(DataOutputStream d, char[] c) throws IOException {
        int len = c.length;
        d.writeInt(len);
        for (int i = 0; i < len; ++i) {
            d.writeChar(c[i]);
        }
    }

    public static void writeIntArray(DataOutputStream d, int[] a) throws IOException {
        int len = a.length;
        d.writeInt(len);
        for (int i = 0; i < len; ++i) {
            d.writeInt(a[i]);
        }
    }

    public static void writeByteArray(DataOutputStream d, byte[] a) throws IOException {
        int len = a.length;
        d.writeInt(len);
        for (int i = 0; i < len; ++i) {
            d.writeByte(a[i]);
        }
    }

    public static String readString(DataInputStream d) throws IOException {
        int len = d.readInt();
        char[] s = new char[len];
        for (int i = 0; i < len; ++i) {
            s[i] = d.readChar();
        }
        return new String(s);
    }

    public static String[] readStringArray(DataInputStream d) throws IOException {
        int len = d.readInt();
        String[] s = new String[len];
        for (int i = 0; i < len; ++i) {
            s[i] = DataStream.readString(d);
        }
        return s;
    }

    public static boolean[] readBooleanArray(DataInputStream d) throws IOException {
        int len = d.readInt();
        boolean[] b = new boolean[len];
        for (int i = 0; i < len; ++i) {
            b[i] = d.readBoolean();
        }
        return b;
    }

    public static char[] readCharArray(DataInputStream d) throws IOException {
        int len = d.readInt();
        char[] c = new char[len];
        for (int i = 0; i < len; ++i) {
            c[i] = d.readChar();
        }
        return c;
    }

    public static int[] readIntArray(DataInputStream d) throws IOException {
        int len = d.readInt();
        int[] a = new int[len];
        for (int i = 0; i < len; ++i) {
            a[i] = d.readInt();
        }
        return a;
    }

    public static byte[] readByteArray(DataInputStream d) throws IOException {
        int len = d.readInt();
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = d.readByte();
        }
        return a;
    }
}

