/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.functions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import piskorski.util.arraylist.StringArrayList;

public final class Files {
    protected static Logger logger = Logger.getLogger(Files.class);

    private static void exceptionMessage(String Message) throws IOException {
        logger.info((Object)Message);
        throw new IOException(Message);
    }

    public static boolean readFileNamesFromDirectory(String directory, ArrayList<File> files) {
        File Directory = new File(directory);
        try {
            if (!Directory.isDirectory()) {
                Files.exceptionMessage("InputDirectory: " + directory + " is not a directory.");
                return false;
            }
            if (!Directory.canRead()) {
                Files.exceptionMessage("InputDirectory: " + directory + " can not be read.");
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Problems while accessing: " + directory));
            return false;
        }
        File[] filesInDirectory = Directory.listFiles();
        int numFiles = filesInDirectory.length;
        for (int i = 0; i < numFiles; ++i) {
            if (!filesInDirectory[i].isFile() || !filesInDirectory[i].canRead()) continue;
            files.add(new File(filesInDirectory[i].getAbsolutePath()));
        }
        return true;
    }

    public static boolean readAllFileNamesFromDirectory(String directory, ArrayList<File> files) {
        File Directory = new File(directory);
        try {
            if (!Directory.isDirectory()) {
                Files.exceptionMessage("InputDirectory: " + directory + " is not a directory.");
                return false;
            }
            if (!Directory.canRead()) {
                Files.exceptionMessage("InputDirectory: " + directory + " can not be read.");
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Problems while accessing: " + directory));
            return false;
        }
        File[] filesInDirectory = Directory.listFiles();
        int numFiles = filesInDirectory.length;
        for (int i = 0; i < numFiles; ++i) {
            if (filesInDirectory[i].isFile() && filesInDirectory[i].canRead()) {
                files.add(new File(filesInDirectory[i].getAbsolutePath()));
            }
            if (!filesInDirectory[i].isDirectory()) continue;
            Files.readAllFileNamesFromDirectory(filesInDirectory[i].getAbsolutePath(), files);
        }
        return true;
    }

    public static ArrayList<String> getStringsFromResource(String from) {
        ArrayList<String> entries = new ArrayList<String>();
        try {
            String line;
            Thread.currentThread().getContextClassLoader();
            URL pURL = ClassLoader.getSystemResource("from");
            if (pURL == null) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(pURL.openStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                entries.add(line);
            }
            in.close();
        }
        catch (IOException err) {
            return null;
        }
        return entries;
    }

    public static String[] FileToStringArray(String fileName, String inputCharacterSet) throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), inputCharacterSet));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                data.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Files.exceptionMessage("File Not Found:" + fileName);
        }
        catch (IOException e) {
            Files.exceptionMessage("IO Exception while processing file: " + fileName);
        }
        String[] Result = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            Result[i] = (String)data.get(i);
        }
        return Result;
    }

    public static HashSet<String> FileToHashSet(String fileName, String inputCharacterSet) throws IOException {
        HashSet<String> data = new HashSet<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), inputCharacterSet));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                data.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Files.exceptionMessage("File Not Found:" + fileName);
        }
        catch (IOException e) {
            Files.exceptionMessage("IO Exception while processing file: " + fileName);
        }
        return data;
    }

    public static HashMap<String, String> FileToHashMap(String fileName, String inputCharacterSet) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), inputCharacterSet));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                StringTokenizer st = new StringTokenizer(line, "\t");
                if (st.countTokens() == 2) {
                    data.put(st.nextToken(), st.nextToken());
                    continue;
                }
                System.out.println("WRONG LINE: " + line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Files.exceptionMessage("File Not Found:" + fileName);
        }
        catch (IOException e) {
            Files.exceptionMessage("IO Exception while processing file: " + fileName);
        }
        return data;
    }

    public static String[] FileToStringArray(String fileName, char specialSymbol, String inputCharacterSet) throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), inputCharacterSet));
            in.mark(1);
            int FirstSymbol = in.read();
            if (FirstSymbol != 65279) {
                in.reset();
            }
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == specialSymbol) continue;
                data.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Files.exceptionMessage("File Not Found:" + fileName);
        }
        catch (IOException e) {
            Files.exceptionMessage("IO Exception while processing file: " + fileName);
        }
        String[] Result = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            Result[i] = (String)data.get(i);
        }
        return Result;
    }

    public static String[] FileToStringArrayAndSort(String fileName, String inputCharacterSet) throws IOException {
        Object[] data = Files.FileToStringArray(fileName, inputCharacterSet);
        if (data != null) {
            Arrays.sort(data);
        }
        return data;
    }

    public static boolean StringBufferToFile(String fileName, StringBuffer sB, String encoding) throws IOException {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding));
            out.write(sB.toString());
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean StringArrayListToFile(String fileName, StringArrayList inputList, String encoding) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding));
            int len = inputList.size();
            for (int i = 0; i < len; ++i) {
                out.write(inputList.get(i));
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean HashMapToFile(String fileName, HashMap<String, Integer> inputMap, String encoding) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding));
            Set<String> keys = inputMap.keySet();
            for (String s : keys) {
                out.write(s);
                out.write("\t");
                String freq = Integer.toString(inputMap.get(s));
                out.write(freq);
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void readLinesFromBuffer(StringArrayList list, BufferedReader reader, int max) throws IOException {
        try {
            String line;
            for (int count = 0; count < max && (line = reader.readLine()) != null; ++count) {
                list.add(line);
            }
        }
        catch (Exception e) {
            Files.exceptionMessage("IO Exception while reading from BufferedReader");
        }
    }

    public static void readMarkedStringsFromBuffer(StringArrayList list, BufferedReader reader, int max, char separator) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try {
            for (int count = 0; count < max; ++count) {
                int nextChar;
                buffer.setLength(0);
                while ((nextChar = reader.read()) != -1) {
                    buffer.append((char)nextChar);
                    if (nextChar != separator) continue;
                }
                if (buffer.length() > 0) {
                    list.add(buffer.toString());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Files.exceptionMessage("IO Exception while reading from BufferedReader");
        }
    }

    public static void readMarkedStringsFromBufferWithoutSeparators(StringArrayList list, BufferedReader reader, int max, char separator) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try {
            for (int count = 0; count < max; ++count) {
                int nextChar;
                buffer.setLength(0);
                while ((nextChar = reader.read()) != -1 && nextChar != separator) {
                    buffer.append((char)nextChar);
                }
                if (buffer.length() > 0) {
                    list.add(buffer.toString());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Files.exceptionMessage("IO Exception while reading from BufferedReader");
        }
    }

    public static void readStringFromBuffer(BufferedReader reader, StringBuffer buffer, char separator) throws IOException {
        try {
            int nextChar;
            while ((nextChar = reader.read()) != -1) {
                buffer.append((char)nextChar);
                if (nextChar != separator) continue;
                break;
            }
        }
        catch (Exception e) {
            Files.exceptionMessage("IO Exception while reading from BufferedReader");
        }
    }

    public static void writeLinesToBuffer(StringArrayList list, BufferedWriter writer, int max) throws IOException {
        try {
            String line;
            for (int i = 0; i < max && (line = list.get(i)) != null; ++i) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (Exception e) {
            Files.exceptionMessage("IO Exception while writing to BufferedWriter");
        }
    }

    public static void writeStringsToBuffer(StringArrayList list, BufferedWriter writer, int max) throws IOException {
        try {
            String line;
            for (int i = 0; i < max && (line = list.get(i)) != null; ++i) {
                writer.write(line);
            }
        }
        catch (Exception e) {
            Files.exceptionMessage("IO Exception while writing to BufferedWriter");
        }
    }

    public static boolean deleteFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        boolean access = true;
        try {
            File F = new File(fileName);
            if (F.exists()) {
                if (!F.canWrite()) {
                    access = false;
                } else if (!F.delete()) {
                    access = false;
                }
            }
        }
        catch (Exception e) {
            access = false;
        }
        return access;
    }

    public static String FileToString(String fileName, String charSet) throws IOException {
        String result = null;
        byte[] byteBuffer = null;
        try {
            File inName = new File(fileName);
            long len = inName.length();
            RandomAccessFile in = new RandomAccessFile(inName, "r");
            if (charSet.compareTo("UTF-8") == 0) {
                byte[] eB = new byte[3];
                in.read(eB);
                int eB0 = eB[0] & 0xFF;
                int eB1 = eB[1] & 0xFF;
                int eB2 = eB[2] & 0xFF;
                if (eB0 == 239 && eB1 == 187 && eB2 == 191) {
                    len -= 3L;
                } else {
                    in.seek(0L);
                }
            }
            byteBuffer = new byte[(int)len];
            in.read(byteBuffer, 0, (int)len);
            in.close();
        }
        catch (FileNotFoundException e) {
            Files.exceptionMessage("File Not Found: " + fileName);
        }
        catch (IOException e) {
            Files.exceptionMessage("IO Exception while processing: " + fileName);
        }
        try {
            result = new String(byteBuffer, charSet);
        }
        catch (Exception e) {
            Files.exceptionMessage("Unsupported Character Encoding: " + charSet);
        }
        return result;
    }

    public static String FileToStringWithoutExceptions(String fileName, String charSet) {
        String result = null;
        byte[] byteBuffer = null;
        try {
            File inName = new File(fileName);
            long len = inName.length();
            RandomAccessFile in = new RandomAccessFile(inName, "r");
            if (charSet.compareTo("UTF-8") == 0) {
                byte[] eB = new byte[3];
                in.read(eB);
                int eB0 = eB[0] & 0xFF;
                int eB1 = eB[1] & 0xFF;
                int eB2 = eB[2] & 0xFF;
                if (eB0 == 239 && eB1 == 187 && eB2 == 191) {
                    len -= 3L;
                } else {
                    in.seek(0L);
                }
            }
            byteBuffer = new byte[(int)len];
            in.read(byteBuffer, 0, (int)len);
            in.close();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        try {
            result = new String(byteBuffer, charSet);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static boolean writeByteArrayToFile(byte[] fill, String file) {
        File FileName = new File(file);
        if (file == null) {
            return false;
        }
        if (fill == null) {
            return false;
        }
        if (fill.length == 0) {
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(FileName);
            DataOutputStream s = new DataOutputStream(out);
            s.write(fill, 0, fill.length);
            s.flush();
            s.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean readByteArrayFromFile(byte[] randomAccess, String file) {
        File FileName = new File(file);
        int maxLen = (int)FileName.length();
        try {
            FileInputStream out = new FileInputStream(FileName);
            DataInputStream s = new DataInputStream(out);
            s.readFully(randomAccess, 0, maxLen);
            s.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

