/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.functions;

public final class Memory {
    private static final short BYTE_MASK = 255;

    public static String IntToBin(int b) {
        StringBuffer S = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            if ((b & 1) != 0) {
                S.append("1");
            } else {
                S.append("0");
            }
            b >>>= 1;
        }
        return S.toString();
    }

    public static String ByteToBin(byte b) {
        StringBuffer S = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            if ((b & 1) != 0) {
                S.append("1");
            } else {
                S.append("0");
            }
            b = (byte)(b >>> 1);
        }
        return S.toString();
    }

    public static int convertByteArrayToInt(byte[] byteArray, int start, int len) {
        int result = 0;
        for (int i = 0; i < len; ++i) {
            int offset = (len - 1 - i) * 8;
            result |= (byteArray[start + i] & 0xFF) << offset;
        }
        return result;
    }

    public static void convertIntToByteArray(int integer, byte[] byteArray, int start, int len) {
        for (int i = 0; i < len; ++i) {
            int offset = (len - 1 - i) * 8;
            byteArray[start + i] = (byte)(integer >>> offset & 0xFF);
        }
    }

    public static int howManyBits(int num) {
        int result = 0;
        if (num == 0) {
            return 1;
        }
        while (num > 0) {
            num >>>= 1;
            ++result;
        }
        return result;
    }

    public static int howManyBytes(int num) {
        int result = 0;
        if (num == 0) {
            return 1;
        }
        while (num > 0) {
            num >>>= 8;
            ++result;
        }
        return result;
    }
}

