/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import java.util.StringTokenizer;

public abstract class AbstractDistanceMetric {
    protected String description = "";
    public static final double UNDEF_DIST = -1.0;

    public abstract String getName();

    public void setDescription(String d) {
        this.description = d;
    }

    public String getDesription() {
        return this.description;
    }

    public final float[] computeDistanceSet(String comparator, String[] inputStrings) {
        int size = inputStrings.length;
        float[] results = new float[size];
        for (int strNum = 0; strNum < size; ++strNum) {
            results[strNum] = this.getDistance(comparator, inputStrings[strNum]);
        }
        return results;
    }

    public abstract float getDistance(String var1, String var2);

    public static AbstractDistanceMetric getInstance(String type) {
        AbstractDistanceMetric metric;
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass("piskorski.util.strings.distmetrics." + type);
            metric = (AbstractDistanceMetric)c.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        return metric;
    }

    public static AbstractDistanceMetric getInstance(String type, String configuration) {
        AbstractDistanceMetric metric;
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass("piskorski.util.strings.distmetrics." + type);
            metric = (AbstractDistanceMetric)c.newInstance();
            if (!metric.setProperties(configuration)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return metric;
    }

    public abstract void setProperties(Properties var1);

    public boolean setProperties(String configuration) {
        if (configuration == null) {
            return false;
        }
        StringTokenizer sT = new StringTokenizer(configuration, " \t:|", false);
        int numTokens = sT.countTokens();
        if (numTokens % 2 != 0) {
            return false;
        }
        Properties newProps = new Properties();
        while (sT.hasMoreElements()) {
            String attribute = sT.nextToken();
            String value = sT.nextToken();
            newProps.setProperty(attribute, value);
        }
        this.setProperties(newProps);
        return true;
    }

    public abstract String getConfiguration();
}

