/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Arrays;
import java.util.Properties;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class Jaro
extends AbstractDistanceMetric {
    private static StringBuffer[] getCommonCharacters(String s1, String s2, int dist) {
        int i;
        int lenS1 = s1.length();
        int lenS2 = s2.length();
        StringBuffer[] commonChars = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        boolean[] marked = new boolean[lenS2];
        Arrays.fill(marked, false);
        block0: for (i = 0; i < lenS1; ++i) {
            char ch = s1.charAt(i);
            for (int j = Math.max(0, i - dist); j < Math.min(i + dist + 1, lenS2); ++j) {
                if (marked[j] || s2.charAt(j) != ch) continue;
                commonChars[0].append(ch);
                marked[j] = true;
                continue block0;
            }
        }
        for (i = 0; i < lenS2; ++i) {
            if (!marked[i]) continue;
            commonChars[1].append(s2.charAt(i));
        }
        return commonChars;
    }

    @Override
    public float getDistance(String s1, String s2) {
        int lenS2;
        int lenS1 = s1.length();
        int dist = Math.max(Math.max(lenS1, lenS2 = s2.length()) / 2, 1) - 1;
        StringBuffer[] commonChars = Jaro.getCommonCharacters(s1, s2, dist);
        int lenCommon = commonChars[0].length();
        if (lenCommon == 0) {
            return 1.0f;
        }
        int transpositions = 0;
        for (int i = 0; i < lenCommon; ++i) {
            if (commonChars[0].charAt(i) == commonChars[1].charAt(i)) continue;
            ++transpositions;
        }
        return 1.0f - ((float)lenCommon / (float)lenS1 + (float)lenCommon / (float)lenS2 + (float)(lenCommon - (transpositions /= 2)) / (float)lenCommon) / 3.0f;
    }

    @Override
    public String getName() {
        return "Jaro";
    }

    @Override
    public void setProperties(Properties props) {
    }

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": no parameters";
    }
}

