/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import piskorski.util.strings.distmetrics.AbstractSubstitutionCost;

public class PolishSubstCostSmithWatermanAffineGaps
extends AbstractSubstitutionCost {
    private static final int EXACT_MATCH_SCORE = 5;
    private static final int APPROX_MATCH_SCORE = 3;
    private static final int MISMATCH_SCORE = -3;
    private char[][] approxChars;

    private void constructApproxCharsTables() {
        int len = 8;
        this.approxChars = new char[len][];
        this.approxChars[0] = new char[9];
        this.approxChars[0][0] = 97;
        this.approxChars[0][1] = 101;
        this.approxChars[0][2] = 105;
        this.approxChars[0][3] = 111;
        this.approxChars[0][4] = 117;
        this.approxChars[0][5] = 261;
        this.approxChars[0][6] = 281;
        this.approxChars[0][7] = 243;
        this.approxChars[0][8] = 121;
        this.approxChars[1] = new char[2];
        this.approxChars[1][0] = 99;
        this.approxChars[1][1] = 263;
        this.approxChars[2] = new char[2];
        this.approxChars[2][0] = 115;
        this.approxChars[2][1] = 347;
        this.approxChars[3] = new char[2];
        this.approxChars[3][0] = 108;
        this.approxChars[3][1] = 322;
        this.approxChars[4] = new char[2];
        this.approxChars[4][0] = 110;
        this.approxChars[4][1] = 324;
        this.approxChars[5] = new char[2];
        this.approxChars[5][0] = 107;
        this.approxChars[5][1] = 99;
        this.approxChars[6] = new char[2];
        this.approxChars[6][0] = 116;
        this.approxChars[6][1] = 99;
        this.approxChars[7] = new char[2];
        this.approxChars[7][0] = 44;
        this.approxChars[7][1] = 46;
    }

    public PolishSubstCostSmithWatermanAffineGaps() {
        this.constructApproxCharsTables();
    }

    @Override
    public float getCost(String s1, int i, String s2, int j) {
        char s2c;
        int s1Len = s1.length();
        int s2Len = s2.length();
        if (s1Len <= i || i < 0) {
            return -3.0f;
        }
        if (s2Len <= j || j < 0) {
            return -3.0f;
        }
        char s1c = s1.charAt(i);
        if (s1c == (s2c = s2.charAt(j))) {
            return 5.0f;
        }
        int len = this.approxChars.length;
        for (int k = 0; k < len; ++k) {
            boolean s1cFound = false;
            boolean s2cFound = false;
            int numOfChars = this.approxChars[k].length;
            for (int l = 0; l < numOfChars; ++l) {
                if (this.approxChars[k][l] == s1c) {
                    s1cFound = true;
                }
                if (this.approxChars[k][l] == s2c) {
                    s2cFound = true;
                }
                if (!s1cFound || !s2cFound) continue;
                return 3.0f;
            }
        }
        return -3.0f;
    }

    @Override
    public float getMaxCost() {
        return 5.0f;
    }

    @Override
    public float getMinCost() {
        return -3.0f;
    }

    @Override
    public String getName() {
        return "PolishSubstCostSmithWatermanAffineGaps";
    }
}

