/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import piskorski.util.strings.distmetrics.AbstractAffineGapCost;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;
import piskorski.util.strings.distmetrics.AbstractSubstitutionCost;

public class SmithWatermanWithAffineGaps
extends AbstractDistanceMetric {
    private int windowSize = 100;
    private AbstractSubstitutionCost substCostFunc = AbstractSubstitutionCost.getInstance("DefaultSubstCostSmithWatermanAffineGaps");
    private AbstractAffineGapCost gGapFunc = AbstractAffineGapCost.getInstance("DefaultAffineGapCostSmithWaterman");

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": GAPCOSTFUNCTION:" + this.gGapFunc.getName() + " SUBSTCOSTFUNCTION:" + this.substCostFunc.getName() + " WINDOWSIZE:" + this.windowSize;
    }

    private float getSmithWatermanWithAffineGapsScore(String s, String t) {
        int j;
        int k;
        int windowStart;
        float maxGapCost;
        float cost;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n][m];
        float maxSoFar = 0.0f;
        for (i = 0; i < n; ++i) {
            cost = this.substCostFunc.getCost(s, i, t, 0);
            if (i == 0) {
                d[0][0] = Math.max(0.0f, cost);
            } else {
                maxGapCost = 0.0f;
                windowStart = i - this.windowSize;
                if (windowStart < 1) {
                    windowStart = 1;
                }
                for (k = windowStart; k < i; ++k) {
                    maxGapCost = Math.max(maxGapCost, d[i - k][0] - this.gGapFunc.getCost(s, i - k, i));
                }
                d[i][0] = Math.max(Math.max(0.0f, maxGapCost), cost);
            }
            if (!(d[i][0] > maxSoFar)) continue;
            maxSoFar = d[i][0];
        }
        for (j = 0; j < m; ++j) {
            cost = this.substCostFunc.getCost(s, 0, t, j);
            if (j == 0) {
                d[0][0] = Math.max(0.0f, cost);
            } else {
                maxGapCost = 0.0f;
                windowStart = j - this.windowSize;
                if (windowStart < 1) {
                    windowStart = 1;
                }
                for (k = windowStart; k < j; ++k) {
                    maxGapCost = Math.max(maxGapCost, d[0][j - k] - this.gGapFunc.getCost(t, j - k, j));
                }
                d[0][j] = Math.max(Math.max(0.0f, maxGapCost), cost);
            }
            if (!(d[0][j] > maxSoFar)) continue;
            maxSoFar = d[0][j];
        }
        for (i = 1; i < n; ++i) {
            for (j = 1; j < m; ++j) {
                int k2;
                cost = this.substCostFunc.getCost(s, i, t, j);
                float maxGapCost1 = 0.0f;
                float maxGapCost2 = 0.0f;
                int windowStart2 = i - this.windowSize;
                if (windowStart2 < 1) {
                    windowStart2 = 1;
                }
                for (k2 = windowStart2; k2 < i; ++k2) {
                    maxGapCost1 = Math.max(maxGapCost1, d[i - k2][j] - this.gGapFunc.getCost(s, i - k2, i));
                }
                windowStart2 = j - this.windowSize;
                if (windowStart2 < 1) {
                    windowStart2 = 1;
                }
                for (k2 = windowStart2; k2 < j; ++k2) {
                    maxGapCost2 = Math.max(maxGapCost2, d[i][j - k2] - this.gGapFunc.getCost(t, j - k2, j));
                }
                d[i][j] = Math.max(Math.max(0.0f, maxGapCost1), Math.max(maxGapCost2, d[i - 1][j - 1] + cost));
                if (!(d[i][j] > maxSoFar)) continue;
                maxSoFar = d[i][j];
            }
        }
        return maxSoFar;
    }

    @Override
    public float getDistance(String s1, String s2) {
        float smithWatermanGotoh = this.getSmithWatermanWithAffineGapsScore(s1, s2);
        float maxValue = (float)(s1.length() + s2.length()) * 0.5f;
        maxValue = this.substCostFunc.getMaxCost() > -this.gGapFunc.getMaxCost() ? (maxValue *= this.substCostFunc.getMaxCost()) : (maxValue *= -this.gGapFunc.getMaxCost());
        return maxValue == 0.0f ? 0.0f : 1.0f - smithWatermanGotoh / maxValue;
    }

    @Override
    public String getName() {
        return "SmithWatermanWithAffineGaps";
    }

    @Override
    public void setProperties(Properties props) {
        String windowSize = props.getProperty("WINDOWSIZE");
        String substCostFunction = props.getProperty("SUBSTCOSTFUNCTION");
        String gapCostFunction = props.getProperty("GAPCOSTFUNCTION");
        if (windowSize != null) {
            try {
                this.windowSize = Integer.parseInt(windowSize);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (substCostFunction != null) {
            try {
                AbstractSubstitutionCost newSubstCost = AbstractSubstitutionCost.getInstance(substCostFunction);
                if (newSubstCost != null) {
                    this.substCostFunc = newSubstCost;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (gapCostFunction != null) {
            try {
                AbstractAffineGapCost newGapCost = AbstractAffineGapCost.getInstance(gapCostFunction);
                if (newGapCost != null) {
                    this.gGapFunc = newGapCost;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

