/*
 * Decompiled with CFR 0.152.
 */
package piskorski.util.strings.distmetrics;

import java.util.Properties;
import piskorski.util.strings.StringFunctions;
import piskorski.util.strings.distmetrics.AbstractDistanceMetric;

public class WeightedLongestCommonSubstrings
extends AbstractDistanceMetric {
    private int minLenOfLCS = 3;

    @Override
    public String getConfiguration() {
        return this.getClass().getName() + ": MINLEN:" + this.minLenOfLCS;
    }

    private float computeLongestCommonSubstrings(String s1, String s2) {
        int lenS1 = s1.length();
        int lenS2 = s2.length();
        if (lenS1 < this.minLenOfLCS || lenS2 < this.minLenOfLCS) {
            return 0.0f;
        }
        String lcs = StringFunctions.LongestCommonSubstring(s1, s2);
        int lenLcs = lcs.length();
        if (lenLcs < this.minLenOfLCS) {
            return 0.0f;
        }
        int start1 = s1.indexOf(lcs);
        String newS1 = s1.substring(0, start1) + s1.substring(start1 + lenLcs);
        int start2 = s2.indexOf(lcs);
        String newS2 = s2.substring(0, start2) + s2.substring(start2 + lenLcs);
        float weight = 1.0f;
        int count1 = 0;
        int count2 = 0;
        if (s1.charAt(start1) != ' ' && start1 > 0) {
            while (start1 > 0) {
                if (s1.charAt(--start1) == ' ') continue;
                ++count1;
            }
        }
        if (s2.charAt(start2) != ' ' && start2 > 0) {
            while (start2 > 0) {
                if (s2.charAt(--start2) == ' ') continue;
                ++count2;
            }
        }
        if (count1 > 0 || count2 > 0) {
            int window = lenLcs + Math.max(count1, count2);
            weight = (float)(window - Math.max(4, Math.max(count1, count2))) / (float)window;
        }
        int whitespaces = 0;
        for (int i = 0; i < lenLcs; ++i) {
            if (lcs.charAt(i) != ' ') continue;
            ++whitespaces;
        }
        return (float)(lenLcs - whitespaces) * weight + this.computeLongestCommonSubstrings(newS1, newS2);
    }

    @Override
    public float getDistance(String s1, String s2) {
        int lenS2;
        float lcs = this.computeLongestCommonSubstrings(s1, s2);
        int lenS1 = s1.length();
        int maxLen = lenS1 > (lenS2 = s2.length()) ? lenS1 : lenS2;
        return 1.0f - lcs / (float)maxLen;
    }

    @Override
    public String getName() {
        return "WightedLongestCommonSubstrings";
    }

    @Override
    public void setProperties(Properties props) {
        String minLen = props.getProperty("MINLEN");
        if (minLen != null) {
            try {
                int minLenVal = Integer.parseInt(minLen);
                if (minLenVal > 0) {
                    this.minLenOfLCS = minLenVal;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

