/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis;

import it.jrc.osint.analysis.AnalysisPreferences;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.internal.AnalysisServiceImpl;
import it.jrc.osint.extract.ExtractPlugin;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class AnalysisPlugin
extends Plugin {
    public static final String PLUGIN_ID = "it.jrc.osint.analysis";
    private static AnalysisPlugin plugin;
    private AnalysisService analysisService;
    private EventBroker eventBroker;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.eventBroker = new EventBroker(bundleContext);
        this.analysisService = new AnalysisServiceImpl(this.eventBroker, AnalysisPlugin.getWorkspaceService());
        this.initPreferences();
    }

    private void initPreferences() {
        AnalysisPreferences aPrefs = new AnalysisPreferences(PLUGIN_ID);
        aPrefs.init();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.eventBroker != null) {
            this.eventBroker.stop();
        }
        this.analysisService = null;
        plugin = null;
    }

    public static AnalysisPlugin getPlugin() {
        return plugin;
    }

    public static AnalysisService getAnalysisService() {
        return AnalysisPlugin.getPlugin().analysisService;
    }

    public static WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    public static ExtractionService getExtractionService() {
        return ExtractPlugin.getExtractionService();
    }
}

