/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.internal;

import gnu.trove.set.hash.THashSet;
import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisPlugin;
import it.jrc.osint.analysis.AnalysisPreferences;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.AnalysisServiceEvent;
import it.jrc.osint.analysis.ElementParsingResult;
import it.jrc.osint.analysis.ErrorConditions;
import it.jrc.osint.analysis.graph.EntityEntityEdge;
import it.jrc.osint.analysis.internal.AnalysisDatamodelImpl;
import it.jrc.osint.analysis.internal.AnalysisServiceEventImpl;
import it.jrc.osint.analysis.parser.ElementParsingResultImpl;
import it.jrc.osint.analysis.parser.EntityElementParser;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.analysis.relation.DocumentEntityRelationImpl;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.util.DebugUtil;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.time.StopWatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class AnalysisServiceImpl
implements AnalysisService {
    private static final Logger log = LogManager.getLogger((String)AnalysisServiceImpl.class.getName());
    private Map<ResourceId, AnalysisDatamodel> datamodelMap = new HashMap<ResourceId, AnalysisDatamodel>();
    private TopicEventListener topicEventListener = new WorkspaceTopicEventListener();
    private EventBroker eventBroker;
    private WorkspaceService ws;

    public AnalysisServiceImpl(EventBroker eventBroker, WorkspaceService ws) {
        this.eventBroker = eventBroker;
        this.eventBroker.register(new String[]{"osint/workspace/projectDeleted", "osint/workspace/metaDataChanged", "osint/workspace/resourceDeleted"}, this.topicEventListener);
        this.ws = ws;
    }

    @Override
    public void clearDatamodels() {
        this.datamodelMap.clear();
    }

    @Override
    public synchronized AnalysisDatamodel getAnalysisDatamodel(ResourceId projectId, boolean reload) {
        if (!this.ws.hasCaseProject(projectId)) {
            return AnalysisDatamodelImpl.NULL_DATAMODEL;
        }
        if (this.datamodelMap.containsKey(projectId)) {
            if (reload) {
                this.datamodelMap.remove(projectId);
            } else {
                return this.datamodelMap.get(projectId);
            }
        }
        CountDownLatch doneSignal = new CountDownLatch(1);
        LoadAnalysisDatamodelJob job = new LoadAnalysisDatamodelJob("Loading analysis data model", projectId, doneSignal);
        job.setUser(true);
        job.schedule();
        try {
            doneSignal.await();
            AnalysisDatamodel resultModel = job.getDatamodel();
            this.datamodelMap.put(projectId, resultModel);
            AnalysisDatamodel analysisDatamodel = resultModel;
            return analysisDatamodel;
        }
        catch (InterruptedException e) {
            log.error("Loading analysis data model interrupted", (Throwable)e);
            AnalysisDatamodel analysisDatamodel = AnalysisDatamodelImpl.NULL_DATAMODEL;
            return analysisDatamodel;
        }
        finally {
            doneSignal.countDown();
        }
    }

    @Override
    public Set<DocumentEntityRelation> getAllDocumentEntityRelations(ResourceId projectId) {
        return this.performLoadDocumentEntityRelations(projectId, null);
    }

    @Override
    public Set<DocumentEntityRelation> getDocumentEntityRelations(ResourceId docId) {
        WorkspaceService ws = AnalysisPlugin.getWorkspaceService();
        CaseProject cp = ws.getCaseProjectByDocumentId(docId);
        DocumentMetaItem metaItem = cp.getMetaItem(docId);
        return this.parseDocumentEntityRelations(metaItem);
    }

    private void fireAnalysisServiceEvent(AnalysisServiceEvent event) {
        this.eventBroker.postEvent((SystemEvent)event);
    }

    private void performLoadDatamodel(ResourceId projectId, AnalysisDatamodelImpl ad, IProgressMonitor monitor) {
        CaseProject cp = this.ws.getCaseProjectByProjectId(projectId);
        Set docIds = cp.getDocumentIds();
        monitor.beginTask("Loading document meta data", docIds.size());
        try {
            StopWatch sw = null;
            if (DebugUtil.inDebugMode()) {
                sw = new StopWatch();
                sw.start();
            }
            for (ResourceId docId : docIds) {
                DocumentMetaItem docMetaItem = cp.getMetaItem(docId);
                try {
                    try {
                        Set<DocumentEntityRelation> parsedRelations = this.parseDocumentEntityRelations(docMetaItem);
                        ad.addDocumentEntityRelations(docId, parsedRelations);
                    }
                    catch (Throwable t) {
                        RepositoryMetaData rmd = new RepositoryMetaData(docMetaItem);
                        log.error("Failed to parse entity relations of document at " + rmd.getLinkedFile() + " with id " + docId);
                        monitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    monitor.worked(1);
                    throw throwable;
                }
                monitor.worked(1);
            }
            if (DebugUtil.inDebugMode()) {
                sw.stop();
                log.debug("Loaded datamodel in " + sw.getTime() + "ms");
            }
        }
        finally {
            monitor.done();
        }
    }

    private Set<DocumentEntityRelation> performLoadDocumentEntityRelations(ResourceId projectId, IProgressMonitor monitor) {
        CaseProject cp = this.ws.getCaseProjectByProjectId(projectId);
        Set docIds = cp.getDocumentIds();
        HashSet<DocumentEntityRelation> docEntityRelations = new HashSet<DocumentEntityRelation>();
        if (monitor != null) {
            monitor.beginTask("Loading document entity relations", docIds.size());
        }
        try {
            for (ResourceId docId : docIds) {
                DocumentMetaItem docMetaItem = cp.getMetaItem(docId);
                Set<DocumentEntityRelation> parsedRelations = this.parseDocumentEntityRelations(docMetaItem);
                docEntityRelations.addAll(parsedRelations);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            HashSet<DocumentEntityRelation> hashSet = docEntityRelations;
            return hashSet;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private Set<DocumentEntityRelation> parseDocumentEntityRelations(DocumentMetaItem metaItem) {
        try {
            RepositoryMetaData rmd = new RepositoryMetaData(metaItem);
            ResourceId resourceId = rmd.getResourceId();
            Set<DocumentEntityRelation> parsedRelations = this.parseDocumentEntities(metaItem, resourceId);
            return parsedRelations;
        }
        catch (Throwable t) {
            log.error("Failed to parse entities of document", t);
            return Collections.emptySet();
        }
    }

    private Set<DocumentEntityRelation> parseDocumentEntities(DocumentMetaItem metaItem, ResourceId docId) {
        HashMap<String, DocumentEntityRelationImpl> resultMap = new HashMap<String, DocumentEntityRelationImpl>();
        if (metaItem == null) {
            log.warn("Cannot load entities from null metaItem");
            return Collections.emptySet();
        }
        RSSItem item = metaItem.getItem();
        ArrayList metadata = item.getElements();
        if (metadata != null) {
            for (SimpleElement se : metadata) {
                ElementParsingResult epr = null;
                try {
                    epr = this.parseSimpleElementEntity(se);
                    if (!epr.getStatus().isOK()) continue;
                    DocumentEntityRelationImpl der = new DocumentEntityRelationImpl(epr.getEntity(), docId.toString(), epr.getTextPositions());
                    if (resultMap.containsKey(((Object)der).toString())) {
                        DocumentEntityRelation existingRelation = (DocumentEntityRelation)resultMap.get(((Object)der).toString());
                        existingRelation.addTextPositions(epr.getTextPositions());
                        continue;
                    }
                    resultMap.put(((Object)der).toString(), der);
                }
                catch (Throwable t) {
                    log.error("Failed to parse SimpleElement. " + se.getName() + " for rid: " + docId + " and title: " + metaItem.getTitle(), t);
                }
            }
        }
        THashSet resultSet = new THashSet();
        resultSet.addAll(resultMap.values());
        return resultSet;
    }

    private ElementParsingResult parseSimpleElementEntity(SimpleElement se) {
        ElementParsingResultImpl epr = new ElementParsingResultImpl();
        EntityElementParser eep = new EntityElementParser();
        try {
            return eep.parseElement(se, new ElementParsingResultImpl());
        }
        catch (Throwable t) {
            OperationStatus os = new OperationStatus(ErrorConditions.getErrorConditions().getErrorCondition(ErrorConditions.ENTITY_ELEMENT_PARSING_FAILED, t));
            epr.setStatus(os);
            return epr;
        }
    }

    @Override
    public AnalysisPreferences getPreferences() {
        return new AnalysisPreferences("it.jrc.osint.analysis");
    }

    @Override
    public void computeEntityEntityRelationships(ResourceId projectId, Set<Entity> viewGraphVertices, Entity newVertex) {
        AnalysisDatamodel ad = this.getAnalysisDatamodel(projectId, false);
        if (ad.isNull()) {
            return;
        }
        AnalysisPreferences ap = this.getPreferences();
        int maxHops = ap.getAddEntityShortestPath();
        CalculateEntityEntityRelationshipsJob job = new CalculateEntityEntityRelationshipsJob(ad, viewGraphVertices, newVertex, maxHops);
        job.schedule();
    }

    private class CalculateEntityEntityRelationshipsJob
    extends Job {
        private AnalysisDatamodel ad;
        private Set<Entity> viewGraphVertices;
        private Entity newVertex;
        private int maxHops;

        public CalculateEntityEntityRelationshipsJob(AnalysisDatamodel ad, Set<Entity> viewGraphVertices, Entity newVertex, int maxHops) {
            super("Calculating entity relationships");
            this.ad = ad;
            this.viewGraphVertices = viewGraphVertices;
            this.newVertex = newVertex;
            this.maxHops = maxHops;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.viewGraphVertices.isEmpty()) {
                return this.calculateBellmanFord(monitor);
            }
            return Status.OK_STATUS;
        }

        private IStatus calculateBellmanFord(IProgressMonitor monitor) {
            monitor.beginTask("Calculating entity relationships", this.viewGraphVertices.size());
            try {
                try {
                    Set<EntityEntityEdge> edgesToAdd = this.ad.calculateShortestPathsBellmannFord(this.viewGraphVertices, this.newVertex, this.maxHops, monitor);
                    this.fireEvent(edgesToAdd);
                }
                catch (Throwable t) {
                    log.error("Failed to calculate entity relationships", t);
                    Status status = new Status(4, "it.jrc.osint.analysis", "Failed to calculate entity relationships", t);
                    monitor.done();
                    return status;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        private void fireEvent(Set<EntityEntityEdge> edgesToAdd) {
            if (!edgesToAdd.isEmpty()) {
                AnalysisServiceEventImpl ase = new AnalysisServiceEventImpl("osint/analysis/entityRelationshipsCalculated", this.ad.getProjectId());
                ase.setEntityEntityEdges(edgesToAdd);
                AnalysisServiceImpl.this.fireAnalysisServiceEvent(ase);
            }
        }
    }

    private class LoadAnalysisDatamodelJob
    extends Job {
        private ResourceId projectId;
        private AnalysisDatamodelImpl ad;
        private CountDownLatch doneSignal;

        public LoadAnalysisDatamodelJob(String name, ResourceId projectId, CountDownLatch doneSignal) {
            super(name);
            this.projectId = projectId;
            this.ad = new AnalysisDatamodelImpl(projectId);
            this.doneSignal = doneSignal;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                AnalysisServiceImpl.this.performLoadDatamodel(this.projectId, this.ad, monitor);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable t) {
                log.error("Failed to aggregate datamodel", t);
                Status status = new Status(4, "it.jrc.osint.analysis", "Failed to aggregate datamodel", t);
                return status;
            }
            finally {
                this.doneSignal.countDown();
            }
        }

        public AnalysisDatamodel getDatamodel() {
            return this.ad;
        }
    }

    private class WorkspaceTopicEventListener
    extends TopicEventListenerAdapter {
        private WorkspaceTopicEventListener() {
        }

        public void handleEvent(SystemEvent event) {
            try {
                if (!(event instanceof WorkspaceServiceEvent)) {
                    return;
                }
                WorkspaceServiceEvent wsEvent = (WorkspaceServiceEvent)event;
                if ("osint/workspace/projectDeleted".equals(event.getTopic())) {
                    AnalysisServiceImpl.this.datamodelMap.remove(wsEvent.getProjectId());
                    AnalysisServiceImpl.this.fireAnalysisServiceEvent(new AnalysisServiceEventImpl("osint/analysis/datamodelChanged", wsEvent.getProjectId()));
                }
                if (AnalysisServiceImpl.this.ws.hasCaseProject(wsEvent.getProjectId())) {
                    if ("osint/workspace/metaDataChanged".equals(event.getTopic())) {
                        AnalysisServiceImpl.this.datamodelMap.remove(wsEvent.getProjectId());
                        AnalysisServiceImpl.this.fireAnalysisServiceEvent(new AnalysisServiceEventImpl("osint/analysis/datamodelChanged", wsEvent.getProjectId()));
                    }
                    if ("osint/workspace/resourceDeleted".equals(wsEvent.getTopic())) {
                        ResourceId projectId = wsEvent.getProjectId();
                        if (AnalysisServiceImpl.this.datamodelMap.containsKey(projectId)) {
                            AnalysisServiceImpl.this.datamodelMap.remove(projectId);
                            AnalysisServiceImpl.this.fireAnalysisServiceEvent(new AnalysisServiceEventImpl("osint/analysis/datamodelChanged", projectId));
                        }
                    }
                }
            }
            catch (Throwable t) {
                log.error("Error occurred in TopicEventListener", t);
            }
        }
    }
}

