/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.parser;

import it.jrc.osint.analysis.ElementParsingResult;
import it.jrc.osint.analysis.relation.EntityTextPosition;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.operations.OperationStatus;
import java.util.Collections;
import java.util.Set;

public class ElementParsingResultImpl
implements ElementParsingResult {
    private Entity entity;
    private Set<EntityTextPosition> textPositions = Collections.emptySet();
    private OperationStatus status = OperationStatus.OK_STATUS;

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public Set<EntityTextPosition> getTextPositions() {
        return this.textPositions;
    }

    @Override
    public OperationStatus getStatus() {
        return this.status;
    }

    public void setStatus(OperationStatus newStatus) {
        this.status = newStatus;
    }

    void setEntity(Entity anEntity) {
        this.entity = anEntity;
    }

    void setEntityTextPositions(Set<EntityTextPosition> textPositions) {
        this.textPositions = textPositions;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("STATUS:");
        if (this.status.isOK()) {
            strBuilder.append("OK;");
            strBuilder.append(this.getEntity().toDebugString());
            strBuilder.append("TextPositions:");
            for (EntityTextPosition textPos : this.getTextPositions()) {
                strBuilder.append(textPos.toString());
                strBuilder.append(" ");
            }
        } else if (this.status.isError()) {
            strBuilder.append("ERROR;");
            strBuilder.append("condition=");
            strBuilder.append(this.status.getErrorCondition().toString());
        } else if (this.status.isCancel()) {
            strBuilder.append("CANCEL;");
        }
        return strBuilder.toString();
    }
}

